/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapreduce.v2.hs.HSAuditLogger;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class HSAuditLogger {
    private static final Log LOG = LogFactory.getLog(HSAuditLogger.class);

    public static void logSuccess(String user, String operation, String target) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)HSAuditLogger.createSuccessLog((String)user, (String)operation, (String)target));
        }
    }

    static String createSuccessLog(String user, String operation, String target) {
        StringBuilder b = new StringBuilder();
        HSAuditLogger.start((Keys)Keys.USER, (String)user, (StringBuilder)b);
        HSAuditLogger.addRemoteIP((StringBuilder)b);
        HSAuditLogger.add((Keys)Keys.OPERATION, (String)operation, (StringBuilder)b);
        HSAuditLogger.add((Keys)Keys.TARGET, (String)target, (StringBuilder)b);
        HSAuditLogger.add((Keys)Keys.RESULT, (String)"SUCCESS", (StringBuilder)b);
        return b.toString();
    }

    static void addRemoteIP(StringBuilder b) {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            HSAuditLogger.add((Keys)Keys.IP, (String)ip.getHostAddress(), (StringBuilder)b);
        }
    }

    static void add(Keys key, String value, StringBuilder b) {
        b.append('\t').append(key.name()).append("=").append(value);
    }

    static void start(Keys key, String value, StringBuilder b) {
        b.append(key.name()).append("=").append(value);
    }

    public static void logFailure(String user, String operation, String perm, String target, String description) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)HSAuditLogger.createFailureLog((String)user, (String)operation, (String)perm, (String)target, (String)description));
        }
    }

    static String createFailureLog(String user, String operation, String perm, String target, String description) {
        StringBuilder b = new StringBuilder();
        HSAuditLogger.start((Keys)Keys.USER, (String)user, (StringBuilder)b);
        HSAuditLogger.addRemoteIP((StringBuilder)b);
        HSAuditLogger.add((Keys)Keys.OPERATION, (String)operation, (StringBuilder)b);
        HSAuditLogger.add((Keys)Keys.TARGET, (String)target, (StringBuilder)b);
        HSAuditLogger.add((Keys)Keys.RESULT, (String)"FAILURE", (StringBuilder)b);
        HSAuditLogger.add((Keys)Keys.DESCRIPTION, (String)description, (StringBuilder)b);
        HSAuditLogger.add((Keys)Keys.PERMISSIONS, (String)perm, (StringBuilder)b);
        return b.toString();
    }
}

