/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.client;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.v2.hs.HSProxies;
import org.apache.hadoop.mapreduce.v2.hs.protocol.HSAdminRefreshProtocol;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class HSAdmin
extends Configured
implements Tool {
    public HSAdmin() {
    }

    public HSAdmin(Configuration conf) {
        super(conf);
    }

    private static void printUsage(String cmd) {
        if ("-refreshUserToGroupsMappings".equals(cmd)) {
            System.err.println("Usage: mapred hsadmin [-refreshUserToGroupsMappings]");
        } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.err.println("Usage: mapred hsadmin [-refreshSuperUserGroupsConfiguration]");
        } else if ("-refreshAdminAcls".equals(cmd)) {
            System.err.println("Usage: mapred hsadmin [-refreshAdminAcls]");
        } else if ("-refreshLoadedJobCache".equals(cmd)) {
            System.err.println("Usage: mapred hsadmin [-refreshLoadedJobCache]");
        } else if ("-refreshJobRetentionSettings".equals(cmd)) {
            System.err.println("Usage: mapred hsadmin [-refreshJobRetentionSettings]");
        } else if ("-refreshLogRetentionSettings".equals(cmd)) {
            System.err.println("Usage: mapred hsadmin [-refreshLogRetentionSettings]");
        } else if ("-getGroups".equals(cmd)) {
            System.err.println("Usage: mapred hsadmin [-getGroups [username]]");
        } else {
            System.err.println("Usage: mapred hsadmin");
            System.err.println("           [-refreshUserToGroupsMappings]");
            System.err.println("           [-refreshSuperUserGroupsConfiguration]");
            System.err.println("           [-refreshAdminAcls]");
            System.err.println("           [-refreshLoadedJobCache]");
            System.err.println("           [-refreshJobRetentionSettings]");
            System.err.println("           [-refreshLogRetentionSettings]");
            System.err.println("           [-getGroups [username]]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        }
    }

    private static void printHelp(String cmd) {
        String summary = "hsadmin is the command to execute Job History server administrative commands.\nThe full syntax is: \n\nmapred hsadmin [-refreshUserToGroupsMappings] [-refreshSuperUserGroupsConfiguration] [-refreshAdminAcls] [-refreshLoadedJobCache] [-refreshLogRetentionSettings] [-refreshJobRetentionSettings] [-getGroups [username]] [-help [cmd]]\n";
        String refreshUserToGroupsMappings = "-refreshUserToGroupsMappings: Refresh user-to-groups mappings\n";
        String refreshSuperUserGroupsConfiguration = "-refreshSuperUserGroupsConfiguration: Refresh superuser proxy groups mappings\n";
        String refreshAdminAcls = "-refreshAdminAcls: Refresh acls for administration of Job history server\n";
        String refreshLoadedJobCache = "-refreshLoadedJobCache: Refresh loaded job cache of Job history server\n";
        String refreshJobRetentionSettings = "-refreshJobRetentionSettings:Refresh job history period,job cleaner settings\n";
        String refreshLogRetentionSettings = "-refreshLogRetentionSettings:Refresh log retention period and log retention check interval\n";
        String getGroups = "-getGroups [username]: Get the groups which given user belongs to\n";
        String help = "-help [cmd]: \tDisplays help for the given command or all commands if none\n\t\tis specified.\n";
        if ("refreshUserToGroupsMappings".equals(cmd)) {
            System.out.println(refreshUserToGroupsMappings);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else if ("refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.out.println(refreshSuperUserGroupsConfiguration);
        } else if ("refreshAdminAcls".equals(cmd)) {
            System.out.println(refreshAdminAcls);
        } else if ("refreshLoadedJobCache".equals(cmd)) {
            System.out.println(refreshLoadedJobCache);
        } else if ("refreshJobRetentionSettings".equals(cmd)) {
            System.out.println(refreshJobRetentionSettings);
        } else if ("refreshLogRetentionSettings".equals(cmd)) {
            System.out.println(refreshLogRetentionSettings);
        } else if ("getGroups".equals(cmd)) {
            System.out.println(getGroups);
        } else {
            System.out.println(summary);
            System.out.println(refreshUserToGroupsMappings);
            System.out.println(refreshSuperUserGroupsConfiguration);
            System.out.println(refreshAdminAcls);
            System.out.println(refreshLoadedJobCache);
            System.out.println(refreshJobRetentionSettings);
            System.out.println(refreshLogRetentionSettings);
            System.out.println(getGroups);
            System.out.println(help);
            System.out.println();
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        }
    }

    private int getGroups(String[] usernames) throws IOException {
        if (usernames.length == 0) {
            usernames = new String[]{UserGroupInformation.getCurrentUser().getUserName()};
        }
        Configuration conf = this.getConf();
        InetSocketAddress address = conf.getSocketAddr("mapreduce.jobhistory.admin.address", "0.0.0.0:10033", 10033);
        GetUserMappingsProtocol getUserMappingProtocol = HSProxies.createProxy(conf, address, GetUserMappingsProtocol.class, UserGroupInformation.getCurrentUser());
        for (String username : usernames) {
            StringBuilder sb = new StringBuilder();
            sb.append(username + " :");
            for (String group : getUserMappingProtocol.getGroupsForUser(username)) {
                sb.append(" ");
                sb.append(group);
            }
            System.out.println(sb);
        }
        return 0;
    }

    private int refreshUserToGroupsMappings() throws IOException {
        Configuration conf = this.getConf();
        InetSocketAddress address = conf.getSocketAddr("mapreduce.jobhistory.admin.address", "0.0.0.0:10033", 10033);
        RefreshUserMappingsProtocol refreshProtocol = HSProxies.createProxy(conf, address, RefreshUserMappingsProtocol.class, UserGroupInformation.getCurrentUser());
        refreshProtocol.refreshUserToGroupsMappings();
        return 0;
    }

    private int refreshSuperUserGroupsConfiguration() throws IOException {
        Configuration conf = this.getConf();
        InetSocketAddress address = conf.getSocketAddr("mapreduce.jobhistory.admin.address", "0.0.0.0:10033", 10033);
        RefreshUserMappingsProtocol refreshProtocol = HSProxies.createProxy(conf, address, RefreshUserMappingsProtocol.class, UserGroupInformation.getCurrentUser());
        refreshProtocol.refreshSuperUserGroupsConfiguration();
        return 0;
    }

    private int refreshAdminAcls() throws IOException {
        Configuration conf = this.getConf();
        InetSocketAddress address = conf.getSocketAddr("mapreduce.jobhistory.admin.address", "0.0.0.0:10033", 10033);
        HSAdminRefreshProtocol refreshProtocol = HSProxies.createProxy(conf, address, HSAdminRefreshProtocol.class, UserGroupInformation.getCurrentUser());
        refreshProtocol.refreshAdminAcls();
        return 0;
    }

    private int refreshLoadedJobCache() throws IOException {
        Configuration conf = this.getConf();
        InetSocketAddress address = conf.getSocketAddr("mapreduce.jobhistory.admin.address", "0.0.0.0:10033", 10033);
        HSAdminRefreshProtocol refreshProtocol = HSProxies.createProxy(conf, address, HSAdminRefreshProtocol.class, UserGroupInformation.getCurrentUser());
        refreshProtocol.refreshLoadedJobCache();
        return 0;
    }

    private int refreshJobRetentionSettings() throws IOException {
        Configuration conf = this.getConf();
        InetSocketAddress address = conf.getSocketAddr("mapreduce.jobhistory.admin.address", "0.0.0.0:10033", 10033);
        HSAdminRefreshProtocol refreshProtocol = HSProxies.createProxy(conf, address, HSAdminRefreshProtocol.class, UserGroupInformation.getCurrentUser());
        refreshProtocol.refreshJobRetentionSettings();
        return 0;
    }

    private int refreshLogRetentionSettings() throws IOException {
        Configuration conf = this.getConf();
        InetSocketAddress address = conf.getSocketAddr("mapreduce.jobhistory.admin.address", "0.0.0.0:10033", 10033);
        HSAdminRefreshProtocol refreshProtocol = HSProxies.createProxy(conf, address, HSAdminRefreshProtocol.class, UserGroupInformation.getCurrentUser());
        refreshProtocol.refreshLogRetentionSettings();
        return 0;
    }

    public int run(String[] args) throws Exception {
        String cmd;
        if (args.length < 1) {
            HSAdmin.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        if (("-refreshUserToGroupsMappings".equals(cmd = args[i++]) || "-refreshSuperUserGroupsConfiguration".equals(cmd) || "-refreshAdminAcls".equals(cmd) || "-refreshLoadedJobCache".equals(cmd) || "-refreshJobRetentionSettings".equals(cmd) || "-refreshLogRetentionSettings".equals(cmd)) && args.length != 1) {
            HSAdmin.printUsage(cmd);
            return exitCode;
        }
        exitCode = 0;
        if ("-refreshUserToGroupsMappings".equals(cmd)) {
            exitCode = this.refreshUserToGroupsMappings();
        } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
            exitCode = this.refreshSuperUserGroupsConfiguration();
        } else if ("-refreshAdminAcls".equals(cmd)) {
            exitCode = this.refreshAdminAcls();
        } else if ("-refreshLoadedJobCache".equals(cmd)) {
            exitCode = this.refreshLoadedJobCache();
        } else if ("-refreshJobRetentionSettings".equals(cmd)) {
            exitCode = this.refreshJobRetentionSettings();
        } else if ("-refreshLogRetentionSettings".equals(cmd)) {
            exitCode = this.refreshLogRetentionSettings();
        } else if ("-getGroups".equals(cmd)) {
            String[] usernames = Arrays.copyOfRange(args, i, args.length);
            exitCode = this.getGroups(usernames);
        } else if ("-help".equals(cmd)) {
            if (i < args.length) {
                HSAdmin.printHelp(args[i]);
            } else {
                HSAdmin.printHelp("");
            }
        } else {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": Unknown command");
            HSAdmin.printUsage("");
        }
        return exitCode;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new HSAdmin(), (String[])args);
        System.exit(result);
    }
}

