/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp.dao;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CompletedJob;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryEntities;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJobInfo {
    @Test(timeout=10000L)
    public void testAverageMergeTime() throws IOException {
        String historyFileName = "job_1329348432655_0001-1329348443227-user-Sleep+job-1329348468601-10-1-SUCCEEDED-default.jhist";
        String confFileName = "job_1329348432655_0001_conf.xml";
        Configuration conf = new Configuration();
        JobACLsManager jobAclsMgr = new JobACLsManager(conf);
        Path fulleHistoryPath = new Path(TestJobHistoryEntities.class.getClassLoader().getResource(historyFileName).getFile());
        Path fullConfPath = new Path(TestJobHistoryEntities.class.getClassLoader().getResource(confFileName).getFile());
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)fullConfPath);
        JobId jobId = MRBuilderUtils.newJobId((long)1329348432655L, (int)1, (int)1);
        CompletedJob completedJob = new CompletedJob(conf, jobId, fulleHistoryPath, true, "user", info, jobAclsMgr);
        JobInfo jobInfo = new JobInfo((Job)completedJob);
        Assert.assertEquals((long)50L, (long)jobInfo.getAvgMergeTime());
    }
}

