/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.HistoryViewer;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.JobIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskIdPBImpl;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.CompletedTask;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.hs.PartialJob;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryEvents;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryParsing;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobsInfo;
import org.apache.hadoop.mapreduce.v2.jobhistory.FileNameIndexUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.RackResolver;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestJobHistoryParsing {
    private static final Log LOG = LogFactory.getLog(TestJobHistoryParsing.class);
    private static final String RACK_NAME = "/MyRackName";
    private ByteArrayOutputStream outContent = new ByteArrayOutputStream();

    @Test(timeout=50000L)
    public void testJobInfo() throws Exception {
        JobHistoryParser.JobInfo info = new JobHistoryParser.JobInfo();
        junit.framework.Assert.assertEquals((String)"NORMAL", (String)info.getPriority());
        info.printAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testHistoryParsing() throws Exception {
        LOG.info((Object)"STARTING testHistoryParsing()");
        try {
            this.checkHistoryParsing(2, 1, 2);
        }
        finally {
            LOG.info((Object)"FINISHED testHistoryParsing()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testHistoryParsingWithParseErrors() throws Exception {
        LOG.info((Object)"STARTING testHistoryParsingWithParseErrors()");
        try {
            this.checkHistoryParsing(3, 0, 2);
        }
        finally {
            LOG.info((Object)"FINISHED testHistoryParsingWithParseErrors()");
        }
    }

    private static String getJobSummary(FileContext fc, Path path) throws IOException {
        Path qPath = fc.makeQualified(path);
        FSDataInputStream in = fc.open(qPath);
        String jobSummaryString = in.readUTF();
        in.close();
        return jobSummaryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHistoryParsing(int numMaps, int numReduces, int numSuccessfulMaps) throws Exception {
        long numFinishedMaps;
        JobHistoryParser.JobInfo jobInfo;
        Object keypair;
        Configuration conf = new Configuration();
        conf.set("mapreduce.job.user.name", System.getProperty("user.name"));
        long amStartTimeEst = System.currentTimeMillis();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        RackResolver.init((Configuration)conf);
        TestJobHistoryEvents.MRAppWithHistory app = new TestJobHistoryEvents.MRAppWithHistory(numMaps, numReduces, true, this.getClass().getName(), true);
        app.submit(conf);
        Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
        JobId jobId = job.getID();
        LOG.info((Object)("JOBID is " + TypeConverter.fromYarn((JobId)jobId).toString()));
        app.waitForState(job, JobState.SUCCEEDED);
        app.waitForState(Service.STATE.STOPPED);
        String jobhistoryDir = JobHistoryUtils.getHistoryIntermediateDoneDirForUser((Configuration)conf);
        FileContext fc = null;
        try {
            fc = FileContext.getFileContext((Configuration)conf);
        }
        catch (IOException ioe) {
            LOG.info((Object)"Can not get FileContext", (Throwable)ioe);
            throw new Exception("Can not get File Context");
        }
        if (numMaps == numSuccessfulMaps) {
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobId);
            Path summaryFile = new Path(jobhistoryDir, summaryFileName);
            String jobSummaryString = TestJobHistoryParsing.getJobSummary((FileContext)fc, (Path)summaryFile);
            junit.framework.Assert.assertNotNull((Object)jobSummaryString);
            junit.framework.Assert.assertTrue((boolean)jobSummaryString.contains("resourcesPerMap=100"));
            junit.framework.Assert.assertTrue((boolean)jobSummaryString.contains("resourcesPerReduce=100"));
            HashMap<String, String> jobSummaryElements = new HashMap<String, String>();
            StringTokenizer strToken = new StringTokenizer(jobSummaryString, ",");
            while (strToken.hasMoreTokens()) {
                keypair = strToken.nextToken();
                jobSummaryElements.put(((String)keypair).split("=")[0], ((String)keypair).split("=")[1]);
            }
            junit.framework.Assert.assertEquals((String)"JobId does not match", (String)jobId.toString(), (String)((String)jobSummaryElements.get("jobId")));
            junit.framework.Assert.assertEquals((String)"JobName does not match", (String)"test", (String)((String)jobSummaryElements.get("jobName")));
            junit.framework.Assert.assertTrue((String)"submitTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("submitTime")) != 0L ? 1 : 0) != 0);
            junit.framework.Assert.assertTrue((String)"launchTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("launchTime")) != 0L ? 1 : 0) != 0);
            junit.framework.Assert.assertTrue((String)"firstMapTaskLaunchTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("firstMapTaskLaunchTime")) != 0L ? 1 : 0) != 0);
            junit.framework.Assert.assertTrue((String)"firstReduceTaskLaunchTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("firstReduceTaskLaunchTime")) != 0L ? 1 : 0) != 0);
            junit.framework.Assert.assertTrue((String)"finishTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("finishTime")) != 0L ? 1 : 0) != 0);
            junit.framework.Assert.assertEquals((String)"Mismatch in num map slots", (int)numSuccessfulMaps, (int)Integer.parseInt((String)jobSummaryElements.get("numMaps")));
            junit.framework.Assert.assertEquals((String)"Mismatch in num reduce slots", (int)numReduces, (int)Integer.parseInt((String)jobSummaryElements.get("numReduces")));
            junit.framework.Assert.assertEquals((String)"User does not match", (String)System.getProperty("user.name"), (String)((String)jobSummaryElements.get("user")));
            junit.framework.Assert.assertEquals((String)"Queue does not match", (String)"default", (String)((String)jobSummaryElements.get("queue")));
            junit.framework.Assert.assertEquals((String)"Status does not match", (String)"SUCCEEDED", (String)((String)jobSummaryElements.get("status")));
        }
        JobHistory jobHistory = new JobHistory();
        jobHistory.init(conf);
        HistoryFileManager.HistoryFileInfo fileInfo = jobHistory.getJobFileInfo(jobId);
        keypair = fileInfo;
        synchronized (keypair) {
            Path historyFilePath = fileInfo.getHistoryFile();
            FSDataInputStream in = null;
            LOG.info((Object)("JobHistoryFile is: " + historyFilePath));
            try {
                in = fc.open(fc.makeQualified(historyFilePath));
            }
            catch (IOException ioe) {
                LOG.info((Object)("Can not open history file: " + historyFilePath), (Throwable)ioe);
                throw new Exception("Can not open History File");
            }
            JobHistoryParser parser = new JobHistoryParser(in);
            EventReader realReader = new EventReader((DataInputStream)in);
            EventReader reader = (EventReader)Mockito.mock(EventReader.class);
            if (numMaps == numSuccessfulMaps) {
                reader = realReader;
            } else {
                AtomicInteger numFinishedEvents = new AtomicInteger(0);
                Mockito.when((Object)reader.getNextEvent()).thenAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */);
            }
            jobInfo = parser.parse(reader);
            numFinishedMaps = this.computeFinishedMaps(jobInfo, numMaps, numSuccessfulMaps);
            if (numFinishedMaps != (long)numMaps) {
                IOException parseException = parser.getParseException();
                junit.framework.Assert.assertNotNull((String)"Didn't get expected parse exception", (Object)parseException);
            }
        }
        junit.framework.Assert.assertEquals((String)"Incorrect username ", (String)System.getProperty("user.name"), (String)jobInfo.getUsername());
        junit.framework.Assert.assertEquals((String)"Incorrect jobName ", (String)"test", (String)jobInfo.getJobname());
        junit.framework.Assert.assertEquals((String)"Incorrect queuename ", (String)"default", (String)jobInfo.getJobQueueName());
        junit.framework.Assert.assertEquals((String)"incorrect conf path", (String)"test", (String)jobInfo.getJobConfPath());
        junit.framework.Assert.assertEquals((String)"incorrect finishedMap ", (long)numSuccessfulMaps, (long)numFinishedMaps);
        junit.framework.Assert.assertEquals((String)"incorrect finishedReduces ", (long)numReduces, (long)jobInfo.getFinishedReduces());
        junit.framework.Assert.assertEquals((String)"incorrect uberized ", (boolean)job.isUber(), (boolean)jobInfo.getUberized());
        Map allTasks = jobInfo.getAllTasks();
        int totalTasks = allTasks.size();
        junit.framework.Assert.assertEquals((String)"total number of tasks is incorrect  ", (int)(numMaps + numReduces), (int)totalTasks);
        junit.framework.Assert.assertEquals((int)1, (int)jobInfo.getAMInfos().size());
        junit.framework.Assert.assertEquals((String)MRApp.NM_HOST, (String)((JobHistoryParser.AMInfo)jobInfo.getAMInfos().get(0)).getNodeManagerHost());
        JobHistoryParser.AMInfo amInfo = (JobHistoryParser.AMInfo)jobInfo.getAMInfos().get(0);
        junit.framework.Assert.assertEquals((int)MRApp.NM_PORT, (int)amInfo.getNodeManagerPort());
        junit.framework.Assert.assertEquals((int)MRApp.NM_HTTP_PORT, (int)amInfo.getNodeManagerHttpPort());
        junit.framework.Assert.assertEquals((int)1, (int)amInfo.getAppAttemptId().getAttemptId());
        junit.framework.Assert.assertEquals((Object)amInfo.getAppAttemptId(), (Object)amInfo.getContainerId().getApplicationAttemptId());
        junit.framework.Assert.assertTrue((amInfo.getStartTime() <= System.currentTimeMillis() && amInfo.getStartTime() >= amStartTimeEst ? 1 : 0) != 0);
        ContainerId fakeCid = MRApp.newContainerId((int)-1, (int)-1, (long)-1L, (int)-1);
        for (JobHistoryParser.TaskInfo taskInfo : allTasks.values()) {
            int taskAttemptCount = taskInfo.getAllTaskAttempts().size();
            junit.framework.Assert.assertEquals((String)"total number of task attempts ", (int)1, (int)taskAttemptCount);
            JobHistoryParser.TaskAttemptInfo taInfo = (JobHistoryParser.TaskAttemptInfo)taskInfo.getAllTaskAttempts().values().iterator().next();
            junit.framework.Assert.assertNotNull((Object)taInfo.getContainerId());
            junit.framework.Assert.assertFalse((boolean)taInfo.getContainerId().equals((Object)fakeCid));
        }
        for (Task task : job.getTasks().values()) {
            JobHistoryParser.TaskInfo taskInfo = (JobHistoryParser.TaskInfo)allTasks.get(TypeConverter.fromYarn((TaskId)task.getID()));
            junit.framework.Assert.assertNotNull((String)"TaskInfo not found", (Object)taskInfo);
            for (TaskAttempt taskAttempt : task.getAttempts().values()) {
                JobHistoryParser.TaskAttemptInfo taskAttemptInfo = (JobHistoryParser.TaskAttemptInfo)taskInfo.getAllTaskAttempts().get(TypeConverter.fromYarn((TaskAttemptId)taskAttempt.getID()));
                junit.framework.Assert.assertNotNull((String)"TaskAttemptInfo not found", (Object)taskAttemptInfo);
                junit.framework.Assert.assertEquals((String)"Incorrect shuffle port for task attempt", (int)taskAttempt.getShufflePort(), (int)taskAttemptInfo.getShufflePort());
                if (numMaps != numSuccessfulMaps) continue;
                junit.framework.Assert.assertEquals((String)MRApp.NM_HOST, (String)taskAttemptInfo.getHostname());
                junit.framework.Assert.assertEquals((int)MRApp.NM_PORT, (int)taskAttemptInfo.getPort());
                junit.framework.Assert.assertEquals((String)"rack-name is incorrect", (String)taskAttemptInfo.getRackname(), (String)"/MyRackName");
            }
        }
        PrintStream stdps = System.out;
        try {
            System.setOut(new PrintStream(this.outContent));
            HistoryViewer viewer = new HistoryViewer(fc.makeQualified(fileInfo.getHistoryFile()).toString(), conf, true);
            viewer.print();
            for (JobHistoryParser.TaskInfo taskInfo : allTasks.values()) {
                String test = (taskInfo.getTaskStatus() == null ? "" : taskInfo.getTaskStatus()) + " " + taskInfo.getTaskType() + " task list for " + taskInfo.getTaskId().getJobID();
                junit.framework.Assert.assertTrue((this.outContent.toString().indexOf(test) > 0 ? 1 : 0) != 0);
                junit.framework.Assert.assertTrue((this.outContent.toString().indexOf(taskInfo.getTaskId().toString()) > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            System.setOut(stdps);
        }
    }

    private long computeFinishedMaps(JobHistoryParser.JobInfo jobInfo, int numMaps, int numSuccessfulMaps) {
        if (numMaps == numSuccessfulMaps) {
            return jobInfo.getFinishedMaps();
        }
        long numFinishedMaps = 0L;
        Map taskInfos = jobInfo.getAllTasks();
        for (JobHistoryParser.TaskInfo taskInfo : taskInfos.values()) {
            if (!TaskState.SUCCEEDED.toString().equals(taskInfo.getTaskStatus())) continue;
            ++numFinishedMaps;
        }
        return numFinishedMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testHistoryParsingForFailedAttempts() throws Exception {
        LOG.info((Object)"STARTING testHistoryParsingForFailedAttempts");
        try {
            Configuration conf = new Configuration();
            conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)conf);
            MRAppWithHistoryWithFailedAttempt app = new MRAppWithHistoryWithFailedAttempt(2, 1, true, this.getClass().getName(), true);
            app.submit(conf);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            JobId jobId = job.getID();
            app.waitForState(job, JobState.SUCCEEDED);
            app.waitForState(Service.STATE.STOPPED);
            String jobhistoryDir = JobHistoryUtils.getHistoryIntermediateDoneDirForUser((Configuration)conf);
            JobHistory jobHistory = new JobHistory();
            jobHistory.init(conf);
            JobIndexInfo jobIndexInfo = jobHistory.getJobFileInfo(jobId).getJobIndexInfo();
            String jobhistoryFileName = FileNameIndexUtils.getDoneFileName((JobIndexInfo)jobIndexInfo);
            Path historyFilePath = new Path(jobhistoryDir, jobhistoryFileName);
            FSDataInputStream in = null;
            FileContext fc = null;
            try {
                fc = FileContext.getFileContext((Configuration)conf);
                in = fc.open(fc.makeQualified(historyFilePath));
            }
            catch (IOException ioe) {
                LOG.info((Object)("Can not open history file: " + historyFilePath), (Throwable)ioe);
                throw new Exception("Can not open History File");
            }
            JobHistoryParser parser = new JobHistoryParser(in);
            JobHistoryParser.JobInfo jobInfo = parser.parse();
            IOException parseException = parser.getParseException();
            junit.framework.Assert.assertNull((String)("Caught an expected exception " + parseException), (Object)parseException);
            int noOffailedAttempts = 0;
            Map allTasks = jobInfo.getAllTasks();
            for (Task task : job.getTasks().values()) {
                JobHistoryParser.TaskInfo taskInfo = (JobHistoryParser.TaskInfo)allTasks.get(TypeConverter.fromYarn((TaskId)task.getID()));
                for (TaskAttempt taskAttempt : task.getAttempts().values()) {
                    JobHistoryParser.TaskAttemptInfo taskAttemptInfo = (JobHistoryParser.TaskAttemptInfo)taskInfo.getAllTaskAttempts().get(TypeConverter.fromYarn((TaskAttemptId)taskAttempt.getID()));
                    junit.framework.Assert.assertEquals((String)"rack-name is incorrect", (String)taskAttemptInfo.getRackname(), (String)"/MyRackName");
                    if (!taskAttemptInfo.getTaskStatus().equals("FAILED")) continue;
                    ++noOffailedAttempts;
                }
            }
            junit.framework.Assert.assertEquals((String)"No of Failed tasks doesn't match.", (int)2, (int)noOffailedAttempts);
        }
        finally {
            LOG.info((Object)"FINISHED testHistoryParsingForFailedAttempts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCountersForFailedTask() throws Exception {
        LOG.info((Object)"STARTING testCountersForFailedTask");
        try {
            Configuration conf = new Configuration();
            conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)conf);
            MRAppWithHistoryWithFailedTask app = new MRAppWithHistoryWithFailedTask(2, 1, true, this.getClass().getName(), true);
            app.submit(conf);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            JobId jobId = job.getID();
            app.waitForState(job, JobState.FAILED);
            app.waitForState(Service.STATE.STOPPED);
            String jobhistoryDir = JobHistoryUtils.getHistoryIntermediateDoneDirForUser((Configuration)conf);
            JobHistory jobHistory = new JobHistory();
            jobHistory.init(conf);
            JobIndexInfo jobIndexInfo = jobHistory.getJobFileInfo(jobId).getJobIndexInfo();
            String jobhistoryFileName = FileNameIndexUtils.getDoneFileName((JobIndexInfo)jobIndexInfo);
            Path historyFilePath = new Path(jobhistoryDir, jobhistoryFileName);
            FSDataInputStream in = null;
            FileContext fc = null;
            try {
                fc = FileContext.getFileContext((Configuration)conf);
                in = fc.open(fc.makeQualified(historyFilePath));
            }
            catch (IOException ioe) {
                LOG.info((Object)("Can not open history file: " + historyFilePath), (Throwable)ioe);
                throw new Exception("Can not open History File");
            }
            JobHistoryParser parser = new JobHistoryParser(in);
            JobHistoryParser.JobInfo jobInfo = parser.parse();
            IOException parseException = parser.getParseException();
            junit.framework.Assert.assertNull((String)("Caught an expected exception " + parseException), (Object)parseException);
            for (Map.Entry entry : jobInfo.getAllTasks().entrySet()) {
                TaskId yarnTaskID = TypeConverter.toYarn((TaskID)((TaskID)entry.getKey()));
                CompletedTask ct = new CompletedTask(yarnTaskID, (JobHistoryParser.TaskInfo)entry.getValue());
                junit.framework.Assert.assertNotNull((String)"completed task report has null counters", (Object)ct.getReport().getCounters());
            }
        }
        finally {
            LOG.info((Object)"FINISHED testCountersForFailedTask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testScanningOldDirs() throws Exception {
        LOG.info((Object)"STARTING testScanningOldDirs");
        try {
            int msecToSleep;
            Configuration conf = new Configuration();
            conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)conf);
            TestJobHistoryEvents.MRAppWithHistory app = new TestJobHistoryEvents.MRAppWithHistory(1, 1, true, this.getClass().getName(), true);
            app.submit(conf);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            JobId jobId = job.getID();
            LOG.info((Object)("JOBID is " + TypeConverter.fromYarn((JobId)jobId).toString()));
            app.waitForState(job, JobState.SUCCEEDED);
            app.waitForState(Service.STATE.STOPPED);
            HistoryFileManagerForTest hfm = new HistoryFileManagerForTest();
            hfm.init(conf);
            HistoryFileManager.HistoryFileInfo fileInfo = hfm.getFileInfo(jobId);
            junit.framework.Assert.assertNotNull((String)"Unable to locate job history", (Object)fileInfo);
            hfm.deleteJobFromJobListCache(fileInfo);
            int msecPerSleep = 10;
            for (msecToSleep = 10000; fileInfo.isMovePending() && msecToSleep > 0; msecToSleep -= 10) {
                junit.framework.Assert.assertTrue((!fileInfo.didMoveFail() ? 1 : 0) != 0);
                Thread.sleep(10L);
            }
            junit.framework.Assert.assertTrue((String)"Timeout waiting for history move", (msecToSleep > 0 ? 1 : 0) != 0);
            fileInfo = hfm.getFileInfo(jobId);
            hfm.stop();
            junit.framework.Assert.assertNotNull((String)"Unable to locate old job history", (Object)fileInfo);
            junit.framework.Assert.assertTrue((String)"HistoryFileManager not shutdown properly", (boolean)hfm.moveToDoneExecutor.isTerminated());
        }
        finally {
            LOG.info((Object)"FINISHED testScanningOldDirs");
        }
    }

    public static void main(String[] args) throws Exception {
        TestJobHistoryParsing t = new TestJobHistoryParsing();
        t.testHistoryParsing();
        t.testHistoryParsingForFailedAttempts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void testDeleteFileInfo() throws Exception {
        LOG.info((Object)"STARTING testDeleteFileInfo");
        try {
            Configuration conf = new Configuration();
            conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)conf);
            TestJobHistoryEvents.MRAppWithHistory app = new TestJobHistoryEvents.MRAppWithHistory(1, 1, true, this.getClass().getName(), true);
            app.submit(conf);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            JobId jobId = job.getID();
            app.waitForState(job, JobState.SUCCEEDED);
            app.waitForState(Service.STATE.STOPPED);
            HistoryFileManager hfm = new HistoryFileManager();
            hfm.init(conf);
            HistoryFileManager.HistoryFileInfo fileInfo = hfm.getFileInfo(jobId);
            hfm.initExisting();
            while (fileInfo.isMovePending()) {
                Thread.sleep(300L);
            }
            junit.framework.Assert.assertNotNull((Object)hfm.jobListCache.values());
            hfm.clean();
            junit.framework.Assert.assertFalse((boolean)fileInfo.isDeleted());
            hfm.setMaxHistoryAge(-1L);
            hfm.clean();
            hfm.stop();
            junit.framework.Assert.assertTrue((String)"Thread pool shutdown", (boolean)hfm.moveToDoneExecutor.isTerminated());
            junit.framework.Assert.assertTrue((String)"file should be deleted ", (boolean)fileInfo.isDeleted());
        }
        finally {
            LOG.info((Object)"FINISHED testDeleteFileInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testJobHistoryMethods() throws Exception {
        LOG.info((Object)"STARTING testJobHistoryMethods");
        try {
            Configuration configuration = new Configuration();
            configuration.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)configuration);
            TestJobHistoryEvents.MRAppWithHistory app = new TestJobHistoryEvents.MRAppWithHistory(1, 1, true, this.getClass().getName(), true);
            app.submit(configuration);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            app.waitForState(job, JobState.SUCCEEDED);
            JobHistory jobHistory = new JobHistory();
            jobHistory.init(configuration);
            junit.framework.Assert.assertEquals((int)1, (int)jobHistory.getAllJobs().size());
            junit.framework.Assert.assertEquals((int)1, (int)jobHistory.getAllJobs(app.getAppID()).size());
            JobsInfo jobsinfo = jobHistory.getPartialJobs(Long.valueOf(0L), Long.valueOf(10L), null, "default", Long.valueOf(0L), Long.valueOf(System.currentTimeMillis() + 1L), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis() + 1L), JobState.SUCCEEDED);
            junit.framework.Assert.assertEquals((int)1, (int)jobsinfo.getJobs().size());
            junit.framework.Assert.assertNotNull((Object)jobHistory.getApplicationAttemptId());
            junit.framework.Assert.assertEquals((String)"application_0_0000", (String)jobHistory.getApplicationID().toString());
            junit.framework.Assert.assertEquals((String)"Job History Server", (String)jobHistory.getApplicationName());
            junit.framework.Assert.assertNull((Object)jobHistory.getEventHandler());
            junit.framework.Assert.assertNull((Object)jobHistory.getClock());
            junit.framework.Assert.assertNull((Object)jobHistory.getClusterInfo());
        }
        finally {
            LOG.info((Object)"FINISHED testJobHistoryMethods");
        }
    }

    @Test(timeout=1000L)
    public void testPartialJob() throws Exception {
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        JobIndexInfo jii = new JobIndexInfo(0L, System.currentTimeMillis(), "user", "jobName", (JobId)jobId, 3, 2, "JobStatus");
        PartialJob test = new PartialJob(jii, (JobId)jobId);
        junit.framework.Assert.assertEquals((double)1.0, (double)test.getProgress(), (double)0.001);
        Assert.assertNull((Object)test.getAllCounters());
        Assert.assertNull((Object)test.getTasks());
        Assert.assertNull((Object)test.getTasks(TaskType.MAP));
        Assert.assertNull((Object)test.getTask((TaskId)new TaskIdPBImpl()));
        Assert.assertNull((Object)test.getTaskAttemptCompletionEvents(0, 100));
        Assert.assertNull((Object)test.getMapAttemptCompletionEvents(0, 100));
        Assert.assertTrue((boolean)test.checkAccess(UserGroupInformation.getCurrentUser(), null));
        Assert.assertNull((Object)test.getAMInfos());
    }
}

