/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapreduce.jobhistory.JobSummary;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.jobhistory.FileNameIndexUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ShutdownThreadsHelper;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class HistoryFileManager
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(HistoryFileManager.class);
    private static final Log SUMMARY_LOG = LogFactory.getLog(JobSummary.class);
    private static String DONE_BEFORE_SERIAL_TAIL = JobHistoryUtils.doneSubdirsBeforeSerialTail();
    private SerialNumberIndex serialNumberIndex = null;
    protected JobListCache jobListCache = null;
    private final Set<Path> existingDoneSubdirs = Collections.synchronizedSet(new HashSet());
    private ConcurrentMap<String, UserLogDir> userDirModificationTimeMap = new ConcurrentHashMap();
    private JobACLsManager aclsMgr;
    private Configuration conf;
    private String serialNumberFormat;
    private Path doneDirPrefixPath = null;
    private FileContext doneDirFc;
    private Path intermediateDoneDirPath = null;
    private FileContext intermediateDoneDirFc;
    @VisibleForTesting
    protected ThreadPoolExecutor moveToDoneExecutor = null;
    private long maxHistoryAge = 0L;

    public HistoryFileManager() {
        super(HistoryFileManager.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        int serialNumberLowDigits = 3;
        this.serialNumberFormat = "%0" + (6 + serialNumberLowDigits) + "d";
        String doneDirPrefix = null;
        doneDirPrefix = JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)conf);
        try {
            this.doneDirPrefixPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(doneDirPrefix));
            this.doneDirFc = FileContext.getFileContext((URI)this.doneDirPrefixPath.toUri(), (Configuration)conf);
            this.doneDirFc.setUMask(JobHistoryUtils.HISTORY_DONE_DIR_UMASK);
            this.mkdir(this.doneDirFc, this.doneDirPrefixPath, new FsPermission(JobHistoryUtils.HISTORY_DONE_DIR_PERMISSION));
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Error creating done directory: [" + this.doneDirPrefixPath + "]", (Throwable)e);
        }
        String intermediateDoneDirPrefix = null;
        intermediateDoneDirPrefix = JobHistoryUtils.getConfiguredHistoryIntermediateDoneDirPrefix((Configuration)conf);
        try {
            this.intermediateDoneDirPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(intermediateDoneDirPrefix));
            this.intermediateDoneDirFc = FileContext.getFileContext((URI)this.intermediateDoneDirPath.toUri(), (Configuration)conf);
            this.mkdir(this.intermediateDoneDirFc, this.intermediateDoneDirPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_DONE_DIR_PERMISSIONS.toShort()));
        }
        catch (IOException e) {
            LOG.info((Object)("error creating done directory on dfs " + e));
            throw new YarnRuntimeException("Error creating intermediate done directory: [" + this.intermediateDoneDirPath + "]", (Throwable)e);
        }
        this.aclsMgr = new JobACLsManager(conf);
        this.maxHistoryAge = conf.getLong("mapreduce.jobhistory.max-age-ms", 604800000L);
        this.jobListCache = new JobListCache(conf.getInt("mapreduce.jobhistory.joblist.cache.size", 20000), this.maxHistoryAge);
        this.serialNumberIndex = new SerialNumberIndex(conf.getInt("mapreduce.jobhistory.datestring.cache.size", 200000));
        int numMoveThreads = conf.getInt("mapreduce.jobhistory.move.thread-count", 3);
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("MoveIntermediateToDone Thread #%d").build();
        this.moveToDoneExecutor = new ThreadPoolExecutor(numMoveThreads, numMoveThreads, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        super.serviceInit(conf);
    }

    public void serviceStop() throws Exception {
        ShutdownThreadsHelper.shutdownExecutorService((ExecutorService)this.moveToDoneExecutor);
        super.serviceStop();
    }

    private void mkdir(FileContext fc, Path path, FsPermission fsp) throws IOException {
        if (!fc.util().exists(path)) {
            try {
                fc.mkdir(path, fsp, true);
                FileStatus fsStatus = fc.getFileStatus(path);
                LOG.info((Object)("Perms after creating " + fsStatus.getPermission().toShort() + ", Expected: " + fsp.toShort()));
                if (fsStatus.getPermission().toShort() != fsp.toShort()) {
                    LOG.info((Object)("Explicitly setting permissions to : " + fsp.toShort() + ", " + fsp));
                    fc.setPermission(path, fsp);
                }
            }
            catch (FileAlreadyExistsException e) {
                LOG.info((Object)("Directory: [" + path + "] already exists."));
            }
        }
    }

    void initExisting() throws IOException {
        LOG.info((Object)"Initializing Existing Jobs...");
        List timestampedDirList = this.findTimestampedDirectories();
        Collections.sort(timestampedDirList);
        for (FileStatus fs : timestampedDirList) {
            this.addDirectoryToSerialNumberIndex(fs.getPath());
            this.addDirectoryToJobListCache(fs.getPath());
        }
    }

    private void removeDirectoryFromSerialNumberIndex(Path serialDirPath) {
        String serialPart = serialDirPath.getName();
        String timeStampPart = JobHistoryUtils.getTimestampPartFromPath((String)serialDirPath.toString());
        if (timeStampPart == null) {
            LOG.warn((Object)("Could not find timestamp portion from path: " + serialDirPath.toString() + ". Continuing with next"));
            return;
        }
        if (serialPart == null) {
            LOG.warn((Object)("Could not find serial portion from path: " + serialDirPath.toString() + ". Continuing with next"));
            return;
        }
        this.serialNumberIndex.remove(serialPart, timeStampPart);
    }

    private void addDirectoryToSerialNumberIndex(Path serialDirPath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding " + serialDirPath + " to serial index"));
        }
        String serialPart = serialDirPath.getName();
        String timestampPart = JobHistoryUtils.getTimestampPartFromPath((String)serialDirPath.toString());
        if (timestampPart == null) {
            LOG.warn((Object)("Could not find timestamp portion from path: " + serialDirPath + ". Continuing with next"));
            return;
        }
        if (serialPart == null) {
            LOG.warn((Object)("Could not find serial portion from path: " + serialDirPath.toString() + ". Continuing with next"));
        } else {
            this.serialNumberIndex.add(serialPart, timestampPart);
        }
    }

    private void addDirectoryToJobListCache(Path path) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding " + path + " to job list cache."));
        }
        List historyFileList = HistoryFileManager.scanDirectoryForHistoryFiles((Path)path, (FileContext)this.doneDirFc);
        for (FileStatus fs : historyFileList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding in history for " + fs.getPath()));
            }
            JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)fs.getPath().getName());
            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobIndexInfo.getJobId());
            HistoryFileInfo fileInfo = new HistoryFileInfo(this, fs.getPath(), new Path(fs.getPath().getParent(), confFileName), new Path(fs.getPath().getParent(), summaryFileName), jobIndexInfo, true, null);
            this.jobListCache.addIfAbsent(fileInfo);
        }
    }

    private static List<FileStatus> scanDirectory(Path path, FileContext fc, PathFilter pathFilter) throws IOException {
        path = fc.makeQualified(path);
        ArrayList<FileStatus> jhStatusList = new ArrayList<FileStatus>();
        RemoteIterator fileStatusIter = fc.listStatus(path);
        while (fileStatusIter.hasNext()) {
            FileStatus fileStatus = (FileStatus)fileStatusIter.next();
            Path filePath = fileStatus.getPath();
            if (!fileStatus.isFile() || !pathFilter.accept(filePath)) continue;
            jhStatusList.add(fileStatus);
        }
        return jhStatusList;
    }

    private static List<FileStatus> scanDirectoryForHistoryFiles(Path path, FileContext fc) throws IOException {
        return HistoryFileManager.scanDirectory((Path)path, (FileContext)fc, (PathFilter)JobHistoryUtils.getHistoryFileFilter());
    }

    private List<FileStatus> findTimestampedDirectories() throws IOException {
        List fsList = JobHistoryUtils.localGlobber((FileContext)this.doneDirFc, (Path)this.doneDirPrefixPath, (String)DONE_BEFORE_SERIAL_TAIL);
        return fsList;
    }

    void scanIntermediateDirectory() throws IOException {
        List userDirList = JobHistoryUtils.localGlobber((FileContext)this.intermediateDoneDirFc, (Path)this.intermediateDoneDirPath, (String)"");
        LOG.debug((Object)"Scanning intermediate dirs");
        for (FileStatus userDir : userDirList) {
            UserLogDir old;
            String name = userDir.getPath().getName();
            UserLogDir dir = (UserLogDir)this.userDirModificationTimeMap.get(name);
            if (dir == null && (old = this.userDirModificationTimeMap.putIfAbsent(name, dir = new UserLogDir(this, null))) != null) {
                dir = old;
            }
            dir.scanIfNeeded(userDir);
        }
    }

    private void scanIntermediateDirectory(Path absPath) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scanning intermediate dir " + absPath));
        }
        List fileStatusList = HistoryFileManager.scanDirectoryForHistoryFiles((Path)absPath, (FileContext)this.intermediateDoneDirFc);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found " + fileStatusList.size() + " files"));
        }
        for (FileStatus fs : fileStatusList) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("scanning file: " + fs.getPath()));
            }
            JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)fs.getPath().getName());
            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobIndexInfo.getJobId());
            HistoryFileInfo fileInfo = new HistoryFileInfo(this, fs.getPath(), new Path(fs.getPath().getParent(), confFileName), new Path(fs.getPath().getParent(), summaryFileName), jobIndexInfo, false, null);
            HistoryFileInfo old = this.jobListCache.addIfAbsent(fileInfo);
            if (old == null || old.didMoveFail()) {
                HistoryFileInfo found = old == null ? fileInfo : old;
                long cutoff = System.currentTimeMillis() - this.maxHistoryAge;
                if (found.getJobIndexInfo().getFinishTime() <= cutoff) {
                    try {
                        HistoryFileInfo.access$200((HistoryFileInfo)found);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Error cleaning up a HistoryFile that is out of date.", (Throwable)e);
                    }
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Scheduling move to done of " + found));
                }
                this.moveToDoneExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                continue;
            }
            if (old == null || old.isMovePending()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Duplicate: deleting");
            }
            HistoryFileInfo.access$200((HistoryFileInfo)fileInfo);
        }
    }

    private HistoryFileInfo getJobFileInfo(List<FileStatus> fileStatusList, JobId jobId) throws IOException {
        for (FileStatus fs : fileStatusList) {
            JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)fs.getPath().getName());
            if (!jobIndexInfo.getJobId().equals((Object)jobId)) continue;
            String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobIndexInfo.getJobId());
            HistoryFileInfo fileInfo = new HistoryFileInfo(this, fs.getPath(), new Path(fs.getPath().getParent(), confFileName), new Path(fs.getPath().getParent(), summaryFileName), jobIndexInfo, true, null);
            return fileInfo;
        }
        return null;
    }

    private HistoryFileInfo scanOldDirsForJob(JobId jobId) throws IOException {
        String boxedSerialNumber = JobHistoryUtils.serialNumberDirectoryComponent((JobId)jobId, (String)this.serialNumberFormat);
        Set dateStringSet = this.serialNumberIndex.get(boxedSerialNumber);
        if (dateStringSet == null) {
            return null;
        }
        for (String timestampPart : dateStringSet) {
            Path logDir = this.canonicalHistoryLogPath(jobId, timestampPart);
            List fileStatusList = HistoryFileManager.scanDirectoryForHistoryFiles((Path)logDir, (FileContext)this.doneDirFc);
            HistoryFileInfo fileInfo = this.getJobFileInfo(fileStatusList, jobId);
            if (fileInfo == null) continue;
            return fileInfo;
        }
        return null;
    }

    public Collection<HistoryFileInfo> getAllFileInfo() throws IOException {
        this.scanIntermediateDirectory();
        return this.jobListCache.values();
    }

    public HistoryFileInfo getFileInfo(JobId jobId) throws IOException {
        HistoryFileInfo fileInfo = this.jobListCache.get(jobId);
        if (fileInfo != null) {
            return fileInfo;
        }
        this.scanIntermediateDirectory();
        fileInfo = this.jobListCache.get(jobId);
        if (fileInfo != null) {
            return fileInfo;
        }
        fileInfo = this.scanOldDirsForJob(jobId);
        if (fileInfo != null) {
            return fileInfo;
        }
        return null;
    }

    private void moveToDoneNow(Path src, Path target) throws IOException {
        LOG.info((Object)("Moving " + src.toString() + " to " + target.toString()));
        this.intermediateDoneDirFc.rename(src, target, new Options.Rename[]{Options.Rename.NONE});
    }

    private String getJobSummary(FileContext fc, Path path) throws IOException {
        Path qPath = fc.makeQualified(path);
        FSDataInputStream in = fc.open(qPath);
        String jobSummaryString = in.readUTF();
        in.close();
        return jobSummaryString;
    }

    private void makeDoneSubdir(Path path) throws IOException {
        try {
            this.doneDirFc.getFileStatus(path);
            this.existingDoneSubdirs.add(path);
        }
        catch (FileNotFoundException fnfE) {
            try {
                FsPermission fsp = new FsPermission(JobHistoryUtils.HISTORY_DONE_DIR_PERMISSION);
                this.doneDirFc.mkdir(path, fsp, true);
                FileStatus fsStatus = this.doneDirFc.getFileStatus(path);
                LOG.info((Object)("Perms after creating " + fsStatus.getPermission().toShort() + ", Expected: " + fsp.toShort()));
                if (fsStatus.getPermission().toShort() != fsp.toShort()) {
                    LOG.info((Object)("Explicitly setting permissions to : " + fsp.toShort() + ", " + fsp));
                    this.doneDirFc.setPermission(path, fsp);
                }
                this.existingDoneSubdirs.add(path);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    private Path canonicalHistoryLogPath(JobId id, String timestampComponent) {
        return new Path(this.doneDirPrefixPath, JobHistoryUtils.historyLogSubdirectory((JobId)id, (String)timestampComponent, (String)this.serialNumberFormat));
    }

    private Path canonicalHistoryLogPath(JobId id, long millisecondTime) {
        String timestampComponent = JobHistoryUtils.timestampDirectoryComponent((long)millisecondTime);
        return new Path(this.doneDirPrefixPath, JobHistoryUtils.historyLogSubdirectory((JobId)id, (String)timestampComponent, (String)this.serialNumberFormat));
    }

    private long getEffectiveTimestamp(long finishTime, FileStatus fileStatus) {
        if (finishTime == 0L) {
            return fileStatus.getModificationTime();
        }
        return finishTime;
    }

    private void deleteJobFromDone(HistoryFileInfo fileInfo) throws IOException {
        this.jobListCache.delete(fileInfo);
        HistoryFileInfo.access$200((HistoryFileInfo)fileInfo);
    }

    void clean() throws IOException {
        long cutoff = System.currentTimeMillis() - this.maxHistoryAge;
        boolean halted = false;
        List serialDirList = this.findTimestampedDirectories();
        Collections.sort(serialDirList);
        for (FileStatus serialDir : serialDirList) {
            List historyFileList = HistoryFileManager.scanDirectoryForHistoryFiles((Path)serialDir.getPath(), (FileContext)this.doneDirFc);
            for (FileStatus historyFile : historyFileList) {
                JobIndexInfo jobIndexInfo = FileNameIndexUtils.getIndexInfo((String)historyFile.getPath().getName());
                long effectiveTimestamp = this.getEffectiveTimestamp(jobIndexInfo.getFinishTime(), historyFile);
                if (effectiveTimestamp <= cutoff) {
                    HistoryFileInfo fileInfo = this.jobListCache.get(jobIndexInfo.getJobId());
                    if (fileInfo == null) {
                        String confFileName = JobHistoryUtils.getIntermediateConfFileName((JobId)jobIndexInfo.getJobId());
                        fileInfo = new HistoryFileInfo(this, historyFile.getPath(), new Path(historyFile.getPath().getParent(), confFileName), null, jobIndexInfo, true, null);
                    }
                    this.deleteJobFromDone(fileInfo);
                    continue;
                }
                halted = true;
                break;
            }
            if (halted) break;
            this.doneDirFc.delete(this.doneDirFc.makeQualified(serialDir.getPath()), true);
            this.removeDirectoryFromSerialNumberIndex(serialDir.getPath());
            this.existingDoneSubdirs.remove(serialDir.getPath());
        }
    }

    @VisibleForTesting
    protected void setMaxHistoryAge(long newValue) {
        this.maxHistoryAge = newValue;
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ void access$300(HistoryFileManager x0, Path x1) throws IOException {
        x0.scanIntermediateDirectory(x1);
    }

    static /* synthetic */ FileContext access$400(HistoryFileManager x0) {
        return x0.intermediateDoneDirFc;
    }

    static /* synthetic */ String access$500(HistoryFileManager x0, FileContext x1, Path x2) throws IOException {
        return x0.getJobSummary(x1, x2);
    }

    static /* synthetic */ Log access$600() {
        return SUMMARY_LOG;
    }

    static /* synthetic */ Path access$700(HistoryFileManager x0, JobId x1, long x2) {
        return x0.canonicalHistoryLogPath(x1, x2);
    }

    static /* synthetic */ void access$800(HistoryFileManager x0, Path x1) {
        x0.addDirectoryToSerialNumberIndex(x1);
    }

    static /* synthetic */ void access$900(HistoryFileManager x0, Path x1) throws IOException {
        x0.makeDoneSubdir(x1);
    }

    static /* synthetic */ FileContext access$1000(HistoryFileManager x0) {
        return x0.doneDirFc;
    }

    static /* synthetic */ void access$1100(HistoryFileManager x0, Path x1, Path x2) throws IOException {
        x0.moveToDoneNow(x1, x2);
    }

    static /* synthetic */ Configuration access$1200(HistoryFileManager x0) {
        return x0.conf;
    }

    static /* synthetic */ JobACLsManager access$1300(HistoryFileManager x0) {
        return x0.aclsMgr;
    }
}

