/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class HsJobsBlock
extends HtmlBlock {
    final AppContext appContext;
    static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");

    @Inject
    HsJobsBlock(AppContext appCtx) {
        this.appContext = appCtx;
    }

    protected void render(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.h2("Retired Jobs").table("#jobs").thead().tr().th("Start Time").th("Finish Time").th(".id", "Job ID").th(".name", "Name").th("User").th("Queue").th(".state", "State").th("Maps Total").th("Maps Completed").th("Reduces Total").th("Reduces Completed")._())._()).tbody();
        LOG.info("Getting list of all Jobs.");
        for (Job j : this.appContext.getAllJobs().values()) {
            JobInfo job = new JobInfo(j);
            ((Hamlet.TR)tbody.tr().td(dateFormat.format(new Date(job.getStartTime()))).td(dateFormat.format(new Date(job.getFinishTime()))).td().a(this.url(new String[]{"job", job.getId()}), job.getId())._()).td(job.getName()).td(job.getUserName()).td(job.getQueueName()).td(job.getState()).td(String.valueOf(job.getMapsTotal())).td(String.valueOf(job.getMapsCompleted())).td(String.valueOf(job.getReducesTotal())).td(String.valueOf(job.getReducesCompleted()))._();
        }
        ((Hamlet.TABLE)((Hamlet.TFOOT)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TABLE)tbody._()).tfoot().tr().th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Start Time")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("finish_time").$value("Finish Time")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Job ID")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Name")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("User")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Queue")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("State")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Maps Total")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Maps Completed")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Reduces Total")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Reduces Completed")._())._())._())._())._();
    }
}

