/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.mapreduce.v2.hs.webapp.MapReduceTrackingUriPlugin;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestMapReduceTrackingUriPlugin {
    @Test
    public void testProducesHistoryServerUriForAppId() throws URISyntaxException {
        String historyAddress = "example.net:424242";
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("mapreduce.jobhistory.http.policy", HttpConfig.Policy.HTTP_ONLY.name());
        conf.set("mapreduce.jobhistory.webapp.address", "example.net:424242");
        MapReduceTrackingUriPlugin plugin = new MapReduceTrackingUriPlugin();
        plugin.setConf((Configuration)conf);
        ApplicationId id = ApplicationId.newInstance((long)6384623L, (int)5);
        String jobSuffix = id.toString().replaceFirst("^application_", "job_");
        URI expected = new URI("http://example.net:424242/jobhistory/job/" + jobSuffix);
        URI actual = plugin.getTrackingUri(id);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testProducesHistoryServerUriWithHTTPS() throws URISyntaxException {
        String historyAddress = "example.net:404040";
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("mapreduce.jobhistory.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("mapreduce.jobhistory.webapp.https.address", "example.net:404040");
        MapReduceTrackingUriPlugin plugin = new MapReduceTrackingUriPlugin();
        plugin.setConf((Configuration)conf);
        ApplicationId id = ApplicationId.newInstance((long)6384623L, (int)5);
        String jobSuffix = id.toString().replaceFirst("^application_", "job_");
        URI expected = new URI("https://example.net:404040/jobhistory/job/" + jobSuffix);
        URI actual = plugin.getTrackingUri(id);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

