/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.hs.webapp.MapReduceTrackingUriPlugin;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMapReduceTrackingUriPlugin {
    @Test
    public void testProducesHistoryServerUriForAppId() throws URISyntaxException {
        String historyAddress = "example.net:424242";
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("mapreduce.jobhistory.webapp.address", "example.net:424242");
        MapReduceTrackingUriPlugin plugin = new MapReduceTrackingUriPlugin();
        plugin.setConf((Configuration)conf);
        ApplicationId id = BuilderUtils.newApplicationId((long)6384623L, (int)5);
        String jobSuffix = id.toString().replaceFirst("^application_", "job_");
        URI expected = new URI("http://example.net:424242/jobhistory/job/" + jobSuffix);
        URI actual = plugin.getTrackingUri(id);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

