/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskStatus;

class MapTaskStatus
extends TaskStatus {
    private long mapFinishTime;
    private long sortFinishTime;

    public MapTaskStatus() {
    }

    public MapTaskStatus(TaskAttemptID taskid, float progress, int numSlots, TaskStatus.State runState, String diagnosticInfo, String stateString, String taskTracker, TaskStatus.Phase phase, Counters counters) {
        super(taskid, progress, numSlots, runState, diagnosticInfo, stateString, taskTracker, phase, counters);
    }

    @Override
    public boolean getIsMap() {
        return true;
    }

    @Override
    void setFinishTime(long finishTime) {
        super.setFinishTime(finishTime);
        if (this.mapFinishTime == 0L) {
            this.mapFinishTime = finishTime;
        }
        this.setSortFinishTime(finishTime);
    }

    @Override
    public long getShuffleFinishTime() {
        throw new UnsupportedOperationException("getShuffleFinishTime() not supported for MapTask");
    }

    @Override
    void setShuffleFinishTime(long shuffleFinishTime) {
        throw new UnsupportedOperationException("setShuffleFinishTime() not supported for MapTask");
    }

    @Override
    public long getMapFinishTime() {
        return this.mapFinishTime;
    }

    @Override
    void setMapFinishTime(long mapFinishTime) {
        this.mapFinishTime = mapFinishTime;
    }

    @Override
    public long getSortFinishTime() {
        return this.sortFinishTime;
    }

    @Override
    void setSortFinishTime(long sortFinishTime) {
        this.sortFinishTime = sortFinishTime;
    }

    @Override
    synchronized void statusUpdate(TaskStatus status) {
        super.statusUpdate(status);
        if (status.getMapFinishTime() != 0L) {
            this.mapFinishTime = status.getMapFinishTime();
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.mapFinishTime = in.readLong();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.mapFinishTime);
    }

    @Override
    public void addFetchFailedMap(TaskAttemptID mapTaskId) {
        throw new UnsupportedOperationException("addFetchFailedMap() not supported for MapTask");
    }
}

