/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.speculate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.speculate.StartEndTimesBase;

public class LegacyTaskRuntimeEstimator
extends StartEndTimesBase {
    private final Map<TaskAttempt, AtomicLong> attemptRuntimeEstimates = new ConcurrentHashMap();
    private final ConcurrentHashMap<TaskAttempt, AtomicLong> attemptRuntimeEstimateVariances = new ConcurrentHashMap();

    public void updateAttempt(TaskAttemptStatusUpdateEvent.TaskAttemptStatus status, long timestamp) {
        long start;
        super.updateAttempt(status, timestamp);
        TaskAttemptId attemptID = status.id;
        TaskId taskID = attemptID.getTaskId();
        JobId jobID = taskID.getJobId();
        Job job = this.context.getJob(jobID);
        if (job == null) {
            return;
        }
        Task task = job.getTask(taskID);
        if (task == null) {
            return;
        }
        TaskAttempt taskAttempt = task.getAttempt(attemptID);
        if (taskAttempt == null) {
            return;
        }
        Long boxedStart = (Long)this.startTimes.get(attemptID);
        long l = start = boxedStart == null ? Long.MIN_VALUE : boxedStart;
        if (taskAttempt.getState() == TaskAttemptState.RUNNING) {
            AtomicLong estimateContainer = (AtomicLong)this.attemptRuntimeEstimates.get(taskAttempt);
            AtomicLong estimateVarianceContainer = (AtomicLong)this.attemptRuntimeEstimateVariances.get(taskAttempt);
            if (estimateContainer == null && this.attemptRuntimeEstimates.get(taskAttempt) == null) {
                this.attemptRuntimeEstimates.put(taskAttempt, new AtomicLong());
                estimateContainer = (AtomicLong)this.attemptRuntimeEstimates.get(taskAttempt);
            }
            if (estimateVarianceContainer == null) {
                this.attemptRuntimeEstimateVariances.putIfAbsent(taskAttempt, new AtomicLong());
                estimateVarianceContainer = (AtomicLong)this.attemptRuntimeEstimateVariances.get(taskAttempt);
            }
            long estimate = -1L;
            long varianceEstimate = -1L;
            if (start > 0L && timestamp > start) {
                estimate = (long)((double)(timestamp - start) / Math.max(1.0E-4, (double)status.progress));
                varianceEstimate = (long)((float)estimate * status.progress / 10.0f);
            }
            if (estimateContainer != null) {
                estimateContainer.set(estimate);
            }
            if (estimateVarianceContainer != null) {
                estimateVarianceContainer.set(varianceEstimate);
            }
        }
    }

    private long storedPerAttemptValue(Map<TaskAttempt, AtomicLong> data, TaskAttemptId attemptID) {
        TaskId taskID = attemptID.getTaskId();
        JobId jobID = taskID.getJobId();
        Job job = this.context.getJob(jobID);
        Task task = job.getTask(taskID);
        if (task == null) {
            return -1L;
        }
        TaskAttempt taskAttempt = task.getAttempt(attemptID);
        if (taskAttempt == null) {
            return -1L;
        }
        AtomicLong estimate = data.get(taskAttempt);
        return estimate == null ? -1L : estimate.get();
    }

    public long estimatedRuntime(TaskAttemptId attemptID) {
        return this.storedPerAttemptValue(this.attemptRuntimeEstimates, attemptID);
    }

    public long runtimeEstimateVariance(TaskAttemptId attemptID) {
        return this.storedPerAttemptValue((Map)this.attemptRuntimeEstimateVariances, attemptID);
    }
}

