/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.client;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.security.authorize.MRAMPolicyProvider;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebApp;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class MRClientService
extends AbstractService
implements ClientService {
    static final Log LOG = LogFactory.getLog(MRClientService.class);
    private MRClientProtocol protocolHandler;
    private Server server;
    private WebApp webApp;
    private InetSocketAddress bindAddress;
    private AppContext appContext;

    public MRClientService(AppContext appContext) {
        super(MRClientService.class.getName());
        this.appContext = appContext;
        this.protocolHandler = new MRClientProtocolHandler(this);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress address = new InetSocketAddress(0);
        this.server = rpc.getServer(MRClientProtocol.class, (Object)this.protocolHandler, address, conf, (SecretManager)this.appContext.getClientToAMTokenSecretManager(), conf.getInt("yarn.app.mapreduce.am.job.client.thread-count", 1), "yarn.app.mapreduce.am.job.client.port-range");
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, (PolicyProvider)new MRAMPolicyProvider());
        }
        this.server.start();
        this.bindAddress = NetUtils.getConnectAddress((Server)this.server);
        LOG.info((Object)("Instantiated MRClientService at " + this.bindAddress));
        try {
            this.webApp = WebApps.$for((String)"mapreduce", AppContext.class, (Object)this.appContext, (String)"ws").with(conf).start((WebApp)new AMWebApp());
        }
        catch (Exception e) {
            LOG.error((Object)"Webapps failed to start. Ignoring for now:", (Throwable)e);
        }
        super.serviceStart();
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.webApp != null) {
            this.webApp.stop();
        }
        super.serviceStop();
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public int getHttpPort() {
        return this.webApp.port();
    }

    static /* synthetic */ AppContext access$000(MRClientService x0) {
        return x0.appContext;
    }
}

