/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.TestFail;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.yarn.event.Event;
import org.junit.Test;

public class TestFail {
    @Test
    public void testFailTask() throws Exception {
        MockFirstFailingAttemptMRApp app = new MockFirstFailingAttemptMRApp(1, 0);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (int)1, (int)tasks.size());
        Task task = (Task)tasks.values().iterator().next();
        Assert.assertEquals((String)"Task state not correct", (Object)TaskState.SUCCEEDED, (Object)task.getReport().getTaskState());
        Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
        Assert.assertEquals((String)"Num attempts is not correct", (int)2, (int)attempts.size());
        Iterator it = attempts.values().iterator();
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.FAILED, (Object)((TaskAttempt)it.next()).getReport().getTaskAttemptState());
        Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.SUCCEEDED, (Object)((TaskAttempt)it.next()).getReport().getTaskAttemptState());
    }

    @Test
    public void testMapFailureMaxPercent() throws Exception {
        MockFirstFailingTaskMRApp app = new MockFirstFailingTaskMRApp(4, 0);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.map.maxattempts", 2);
        conf.setInt("mapreduce.reduce.maxattempts", 1);
        conf.setInt("mapreduce.map.failures.maxpercent", 20);
        conf.setInt("mapreduce.map.maxattempts", 1);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.FAILED);
        app = new MockFirstFailingTaskMRApp(4, 0);
        conf = new Configuration();
        conf.setInt("mapreduce.map.maxattempts", 2);
        conf.setInt("mapreduce.reduce.maxattempts", 1);
        conf.setInt("mapreduce.map.failures.maxpercent", 25);
        conf.setInt("mapreduce.map.maxattempts", 1);
        job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
    }

    @Test
    public void testReduceFailureMaxPercent() throws Exception {
        MockFirstFailingTaskMRApp app = new MockFirstFailingTaskMRApp(2, 4);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.map.maxattempts", 1);
        conf.setInt("mapreduce.reduce.maxattempts", 2);
        conf.setInt("mapreduce.map.failures.maxpercent", 50);
        conf.setInt("mapreduce.map.maxattempts", 1);
        conf.setInt("mapreduce.reduce.failures.maxpercent", 20);
        conf.setInt("mapreduce.reduce.maxattempts", 1);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.FAILED);
        app = new MockFirstFailingTaskMRApp(2, 4);
        conf = new Configuration();
        conf.setInt("mapreduce.map.maxattempts", 1);
        conf.setInt("mapreduce.reduce.maxattempts", 2);
        conf.setInt("mapreduce.map.failures.maxpercent", 50);
        conf.setInt("mapreduce.map.maxattempts", 1);
        conf.setInt("mapreduce.reduce.failures.maxpercent", 25);
        conf.setInt("mapreduce.reduce.maxattempts", 1);
        job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
    }

    @Test
    public void testTimedOutTask() throws Exception {
        TimeOutTaskMRApp app = new TimeOutTaskMRApp(1, 0);
        Configuration conf = new Configuration();
        int maxAttempts = 2;
        conf.setInt("mapreduce.map.maxattempts", maxAttempts);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.FAILED);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (int)1, (int)tasks.size());
        Task task = (Task)tasks.values().iterator().next();
        Assert.assertEquals((String)"Task state not correct", (Object)TaskState.FAILED, (Object)task.getReport().getTaskState());
        Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
        Assert.assertEquals((String)"Num attempts is not correct", (int)maxAttempts, (int)attempts.size());
        for (TaskAttempt attempt : attempts.values()) {
            Assert.assertEquals((String)"Attempt state not correct", (Object)TaskAttemptState.FAILED, (Object)attempt.getReport().getTaskAttemptState());
        }
    }

    @Test
    public void testTaskFailWithUnusedContainer() throws Exception {
        MRAppWithFailingTaskAndUnusedContainer app = new MRAppWithFailingTaskAndUnusedContainer();
        Configuration conf = new Configuration();
        int maxAttempts = 1;
        conf.setInt("mapreduce.map.maxattempts", maxAttempts);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (int)1, (int)tasks.size());
        Task task = (Task)tasks.values().iterator().next();
        app.waitForState(task, TaskState.SCHEDULED);
        Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
        Assert.assertEquals((String)"Num attempts is not correct", (int)maxAttempts, (int)attempts.size());
        TaskAttempt attempt = (TaskAttempt)attempts.values().iterator().next();
        app.waitForInternalState((TaskAttemptImpl)attempt, TaskAttemptStateInternal.ASSIGNED);
        app.getDispatcher().getEventHandler().handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_CONTAINER_COMPLETED));
        app.waitForState(job, JobState.FAILED);
    }

    public static void main(String[] args) throws Exception {
        TestFail t = new TestFail();
        t.testFailTask();
        t.testTimedOutTask();
        t.testMapFailureMaxPercent();
        t.testReduceFailureMaxPercent();
        t.testTaskFailWithUnusedContainer();
    }
}

