/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.MockJobs;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.Records;

/*
 * Exception performing whole class analysis ignored.
 */
public class MockJobs
extends MockApps {
    static final Iterator<JobState> JOB_STATES = Iterators.cycle((Object[])JobState.values());
    static final Iterator<TaskState> TASK_STATES = Iterators.cycle((Object[])TaskState.values());
    static final Iterator<TaskAttemptState> TASK_ATTEMPT_STATES = Iterators.cycle((Object[])TaskAttemptState.values());
    static final Iterator<TaskType> TASK_TYPES = Iterators.cycle((Object[])TaskType.values());
    static final Iterator<JobCounter> JOB_COUNTERS = Iterators.cycle((Object[])JobCounter.values());
    static final Iterator<FileSystemCounter> FS_COUNTERS = Iterators.cycle((Object[])FileSystemCounter.values());
    static final Iterator<TaskCounter> TASK_COUNTERS = Iterators.cycle((Object[])TaskCounter.values());
    static final Iterator<String> FS_SCHEMES = Iterators.cycle((Object[])new String[]{"FILE", "HDFS", "LAFS", "CEPH"});
    static final Iterator<String> USER_COUNTER_GROUPS = Iterators.cycle((Object[])new String[]{"com.company.project.subproject.component.subcomponent.UserDefinedSpecificSpecialTask$Counters", "PigCounters"});
    static final Iterator<String> USER_COUNTERS = Iterators.cycle((Object[])new String[]{"counter1", "counter2", "counter3"});
    static final Iterator<Phase> PHASES = Iterators.cycle((Object[])Phase.values());
    static final Iterator<String> DIAGS = Iterators.cycle((Object[])new String[]{"Error: java.lang.OutOfMemoryError: Java heap space", "Lost task tracker: tasktracker.domain/127.0.0.1:40879"});
    public static final String NM_HOST = "localhost";
    public static final int NM_PORT = 1234;
    public static final int NM_HTTP_PORT = 8042;
    static final int DT = 1000000;

    public static String newJobName() {
        return MockJobs.newAppName();
    }

    public static Map<JobId, Job> newJobs(int numJobs, int numTasksPerJob, int numAttemptsPerTask) {
        HashMap map = Maps.newHashMap();
        for (int j = 0; j < numJobs; ++j) {
            ApplicationId appID = MockJobs.newAppID((int)j);
            Job job = MockJobs.newJob((ApplicationId)appID, (int)j, (int)numTasksPerJob, (int)numAttemptsPerTask);
            map.put(job.getID(), job);
        }
        return map;
    }

    public static Map<JobId, Job> newJobs(ApplicationId appID, int numJobsPerApp, int numTasksPerJob, int numAttemptsPerTask) {
        HashMap map = Maps.newHashMap();
        for (int j = 0; j < numJobsPerApp; ++j) {
            Job job = MockJobs.newJob((ApplicationId)appID, (int)j, (int)numTasksPerJob, (int)numAttemptsPerTask);
            map.put(job.getID(), job);
        }
        return map;
    }

    public static Map<JobId, Job> newJobs(ApplicationId appID, int numJobsPerApp, int numTasksPerJob, int numAttemptsPerTask, boolean hasFailedTasks) {
        HashMap map = Maps.newHashMap();
        for (int j = 0; j < numJobsPerApp; ++j) {
            Job job = MockJobs.newJob((ApplicationId)appID, (int)j, (int)numTasksPerJob, (int)numAttemptsPerTask, null, (boolean)hasFailedTasks);
            map.put(job.getID(), job);
        }
        return map;
    }

    public static JobId newJobID(ApplicationId appID, int i) {
        JobId id = (JobId)Records.newRecord(JobId.class);
        id.setAppId(appID);
        id.setId(i);
        return id;
    }

    public static JobReport newJobReport(JobId id) {
        JobReport report = (JobReport)Records.newRecord(JobReport.class);
        report.setJobId(id);
        report.setSubmitTime(System.currentTimeMillis() - 1000000L);
        report.setStartTime(System.currentTimeMillis() - (long)((int)(Math.random() * 1000000.0)));
        report.setFinishTime(System.currentTimeMillis() + (long)((int)(Math.random() * 1000000.0)) + 1L);
        report.setMapProgress((float)Math.random());
        report.setReduceProgress((float)Math.random());
        report.setJobState((JobState)JOB_STATES.next());
        return report;
    }

    public static TaskReport newTaskReport(TaskId id) {
        TaskReport report = (TaskReport)Records.newRecord(TaskReport.class);
        report.setTaskId(id);
        report.setStartTime(System.currentTimeMillis() - (long)((int)(Math.random() * 1000000.0)));
        report.setFinishTime(System.currentTimeMillis() + (long)((int)(Math.random() * 1000000.0)) + 1L);
        report.setProgress((float)Math.random());
        report.setStatus("Moving average: " + Math.random());
        report.setCounters(TypeConverter.toYarn((Counters)MockJobs.newCounters()));
        report.setTaskState((TaskState)TASK_STATES.next());
        return report;
    }

    public static TaskAttemptReport newTaskAttemptReport(TaskAttemptId id) {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)id.getTaskId().getJobId().getAppId(), (int)0);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)0);
        TaskAttemptReport report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        report.setTaskAttemptId(id);
        report.setStartTime(System.currentTimeMillis() - (long)((int)(Math.random() * 1000000.0)));
        report.setFinishTime(System.currentTimeMillis() + (long)((int)(Math.random() * 1000000.0)) + 1L);
        if (id.getTaskId().getTaskType() == TaskType.REDUCE) {
            report.setShuffleFinishTime((report.getFinishTime() + report.getStartTime()) / 2L);
            report.setSortFinishTime((report.getFinishTime() + report.getShuffleFinishTime()) / 2L);
        }
        report.setPhase((Phase)PHASES.next());
        report.setTaskAttemptState((TaskAttemptState)TASK_ATTEMPT_STATES.next());
        report.setProgress((float)Math.random());
        report.setCounters(TypeConverter.toYarn((Counters)MockJobs.newCounters()));
        report.setContainerId(containerId);
        report.setDiagnosticInfo((String)DIAGS.next());
        report.setStateString("Moving average " + Math.random());
        return report;
    }

    public static Counters newCounters() {
        int i;
        Counters hc = new Counters();
        for (JobCounter jobCounter : JobCounter.values()) {
            hc.findCounter((Enum)jobCounter).setValue((long)(Math.random() * 1000.0));
        }
        for (JobCounter jobCounter : TaskCounter.values()) {
            hc.findCounter((Enum)jobCounter).setValue((long)(Math.random() * 1000.0));
        }
        int nc = FileSystemCounter.values().length * 4;
        for (i = 0; i < nc; ++i) {
            for (FileSystemCounter c : FileSystemCounter.values()) {
                hc.findCounter((String)FS_SCHEMES.next(), c).setValue((long)(Math.random() * 1000000.0));
            }
        }
        for (i = 0; i < 6; ++i) {
            hc.findCounter((String)USER_COUNTER_GROUPS.next(), (String)USER_COUNTERS.next()).setValue((long)(Math.random() * 100000.0));
        }
        return hc;
    }

    public static Map<TaskAttemptId, TaskAttempt> newTaskAttempts(TaskId tid, int m) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < m; ++i) {
            TaskAttempt ta = MockJobs.newTaskAttempt((TaskId)tid, (int)i);
            map.put(ta.getID(), ta);
        }
        return map;
    }

    public static TaskAttempt newTaskAttempt(TaskId tid, int i) {
        TaskAttemptId taid = (TaskAttemptId)Records.newRecord(TaskAttemptId.class);
        taid.setTaskId(tid);
        taid.setId(i);
        TaskAttemptReport report = MockJobs.newTaskAttemptReport((TaskAttemptId)taid);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Map<TaskId, Task> newTasks(JobId jid, int n, int m, boolean hasFailedTasks) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < n; ++i) {
            Task task = MockJobs.newTask((JobId)jid, (int)i, (int)m, (boolean)hasFailedTasks);
            map.put(task.getID(), task);
        }
        return map;
    }

    public static Task newTask(JobId jid, int i, int m, boolean hasFailedTasks) {
        TaskId tid = (TaskId)Records.newRecord(TaskId.class);
        tid.setJobId(jid);
        tid.setId(i);
        tid.setTaskType((TaskType)TASK_TYPES.next());
        TaskReport report = MockJobs.newTaskReport((TaskId)tid);
        Map attempts = MockJobs.newTaskAttempts((TaskId)tid, (int)m);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Counters getCounters(Collection<Task> tasks) {
        ArrayList<Task> completedTasks = new ArrayList<Task>();
        for (Task task : tasks) {
            if (task.getCounters() == null) continue;
            completedTasks.add(task);
        }
        Counters counters = new Counters();
        return JobImpl.incrTaskCounters((Counters)counters, completedTasks);
    }

    static TaskCount getTaskCount(Collection<Task> tasks) {
        TaskCount tc = new TaskCount();
        for (Task task : tasks) {
            tc.incr(task);
        }
        return tc;
    }

    public static Job newJob(ApplicationId appID, int i, int n, int m) {
        return MockJobs.newJob((ApplicationId)appID, (int)i, (int)n, (int)m, null);
    }

    public static Job newJob(ApplicationId appID, int i, int n, int m, Path confFile) {
        return MockJobs.newJob((ApplicationId)appID, (int)i, (int)n, (int)m, (Path)confFile, (boolean)false);
    }

    public static Job newJob(ApplicationId appID, int i, int n, int m, Path confFile, boolean hasFailedTasks) {
        JobId id = MockJobs.newJobID((ApplicationId)appID, (int)i);
        String name = MockJobs.newJobName();
        JobReport report = MockJobs.newJobReport((JobId)id);
        Map tasks = MockJobs.newTasks((JobId)id, (int)n, (int)m, (boolean)hasFailedTasks);
        TaskCount taskCount = MockJobs.getTaskCount(tasks.values());
        Counters counters = MockJobs.getCounters(tasks.values());
        Path configFile = confFile;
        Map tmpJobACLs = new HashMap();
        Configuration conf = new Configuration();
        conf.set(JobACL.VIEW_JOB.getAclName(), "testuser");
        conf.setBoolean("mapreduce.cluster.acls.enabled", true);
        JobACLsManager aclsManager = new JobACLsManager(conf);
        Map jobACLs = tmpJobACLs = aclsManager.constructJobACLs(conf);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static AMInfo createAMInfo(int attempt) {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)100L, (int)1), (int)attempt);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
        return MRBuilderUtils.newAMInfo((ApplicationAttemptId)appAttemptId, (long)System.currentTimeMillis(), (ContainerId)containerId, (String)"localhost", (int)1234, (int)8042);
    }

    static /* synthetic */ AMInfo access$000(int x0) {
        return MockJobs.createAMInfo((int)x0);
    }
}

