/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.mapred.LocalContainerLauncher;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class LocalContainerLauncher
extends AbstractService
implements ContainerLauncher {
    private static final File curDir = new File(".");
    private static final Log LOG = LogFactory.getLog(LocalContainerLauncher.class);
    private FileContext curFC = null;
    private final HashSet<File> localizedFiles;
    private final AppContext context;
    private final TaskUmbilicalProtocol umbilical;
    private Thread eventHandlingThread;
    private BlockingQueue<ContainerLauncherEvent> eventQueue = new LinkedBlockingQueue();

    public LocalContainerLauncher(AppContext context, TaskUmbilicalProtocol umbilical) {
        super(LocalContainerLauncher.class.getName());
        this.context = context;
        this.umbilical = umbilical;
        try {
            this.curFC = FileContext.getFileContext((URI)curDir.toURI());
        }
        catch (UnsupportedFileSystemException ufse) {
            LOG.error((Object)("Local filesystem " + curDir.toURI().toString() + " is unsupported?? (should never happen)"));
        }
        File[] curLocalFiles = curDir.listFiles();
        this.localizedFiles = new HashSet(curLocalFiles.length);
        for (int j = 0; j < curLocalFiles.length; ++j) {
            this.localizedFiles.add(curLocalFiles[j]);
        }
    }

    public void serviceStart() throws Exception {
        this.eventHandlingThread = new Thread((Runnable)new SubtaskRunner(this), "uber-SubtaskRunner");
        this.eventHandlingThread.start();
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
        super.serviceStop();
    }

    public void handle(ContainerLauncherEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    static /* synthetic */ BlockingQueue access$000(LocalContainerLauncher x0) {
        return x0.eventQueue;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ AppContext access$200(LocalContainerLauncher x0) {
        return x0.context;
    }

    static /* synthetic */ TaskUmbilicalProtocol access$300(LocalContainerLauncher x0) {
        return x0.umbilical;
    }

    static /* synthetic */ File access$400() {
        return curDir;
    }

    static /* synthetic */ HashSet access$500(LocalContainerLauncher x0) {
        return x0.localizedFiles;
    }

    static /* synthetic */ FileContext access$600(LocalContainerLauncher x0) {
        return x0.curFC;
    }
}

