/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import com.google.common.base.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTaskHeartbeatHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeout() throws InterruptedException {
        EventHandler mockHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        TaskHeartbeatHandler hb = new TaskHeartbeatHandler(mockHandler, (Clock)clock, 1);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.task.timeout", 10);
        conf.setLong("mapreduce.task.progress-report.interval", 5L);
        conf.setInt("mapreduce.task.timeout.check-interval-ms", 10);
        hb.init(conf);
        hb.start();
        try {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)5);
            JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)4);
            TaskId tid = MRBuilderUtils.newTaskId((JobId)jobId, (int)3, (TaskType)TaskType.MAP);
            TaskAttemptId taid = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)2);
            hb.register(taid);
            Thread.sleep(100L);
            ((EventHandler)Mockito.verify((Object)mockHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.any(Event.class));
        }
        finally {
            hb.stop();
        }
    }

    @Test
    public void testTaskTimeoutConfigSmallerThanTaskProgressReportInterval() {
        TestTaskHeartbeatHandler.testTaskTimeoutWrtProgressReportInterval((long)1000L, (long)5000L);
    }

    @Test
    public void testTaskTimeoutConfigBiggerThanTaskProgressReportInterval() {
        TestTaskHeartbeatHandler.testTaskTimeoutWrtProgressReportInterval((long)5000L, (long)1000L);
    }

    @Test
    public void testTaskTimeoutConfigWithoutTaskProgressReportInterval() {
        long taskTimeoutConfiged = 2000L;
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.task.timeout", 2000L);
        long expectedTimeout = 2000L;
        TestTaskHeartbeatHandler.verifyTaskTimeoutConfig((Configuration)conf, (long)2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskUnregistered() throws Exception {
        EventHandler mockHandler = (EventHandler)Mockito.mock(EventHandler.class);
        ControlledClock clock = new ControlledClock();
        clock.setTime(0L);
        TaskHeartbeatHandler hb = new TaskHeartbeatHandler(mockHandler, (Clock)clock, 1);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.task.timeout.check-interval-ms", 1);
        hb.init(conf);
        hb.start();
        try {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)5);
            JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)4);
            TaskId tid = MRBuilderUtils.newTaskId((JobId)jobId, (int)3, (TaskType)TaskType.MAP);
            TaskAttemptId taid = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)2);
            Assert.assertFalse((boolean)hb.hasRecentlyUnregistered(taid));
            hb.register(taid);
            Assert.assertFalse((boolean)hb.hasRecentlyUnregistered(taid));
            hb.unregister(taid);
            Assert.assertTrue((boolean)hb.hasRecentlyUnregistered(taid));
            long unregisterTimeout = conf.getLong("mapreduce.task.exit.timeout", 60000L);
            clock.setTime(unregisterTimeout + 1L);
            GenericTestUtils.waitFor((Supplier)new /* Unavailable Anonymous Inner Class!! */, (int)10, (int)10000);
        }
        finally {
            hb.stop();
        }
    }

    private static void testTaskTimeoutWrtProgressReportInterval(long timeoutConfig, long taskreportInterval) {
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.task.timeout", timeoutConfig);
        conf.setLong("mapreduce.task.progress-report.interval", taskreportInterval);
        long expectedTimeout = Math.max(timeoutConfig, taskreportInterval * 2L);
        TestTaskHeartbeatHandler.verifyTaskTimeoutConfig((Configuration)conf, (long)expectedTimeout);
    }

    private static void verifyTaskTimeoutConfig(Configuration conf, long expectedTimeout) {
        TaskHeartbeatHandler hb = new TaskHeartbeatHandler(null, (Clock)SystemClock.getInstance(), 1);
        hb.init(conf);
        Assert.assertTrue((String)"The value of the task timeout is incorrect.", (hb.getTaskTimeOut() == expectedTimeout ? 1 : 0) != 0);
    }
}

