/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.TestMRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobUpdatedNodesEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMRApp {
    private Container containerObtainedByContainerLauncher;

    @Test
    public void testMapReduce() throws Exception {
        MRApp app = new MRApp(2, 2, true, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)job.getUserName());
    }

    @Test
    public void testZeroMaps() throws Exception {
        MRApp app = new MRApp(0, 1, true, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
    }

    @Test
    public void testZeroMapReduces() throws Exception {
        MRApp app = new MRApp(0, 0, true, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.SUCCEEDED);
    }

    @Test
    public void testCommitPending() throws Exception {
        MRApp app = new MRApp(1, 0, false, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (long)1L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        app.waitForState(attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_COMMIT_PENDING));
        app.waitForState(attempt, TaskAttemptState.COMMIT_PENDING);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_COMMIT_PENDING));
        app.waitForState(attempt, TaskAttemptState.COMMIT_PENDING);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)task.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
    }

    public void testCompletedMapsForReduceSlowstart() throws Exception {
        MRApp app = new MRApp(2, 1, false, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.5f);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (long)3L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        TaskAttempt task1Attempt = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt, TaskAttemptState.RUNNING);
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((String)"Reduce Task state not correct", (Object)TaskState.NEW, (Object)reduceTask.getReport().getTaskState());
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)mapTask1.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(reduceTask, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)mapTask2.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)reduceTask.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
    }

    @Test
    public void testUpdatedNodes() throws Exception {
        int runCount = 0;
        Dispatcher disp = (Dispatcher)Mockito.spy((Object)new AsyncDispatcher());
        MRAppWithHistory app = new MRAppWithHistory(this, 2, 2, false, this.getClass().getName(), true, ++runCount, disp);
        Configuration conf = new Configuration();
        conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.5f);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        ContainerAllocEventHandler handler = new ContainerAllocEventHandler(this, null);
        disp.register(ContainerAllocator.EventType.class, (EventHandler)handler);
        Job job1 = app.submit(conf);
        app.waitForState(job1, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (long)4L, (long)job1.getTasks().size());
        Iterator it = job1.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        TaskAttempt task1Attempt = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        NodeId node1 = task1Attempt.getNodeId();
        NodeId node2 = task2Attempt.getNodeId();
        Assert.assertEquals((Object)node1, (Object)node2);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(task1Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(task2Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        int checkIntervalMillis = 100;
        int waitForMillis = 800;
        TestMRApp.waitFor((Supplier)new /* Unavailable Anonymous Inner Class!! */, (int)100, (int)800);
        TaskAttemptCompletionEvent[] events = job1.getTaskAttemptCompletionEvents(0, 100);
        Assert.assertEquals((String)"Expecting 2 completion events for success", (long)2L, (long)events.length);
        ArrayList<NodeReport> updatedNodes = new ArrayList<NodeReport>();
        NodeReport nr = (NodeReport)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(NodeReport.class);
        nr.setNodeId(node1);
        nr.setNodeState(NodeState.UNHEALTHY);
        updatedNodes.add(nr);
        app.getContext().getEventHandler().handle((Event)new JobUpdatedNodesEvent(job1.getID(), updatedNodes));
        app.waitForState(task1Attempt, TaskAttemptState.KILLED);
        app.waitForState(task2Attempt, TaskAttemptState.KILLED);
        TestMRApp.waitFor((Supplier)new /* Unavailable Anonymous Inner Class!! */, (int)100, (int)800);
        events = job1.getTaskAttemptCompletionEvents(0, 100);
        Assert.assertEquals((String)"Expecting 2 more completion events for killed", (long)4L, (long)events.length);
        handler.waitForFailedMapContainerReqEvents(2);
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        Iterator itr = mapTask1.getAttempts().values().iterator();
        itr.next();
        task1Attempt = (TaskAttempt)itr.next();
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(task1Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.RUNNING);
        TestMRApp.waitFor((Supplier)new /* Unavailable Anonymous Inner Class!! */, (int)100, (int)800);
        events = job1.getTaskAttemptCompletionEvents(0, 100);
        Assert.assertEquals((String)"Expecting 1 more completion events for success", (long)5L, (long)events.length);
        app.stop();
        app = new MRAppWithHistory(this, 2, 2, false, this.getClass().getName(), false, ++runCount, (Dispatcher)new AsyncDispatcher());
        conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job2 = app.submit(conf);
        app.waitForState(job2, JobState.RUNNING);
        Assert.assertEquals((String)"No of tasks not correct", (long)4L, (long)job2.getTasks().size());
        it = job2.getTasks().values().iterator();
        mapTask1 = (Task)it.next();
        mapTask2 = (Task)it.next();
        Task reduceTask1 = (Task)it.next();
        Task reduceTask2 = (Task)it.next();
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(mapTask2, TaskState.RUNNING);
        TestMRApp.waitFor((Supplier)new /* Unavailable Anonymous Inner Class!! */, (int)100, (int)800);
        events = job2.getTaskAttemptCompletionEvents(0, 100);
        Assert.assertEquals((String)"Expecting 2 completion events for killed & success of map1", (long)2L, (long)events.length);
        task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(task2Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask2, TaskState.SUCCEEDED);
        TestMRApp.waitFor((Supplier)new /* Unavailable Anonymous Inner Class!! */, (int)100, (int)800);
        events = job2.getTaskAttemptCompletionEvents(0, 100);
        Assert.assertEquals((String)"Expecting 1 more completion events for success", (long)3L, (long)events.length);
        app.waitForState(reduceTask1, TaskState.RUNNING);
        app.waitForState(reduceTask2, TaskState.RUNNING);
        TaskAttempt task3Attempt = (TaskAttempt)reduceTask1.getAttempts().values().iterator().next();
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(task3Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(reduceTask1, TaskState.SUCCEEDED);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(task3Attempt.getID(), TaskAttemptEventType.TA_KILL));
        app.waitForState(reduceTask1, TaskState.SUCCEEDED);
        TaskAttempt task4Attempt = (TaskAttempt)reduceTask2.getAttempts().values().iterator().next();
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(task4Attempt.getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(reduceTask2, TaskState.SUCCEEDED);
        TestMRApp.waitFor((Supplier)new /* Unavailable Anonymous Inner Class!! */, (int)100, (int)800);
        events = job2.getTaskAttemptCompletionEvents(0, 100);
        Assert.assertEquals((String)"Expecting 2 more completion events for reduce success", (long)5L, (long)events.length);
        app.waitForState(job2, JobState.SUCCEEDED);
    }

    private static void waitFor(Supplier<Boolean> predicate, int checkIntervalMillis, int checkTotalMillis) throws InterruptedException {
        try {
            GenericTestUtils.waitFor(predicate, (int)checkIntervalMillis, (int)checkTotalMillis);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void testJobError() throws Exception {
        MRApp app = new MRApp(1, 0, false, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (long)1L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new TaskEvent(task.getID(), TaskEventType.T_SCHEDULE));
        app.waitForState(job, JobState.ERROR);
    }

    @Test
    public void testJobSuccess() throws Exception {
        MRApp app = new MRApp(2, 2, true, this.getClass().getName(), true, false);
        JobImpl job = (JobImpl)app.submit(new Configuration());
        app.waitForInternalState(job, JobStateInternal.SUCCEEDED);
        Assert.assertEquals((Object)JobState.RUNNING, (Object)job.getState());
        app.successfullyUnregistered.set(true);
        app.waitForState((Job)job, JobState.SUCCEEDED);
    }

    @Test
    public void testJobRebootNotLastRetryOnUnregistrationFailure() throws Exception {
        MRApp app = new MRApp(1, 0, false, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (long)1L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new JobEvent(job.getID(), JobEventType.JOB_AM_REBOOT));
        app.waitForState(job, JobState.RUNNING);
    }

    @Test
    public void testJobRebootOnLastRetryOnUnregistrationFailure() throws Exception {
        MRApp app = new MRApp(1, 0, false, this.getClass().getName(), true, 2, false);
        Configuration conf = new Configuration();
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (long)1L, (long)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new JobEvent(job.getID(), JobEventType.JOB_AM_REBOOT));
        app.waitForInternalState((JobImpl)job, JobStateInternal.REBOOT);
        app.waitForState(job, JobState.RUNNING);
    }

    @Test
    public void testCountersOnJobFinish() throws Exception {
        MRAppWithSpiedJob app = new MRAppWithSpiedJob(this, 1, 1, true, this.getClass().getName(), true, null);
        JobImpl job = (JobImpl)app.submit(new Configuration());
        app.waitForState((Job)job, JobState.SUCCEEDED);
        app.verifyCompleted();
        System.out.println(job.getAllCounters());
        job.getAllCounters();
        job.getAllCounters();
        ((JobImpl)Mockito.verify((Object)job, (VerificationMode)Mockito.times((int)1))).constructFinalFullcounters();
    }

    @Test
    public void checkJobStateTypeConversion() {
        for (JobState state : JobState.values()) {
            TypeConverter.fromYarn((JobState)state);
        }
    }

    @Test
    public void checkTaskStateTypeConversion() {
        for (TaskState state : TaskState.values()) {
            TypeConverter.fromYarn((TaskState)state);
        }
    }

    @Test
    public void testContainerPassThrough() throws Exception {
        7 app = new /* Unavailable Anonymous Inner Class!! */;
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Collection tasks = job.getTasks().values();
        Collection taskAttempts = ((Task)tasks.iterator().next()).getAttempts().values();
        TaskAttemptImpl taskAttempt = (TaskAttemptImpl)taskAttempts.iterator().next();
        Assert.assertTrue((taskAttempt.container == this.containerObtainedByContainerLauncher ? 1 : 0) != 0);
    }

    public static void main(String[] args) throws Exception {
        TestMRApp t = new TestMRApp();
        t.testMapReduce();
        t.testZeroMapReduces();
        t.testCommitPending();
        t.testCompletedMapsForReduceSlowstart();
        t.testJobError();
        t.testCountersOnJobFinish();
    }

    static /* synthetic */ Container access$202(TestMRApp x0, Container x1) {
        x0.containerObtainedByContainerLauncher = x1;
        return x0.containerObtainedByContainerLauncher;
    }
}

