/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapTaskAttemptImpl;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.event.EventHandler;

public class MapTaskImpl
extends TaskImpl {
    private final JobSplit.TaskSplitMetaInfo taskSplitMetaInfo;

    public MapTaskImpl(JobId jobId, int partition, EventHandler eventHandler, Path remoteJobConfFile, JobConf conf, JobSplit.TaskSplitMetaInfo taskSplitMetaInfo, TaskAttemptListener taskAttemptListener, OutputCommitter committer, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun, int startCount, MRAppMetrics metrics, AppContext appContext) {
        super(jobId, TaskType.MAP, partition, eventHandler, remoteJobConfFile, conf, taskAttemptListener, committer, jobToken, credentials, clock, completedTasksFromPreviousRun, startCount, metrics, appContext);
        this.taskSplitMetaInfo = taskSplitMetaInfo;
    }

    @Override
    protected int getMaxAttempts() {
        return this.conf.getInt("mapreduce.map.maxattempts", 4);
    }

    @Override
    protected TaskAttemptImpl createAttempt() {
        return new MapTaskAttemptImpl(this.getID(), this.nextAttemptNumber, this.eventHandler, this.jobFile, this.partition, this.taskSplitMetaInfo, this.conf, this.taskAttemptListener, this.committer, (Token<JobTokenIdentifier>)this.jobToken, this.credentials, this.clock, this.appContext);
    }

    @Override
    public TaskType getType() {
        return TaskType.MAP;
    }

    protected JobSplit.TaskSplitMetaInfo getTaskSplitMetaInfo() {
        return this.taskSplitMetaInfo;
    }

    @Override
    protected String getSplitsAsString() {
        String[] splits = this.getTaskSplitMetaInfo().getLocations();
        if (splits == null || splits.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < splits.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(splits[i]);
        }
        return sb.toString();
    }
}

