/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocator;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.AMRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;

public abstract class RMCommunicator
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(RMContainerAllocator.class);
    private int rmPollInterval;
    protected ApplicationId applicationId;
    protected ApplicationAttemptId applicationAttemptId;
    private AtomicBoolean stopped;
    protected Thread allocatorThread;
    protected EventHandler eventHandler;
    protected AMRMProtocol scheduler;
    private final ClientService clientService;
    protected int lastResponseID;
    private Resource minContainerCapability;
    private Resource maxContainerCapability;
    protected Map<ApplicationAccessType, String> applicationACLs;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final AppContext context;
    private Job job;
    protected volatile boolean isSignalled = false;
    private volatile boolean shouldUnregister = true;

    public RMCommunicator(ClientService clientService, AppContext context) {
        super("RMCommunicator");
        this.clientService = clientService;
        this.context = context;
        this.eventHandler = context.getEventHandler();
        this.applicationId = context.getApplicationID();
        this.applicationAttemptId = context.getApplicationAttemptId();
        this.stopped = new AtomicBoolean(false);
    }

    public void init(Configuration conf) {
        super.init(conf);
        this.rmPollInterval = conf.getInt("yarn.app.mapreduce.am.scheduler.heartbeat.interval-ms", 1000);
    }

    public void start() {
        this.scheduler = this.createSchedulerProxy();
        this.register();
        this.startAllocatorThread();
        JobID id = TypeConverter.fromYarn((ApplicationId)this.applicationId);
        JobId jobId = TypeConverter.toYarn((JobID)id);
        this.job = this.context.getJob(jobId);
        super.start();
    }

    protected AppContext getContext() {
        return this.context;
    }

    protected Job getJob() {
        return this.job;
    }

    protected float getApplicationProgress() {
        return this.job.getProgress();
    }

    protected void register() {
        InetSocketAddress serviceAddr = this.clientService.getBindAddress();
        try {
            RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)this.recordFactory.newRecordInstance(RegisterApplicationMasterRequest.class);
            request.setApplicationAttemptId(this.applicationAttemptId);
            request.setHost(serviceAddr.getHostName());
            request.setRpcPort(serviceAddr.getPort());
            request.setTrackingUrl(serviceAddr.getHostName() + ":" + this.clientService.getHttpPort());
            RegisterApplicationMasterResponse response = this.scheduler.registerApplicationMaster(request);
            this.minContainerCapability = response.getMinimumResourceCapability();
            this.maxContainerCapability = response.getMaximumResourceCapability();
            this.context.getClusterInfo().setMinContainerCapability(this.minContainerCapability);
            this.context.getClusterInfo().setMaxContainerCapability(this.maxContainerCapability);
            this.applicationACLs = response.getApplicationACLs();
            LOG.info((Object)("minContainerCapability: " + this.minContainerCapability.getMemory()));
            LOG.info((Object)("maxContainerCapability: " + this.maxContainerCapability.getMemory()));
        }
        catch (Exception are) {
            LOG.error((Object)"Exception while registering", (Throwable)are);
            throw new YarnException((Throwable)are);
        }
    }

    protected void unregister() {
        try {
            FinalApplicationStatus finishState = FinalApplicationStatus.UNDEFINED;
            if (this.job.getState() == JobState.SUCCEEDED) {
                finishState = FinalApplicationStatus.SUCCEEDED;
            } else if (this.job.getState() == JobState.KILLED || this.job.getState() == JobState.RUNNING && this.isSignalled) {
                finishState = FinalApplicationStatus.KILLED;
            } else if (this.job.getState() == JobState.FAILED || this.job.getState() == JobState.ERROR) {
                finishState = FinalApplicationStatus.FAILED;
            }
            StringBuffer sb = new StringBuffer();
            for (String s : this.job.getDiagnostics()) {
                sb.append(s).append("\n");
            }
            LOG.info((Object)("Setting job diagnostics to " + sb.toString()));
            String historyUrl = JobHistoryUtils.getHistoryUrl((Configuration)this.getConfig(), (ApplicationId)this.context.getApplicationID());
            LOG.info((Object)("History url is " + historyUrl));
            FinishApplicationMasterRequest request = (FinishApplicationMasterRequest)this.recordFactory.newRecordInstance(FinishApplicationMasterRequest.class);
            request.setAppAttemptId(this.applicationAttemptId);
            request.setFinishApplicationStatus(finishState);
            request.setDiagnostics(sb.toString());
            request.setTrackingUrl(historyUrl);
            this.scheduler.finishApplicationMaster(request);
        }
        catch (Exception are) {
            LOG.error((Object)"Exception while unregistering ", (Throwable)are);
        }
    }

    protected Resource getMinContainerCapability() {
        return this.minContainerCapability;
    }

    protected Resource getMaxContainerCapability() {
        return this.maxContainerCapability;
    }

    public void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        this.allocatorThread.interrupt();
        try {
            this.allocatorThread.join();
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)"InterruptedException while stopping", (Throwable)ie);
        }
        if (this.shouldUnregister) {
            this.unregister();
        }
        super.stop();
    }

    protected void startAllocatorThread() {
        this.allocatorThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.allocatorThread.setName("RMCommunicator Allocator");
        this.allocatorThread.start();
    }

    protected AMRMProtocol createSchedulerProxy() {
        UserGroupInformation currentUser;
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress serviceAddr = conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            String tokenURLEncodedStr = System.getenv().get("AppMasterTokenEnv");
            Token token = new Token();
            try {
                token.decodeFromUrlString(tokenURLEncodedStr);
            }
            catch (IOException e) {
                throw new YarnException((Throwable)e);
            }
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)serviceAddr);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AppMasterToken is " + token));
            }
            currentUser.addToken(token);
        }
        return (AMRMProtocol)currentUser.doAs((PrivilegedAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract void heartbeat() throws Exception;

    public void setShouldUnregister(boolean shouldUnregister) {
        this.shouldUnregister = shouldUnregister;
        LOG.info((Object)("RMCommunicator notified that shouldUnregistered is: " + shouldUnregister));
    }

    public void setSignalled(boolean isSignalled) {
        this.isSignalled = isSignalled;
        LOG.info((Object)("RMCommunicator notified that iSignalled is: " + isSignalled));
    }

    static /* synthetic */ AtomicBoolean access$000(RMCommunicator x0) {
        return x0.stopped;
    }

    static /* synthetic */ int access$100(RMCommunicator x0) {
        return x0.rmPollInterval;
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }
}

