/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptCompletedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class TaskImpl
implements Task,
EventHandler<TaskEvent> {
    private static final Log LOG = LogFactory.getLog(TaskImpl.class);
    protected final JobConf conf;
    protected final Path jobFile;
    protected final OutputCommitter committer;
    protected final int partition;
    protected final TaskAttemptListener taskAttemptListener;
    protected final EventHandler eventHandler;
    private final TaskId taskId;
    private Map<TaskAttemptId, TaskAttempt> attempts;
    private final int maxAttempts;
    protected final Clock clock;
    private final Lock readLock;
    private final Lock writeLock;
    private final MRAppMetrics metrics;
    protected final AppContext appContext;
    private long scheduledTime;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected Credentials credentials;
    protected Token<JobTokenIdentifier> jobToken;
    private int numberUncompletedAttempts = 0;
    private boolean historyTaskStartGenerated = false;
    private static final SingleArcTransition<TaskImpl, TaskEvent> ATTEMPT_KILLED_TRANSITION = new AttemptKilledTransition(null);
    private static final SingleArcTransition<TaskImpl, TaskEvent> KILL_TRANSITION = new KillTransition(null);
    private static final StateMachineFactory<TaskImpl, TaskState, TaskEventType, TaskEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskState.NEW).addTransition((Enum)TaskState.NEW, (Enum)TaskState.SCHEDULED, (Enum)TaskEventType.T_SCHEDULE, (SingleArcTransition)new InitialScheduleTransition(null)).addTransition((Enum)TaskState.NEW, (Enum)TaskState.KILLED, (Enum)TaskEventType.T_KILL, (SingleArcTransition)new KillNewTransition(null)).addTransition((Enum)TaskState.SCHEDULED, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED, (SingleArcTransition)new LaunchTransition()).addTransition((Enum)TaskState.SCHEDULED, (Enum)TaskState.KILL_WAIT, (Enum)TaskEventType.T_KILL, KILL_TRANSITION).addTransition((Enum)TaskState.SCHEDULED, (Enum)TaskState.SCHEDULED, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskState.SCHEDULED, EnumSet.of(TaskState.SCHEDULED, TaskState.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(null)).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ATTEMPT_COMMIT_PENDING, (SingleArcTransition)new AttemptCommitPendingTransition(null)).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ADD_SPEC_ATTEMPT, (SingleArcTransition)new RedundantScheduleTransition(null)).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.SUCCEEDED, (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (SingleArcTransition)new AttemptSucceededTransition(null)).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.RUNNING, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskState.RUNNING, EnumSet.of(TaskState.RUNNING, TaskState.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(null)).addTransition((Enum)TaskState.RUNNING, (Enum)TaskState.KILL_WAIT, (Enum)TaskEventType.T_KILL, KILL_TRANSITION).addTransition((Enum)TaskState.KILL_WAIT, EnumSet.of(TaskState.KILL_WAIT, TaskState.KILLED), (Enum)TaskEventType.T_ATTEMPT_KILLED, (MultipleArcTransition)new KillWaitAttemptKilledTransition(null)).addTransition((Enum)TaskState.KILL_WAIT, (Enum)TaskState.KILL_WAIT, EnumSet.of(TaskEventType.T_KILL, new TaskEventType[]{TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ATTEMPT_FAILED, TaskEventType.T_ATTEMPT_SUCCEEDED, TaskEventType.T_ADD_SPEC_ATTEMPT})).addTransition((Enum)TaskState.SUCCEEDED, EnumSet.of(TaskState.SCHEDULED, TaskState.SUCCEEDED, TaskState.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new MapRetroactiveFailureTransition(null)).addTransition((Enum)TaskState.SUCCEEDED, (Enum)TaskState.SUCCEEDED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_KILLED)).addTransition((Enum)TaskState.FAILED, (Enum)TaskState.FAILED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ADD_SPEC_ATTEMPT)).addTransition((Enum)TaskState.KILLED, (Enum)TaskState.KILLED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ADD_SPEC_ATTEMPT)).installTopology();
    private final StateMachine<TaskState, TaskEventType, TaskEvent> stateMachine;
    protected int nextAttemptNumber = 0;
    private List<JobHistoryParser.TaskAttemptInfo> taskAttemptsFromPreviousGeneration = new ArrayList();
    private static final RecoverdAttemptsComparator RECOVERED_ATTEMPTS_COMPARATOR = new RecoverdAttemptsComparator(null);
    private TaskAttemptId commitAttempt;
    private TaskAttemptId successfulAttempt;
    private int failedAttempts;
    private int finishedAttempts;

    public TaskState getState() {
        return (TaskState)this.stateMachine.getCurrentState();
    }

    public TaskImpl(JobId jobId, TaskType taskType, int partition, EventHandler eventHandler, Path remoteJobConfFile, JobConf conf, TaskAttemptListener taskAttemptListener, OutputCommitter committer, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun, int startCount, MRAppMetrics metrics, AppContext appContext) {
        this.conf = conf;
        this.clock = clock;
        this.jobFile = remoteJobConfFile;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.attempts = Collections.emptyMap();
        this.maxAttempts = this.getMaxAttempts();
        this.taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)partition, (TaskType)taskType);
        this.partition = partition;
        this.taskAttemptListener = taskAttemptListener;
        this.eventHandler = eventHandler;
        this.committer = committer;
        this.credentials = credentials;
        this.jobToken = jobToken;
        this.metrics = metrics;
        this.appContext = appContext;
        if (completedTasksFromPreviousRun != null && completedTasksFromPreviousRun.containsKey(this.taskId)) {
            LOG.info((Object)("Task is from previous run " + this.taskId));
            JobHistoryParser.TaskInfo taskInfo = completedTasksFromPreviousRun.get(this.taskId);
            Map allAttempts = taskInfo.getAllTaskAttempts();
            this.taskAttemptsFromPreviousGeneration = new ArrayList();
            this.taskAttemptsFromPreviousGeneration.addAll(allAttempts.values());
            Collections.sort(this.taskAttemptsFromPreviousGeneration, RECOVERED_ATTEMPTS_COMPARATOR);
        }
        this.nextAttemptNumber = this.taskAttemptsFromPreviousGeneration.isEmpty() ? (startCount - 1) * 1000 : ((JobHistoryParser.TaskAttemptInfo)this.taskAttemptsFromPreviousGeneration.remove(0)).getAttemptId().getId();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TaskAttemptId, TaskAttempt> getAttempts() {
        this.readLock.lock();
        try {
            if (this.attempts.size() <= 1) {
                Map map = this.attempts;
                return map;
            }
            LinkedHashMap<TaskAttemptId, TaskAttempt> result = new LinkedHashMap<TaskAttemptId, TaskAttempt>();
            result.putAll(this.attempts);
            LinkedHashMap<TaskAttemptId, TaskAttempt> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAttempt getAttempt(TaskAttemptId attemptID) {
        this.readLock.lock();
        try {
            TaskAttempt taskAttempt = (TaskAttempt)this.attempts.get(attemptID);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public TaskId getID() {
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getState() == TaskState.SUCCEEDED || this.getState() == TaskState.FAILED || this.getState() == TaskState.KILLED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskReport getReport() {
        TaskReport report = (TaskReport)this.recordFactory.newRecordInstance(TaskReport.class);
        this.readLock.lock();
        try {
            report.setTaskId(this.taskId);
            report.setStartTime(this.getLaunchTime());
            report.setFinishTime(this.getFinishTime());
            report.setTaskState(this.getState());
            report.setProgress(this.getProgress());
            for (TaskAttempt attempt : this.attempts.values()) {
                if (!TaskAttemptState.RUNNING.equals((Object)attempt.getState())) continue;
                report.addRunningAttempt(attempt.getID());
            }
            report.setSuccessfulAttempt(this.successfulAttempt);
            for (TaskAttempt att : this.attempts.values()) {
                String prefix = "AttemptID:" + att.getID() + " Info:";
                for (String cs : att.getDiagnostics()) {
                    report.addDiagnostics(prefix + cs);
                }
            }
            report.setCounters(TypeConverter.toYarn((Counters)this.getCounters()));
            TaskReport taskReport = report;
            return taskReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counters getCounters() {
        Counters counters = null;
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            counters = bestAttempt != null ? bestAttempt.getCounters() : TaskAttemptImpl.EMPTY_COUNTERS;
            Counters counters2 = counters;
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            if (bestAttempt == null) {
                float f = 0.0f;
                return f;
            }
            float f = bestAttempt.getProgress();
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private long getLaunchTime() {
        long taskLaunchTime = 0L;
        boolean launchTimeSet = false;
        for (TaskAttempt at : this.attempts.values()) {
            long attemptLaunchTime = at.getLaunchTime();
            if (attemptLaunchTime != 0L && !launchTimeSet) {
                launchTimeSet = true;
                taskLaunchTime = attemptLaunchTime;
                continue;
            }
            if (attemptLaunchTime == 0L || taskLaunchTime <= attemptLaunchTime) continue;
            taskLaunchTime = attemptLaunchTime;
        }
        if (!launchTimeSet) {
            return this.scheduledTime;
        }
        return taskLaunchTime;
    }

    private long getFinishTime() {
        if (!this.isFinished()) {
            return 0L;
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (finishTime >= at.getFinishTime()) continue;
            finishTime = at.getFinishTime();
        }
        return finishTime;
    }

    private long getFinishTime(TaskAttemptId taId) {
        if (taId == null) {
            return this.clock.getTime();
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (!at.getID().equals((Object)taId)) continue;
            return at.getFinishTime();
        }
        return finishTime;
    }

    private TaskState finished(TaskState finalState) {
        if (this.getState() == TaskState.RUNNING) {
            this.metrics.endRunningTask((Task)this);
        }
        return finalState;
    }

    private TaskAttempt selectBestAttempt() {
        float progress = 0.0f;
        TaskAttempt result = null;
        block3: for (TaskAttempt at : this.attempts.values()) {
            float attemptProgress;
            switch (1.$SwitchMap$org$apache$hadoop$mapreduce$v2$api$records$TaskAttemptState[at.getState().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block3;
                }
            }
            if (result == null) {
                result = at;
            }
            if (!((attemptProgress = at.getProgress()) > progress)) continue;
            result = at;
            progress = attemptProgress;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canCommit(TaskAttemptId taskAttemptID) {
        this.readLock.lock();
        boolean canCommit = false;
        try {
            if (this.commitAttempt != null) {
                canCommit = taskAttemptID.equals((Object)this.commitAttempt);
                LOG.info((Object)("Result of canCommit for " + taskAttemptID + ":" + canCommit));
            }
        }
        finally {
            this.readLock.unlock();
        }
        return canCommit;
    }

    protected abstract TaskAttemptImpl createAttempt();

    protected abstract int getMaxAttempts();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskAttempt getSuccessfulAttempt() {
        this.readLock.lock();
        try {
            if (null == this.successfulAttempt) {
                TaskAttempt taskAttempt = null;
                return taskAttempt;
            }
            TaskAttempt taskAttempt = (TaskAttempt)this.attempts.get(this.successfulAttempt);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addAndScheduleAttempt() {
        TaskAttemptImpl attempt = this.createAttempt();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created attempt " + attempt.getID()));
        }
        switch (this.attempts.size()) {
            case 0: {
                this.attempts = Collections.singletonMap(attempt.getID(), attempt);
                break;
            }
            case 1: {
                LinkedHashMap newAttempts = new LinkedHashMap(this.maxAttempts);
                newAttempts.putAll(this.attempts);
                this.attempts = newAttempts;
                this.attempts.put(attempt.getID(), attempt);
                break;
            }
            default: {
                this.attempts.put(attempt.getID(), attempt);
            }
        }
        this.nextAttemptNumber = this.taskAttemptsFromPreviousGeneration.isEmpty() ? ++this.nextAttemptNumber : ((JobHistoryParser.TaskAttemptInfo)this.taskAttemptsFromPreviousGeneration.remove(0)).getAttemptId().getId();
        ++this.numberUncompletedAttempts;
        if (this.failedAttempts > 0) {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_RESCHEDULE));
        } else {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_SCHEDULE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing " + event.getTaskID() + " of type " + event.getType()));
        }
        try {
            this.writeLock.lock();
            TaskState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.taskId), (Throwable)e);
                this.internalError((TaskEventType)event.getType());
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.taskId + " Task Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void internalError(TaskEventType type) {
        LOG.error((Object)("Invalid event " + type + " on Task " + this.taskId));
        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(this.taskId.getJobId(), "Invalid event " + type + " on Task " + this.taskId));
        this.eventHandler.handle((Event)new JobEvent(this.taskId.getJobId(), JobEventType.INTERNAL_ERROR));
    }

    private void handleTaskAttemptCompletion(TaskAttemptId attemptId, TaskAttemptCompletionEventStatus status) {
        ++this.finishedAttempts;
        TaskAttempt attempt = (TaskAttempt)this.attempts.get(attemptId);
        if (attempt.getNodeHttpAddress() != null) {
            TaskAttemptCompletionEvent tce = (TaskAttemptCompletionEvent)this.recordFactory.newRecordInstance(TaskAttemptCompletionEvent.class);
            tce.setEventId(-1);
            tce.setMapOutputServerAddress("http://" + attempt.getNodeHttpAddress().split(":")[0] + ":" + attempt.getShufflePort());
            tce.setStatus(status);
            tce.setAttemptId(attempt.getID());
            int runTime = 0;
            if (attempt.getFinishTime() != 0L && attempt.getLaunchTime() != 0L) {
                runTime = (int)(attempt.getFinishTime() - attempt.getLaunchTime());
            }
            tce.setAttemptRunTime(runTime);
            this.eventHandler.handle((Event)new JobTaskAttemptCompletedEvent(tce));
        }
    }

    private static TaskFinishedEvent createTaskFinishedEvent(TaskImpl task, TaskState taskState) {
        TaskFinishedEvent tfe = new TaskFinishedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), (TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)task.successfulAttempt), task.getFinishTime(task.successfulAttempt), TypeConverter.fromYarn((TaskType)task.taskId.getTaskType()), taskState.toString(), task.getCounters());
        return tfe;
    }

    private static TaskFailedEvent createTaskFailedEvent(TaskImpl task, List<String> diag, TaskState taskState, TaskAttemptId taId) {
        StringBuilder errorSb = new StringBuilder();
        if (diag != null) {
            for (String d : diag) {
                errorSb.append(", ").append(d);
            }
        }
        TaskFailedEvent taskFailedEvent = new TaskFailedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), task.getFinishTime(taId), TypeConverter.fromYarn((TaskType)task.getType()), errorSb.toString(), taskState.toString(), (TaskAttemptID)(taId == null ? null : TypeConverter.fromYarn((TaskAttemptId)taId)));
        return taskFailedEvent;
    }

    protected String getSplitsAsString() {
        return "";
    }

    private void killUnfinishedAttempt(TaskAttempt attempt, String logMsg) {
        if (attempt != null && !attempt.isFinished()) {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_KILL));
        }
    }

    static /* synthetic */ void access$1100(TaskImpl x0) {
        x0.addAndScheduleAttempt();
    }

    static /* synthetic */ long access$1202(TaskImpl x0, long x1) {
        x0.scheduledTime = x1;
        return x0.scheduledTime;
    }

    static /* synthetic */ TaskId access$1300(TaskImpl x0) {
        return x0.taskId;
    }

    static /* synthetic */ long access$1400(TaskImpl x0) {
        return x0.getLaunchTime();
    }

    static /* synthetic */ boolean access$1502(TaskImpl x0, boolean x1) {
        x0.historyTaskStartGenerated = x1;
        return x0.historyTaskStartGenerated;
    }

    static /* synthetic */ Log access$1600() {
        return LOG;
    }

    static /* synthetic */ TaskAttemptId access$1700(TaskImpl x0) {
        return x0.commitAttempt;
    }

    static /* synthetic */ TaskAttemptId access$1702(TaskImpl x0, TaskAttemptId x1) {
        x0.commitAttempt = x1;
        return x0.commitAttempt;
    }

    static /* synthetic */ void access$1800(TaskImpl x0, TaskAttemptId x1, TaskAttemptCompletionEventStatus x2) {
        x0.handleTaskAttemptCompletion(x1, x2);
    }

    static /* synthetic */ int access$1906(TaskImpl x0) {
        return --x0.numberUncompletedAttempts;
    }

    static /* synthetic */ TaskAttemptId access$2002(TaskImpl x0, TaskAttemptId x1) {
        x0.successfulAttempt = x1;
        return x0.successfulAttempt;
    }

    static /* synthetic */ TaskAttemptId access$2000(TaskImpl x0) {
        return x0.successfulAttempt;
    }

    static /* synthetic */ boolean access$1500(TaskImpl x0) {
        return x0.historyTaskStartGenerated;
    }

    static /* synthetic */ TaskFinishedEvent access$2100(TaskImpl x0, TaskState x1) {
        return TaskImpl.createTaskFinishedEvent((TaskImpl)x0, (TaskState)x1);
    }

    static /* synthetic */ Map access$2200(TaskImpl x0) {
        return x0.attempts;
    }

    static /* synthetic */ TaskState access$2300(TaskImpl x0, TaskState x1) {
        return x0.finished(x1);
    }

    static /* synthetic */ int access$2400(TaskImpl x0) {
        return x0.finishedAttempts;
    }

    static /* synthetic */ TaskFailedEvent access$2500(TaskImpl x0, List x1, TaskState x2, TaskAttemptId x3) {
        return TaskImpl.createTaskFailedEvent((TaskImpl)x0, (List)x1, (TaskState)x2, (TaskAttemptId)x3);
    }

    static /* synthetic */ int access$2608(TaskImpl x0) {
        return x0.failedAttempts++;
    }

    static /* synthetic */ int access$2600(TaskImpl x0) {
        return x0.failedAttempts;
    }

    static /* synthetic */ int access$2700(TaskImpl x0) {
        return x0.maxAttempts;
    }

    static /* synthetic */ int access$1904(TaskImpl x0) {
        return ++x0.numberUncompletedAttempts;
    }

    static /* synthetic */ MRAppMetrics access$2800(TaskImpl x0) {
        return x0.metrics;
    }

    static /* synthetic */ void access$2900(TaskImpl x0, TaskAttempt x1, String x2) {
        x0.killUnfinishedAttempt(x1, x2);
    }

    static /* synthetic */ int access$1902(TaskImpl x0, int x1) {
        x0.numberUncompletedAttempts = x1;
        return x0.numberUncompletedAttempts;
    }
}

