/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.Iterator;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.TestMRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.yarn.event.Event;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMRApp {
    @Test
    public void testMapReduce() throws Exception {
        MRApp app = new MRApp(2, 2, true, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertEquals((String)System.getProperty("user.name"), (String)job.getUserName());
    }

    @Test
    public void testZeroMaps() throws Exception {
        MRApp app = new MRApp(0, 1, true, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
    }

    @Test
    public void testZeroMapReduces() throws Exception {
        MRApp app = new MRApp(0, 0, true, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.SUCCEEDED);
    }

    @Test
    public void testCommitPending() throws Exception {
        MRApp app = new MRApp(1, 0, false, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (int)1, (int)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        app.waitForState(attempt, TaskAttemptState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_COMMIT_PENDING));
        app.waitForState(attempt, TaskAttemptState.COMMIT_PENDING);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)task.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
    }

    public void testCompletedMapsForReduceSlowstart() throws Exception {
        MRApp app = new MRApp(2, 1, false, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.5f);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (int)3, (int)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task mapTask1 = (Task)it.next();
        Task mapTask2 = (Task)it.next();
        Task reduceTask = (Task)it.next();
        app.waitForState(mapTask1, TaskState.RUNNING);
        app.waitForState(mapTask2, TaskState.RUNNING);
        TaskAttempt task1Attempt = (TaskAttempt)mapTask1.getAttempts().values().iterator().next();
        TaskAttempt task2Attempt = (TaskAttempt)mapTask2.getAttempts().values().iterator().next();
        app.waitForState(task1Attempt, TaskAttemptState.RUNNING);
        app.waitForState(task2Attempt, TaskAttemptState.RUNNING);
        Assert.assertEquals((String)"Reduce Task state not correct", (Object)TaskState.NEW, (Object)reduceTask.getReport().getTaskState());
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)mapTask1.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(mapTask1, TaskState.SUCCEEDED);
        app.waitForState(reduceTask, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)mapTask2.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)reduceTask.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
    }

    @Test
    public void testJobError() throws Exception {
        MRApp app = new MRApp(1, 0, false, this.getClass().getName(), true);
        Job job = app.submit(new Configuration());
        app.waitForState(job, JobState.RUNNING);
        Assert.assertEquals((String)"Num tasks not correct", (int)1, (int)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new TaskEvent(task.getID(), TaskEventType.T_SCHEDULE));
        app.waitForState(job, JobState.ERROR);
    }

    @Test
    public void testCountersOnJobFinish() throws Exception {
        MRAppWithSpiedJob app = new MRAppWithSpiedJob(this, 1, 1, true, this.getClass().getName(), true, null);
        JobImpl job = (JobImpl)app.submit(new Configuration());
        app.waitForState((Job)job, JobState.SUCCEEDED);
        app.verifyCompleted();
        System.out.println(job.getAllCounters());
        job.getAllCounters();
        job.getAllCounters();
        ((JobImpl)Mockito.verify((Object)job, (VerificationMode)Mockito.times((int)1))).constructFinalFullcounters();
    }

    @Test
    public void checkJobStateTypeConversion() {
        for (JobState state : JobState.values()) {
            TypeConverter.fromYarn((JobState)state);
        }
    }

    @Test
    public void checkTaskStateTypeConversion() {
        for (TaskState state : TaskState.values()) {
            TypeConverter.fromYarn((TaskState)state);
        }
    }

    public static void main(String[] args) throws Exception {
        TestMRApp t = new TestMRApp();
        t.testMapReduce();
        t.testZeroMapReduces();
        t.testCommitPending();
        t.testCompletedMapsForReduceSlowstart();
        t.testJobError();
        t.testCountersOnJobFinish();
    }
}

