/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptListenerImpl;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.app.recover.Recovery;
import org.apache.hadoop.mapreduce.v2.app.recover.RecoveryService;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.speculate.DefaultSpeculator;
import org.apache.hadoop.mapreduce.v2.app.speculate.Speculator;
import org.apache.hadoop.mapreduce.v2.app.speculate.SpeculatorEvent;
import org.apache.hadoop.mapreduce.v2.app.taskclean.TaskCleaner;
import org.apache.hadoop.mapreduce.v2.app.taskclean.TaskCleanerImpl;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.SystemClock;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.service.CompositeService;
import org.apache.hadoop.yarn.service.Service;
import org.apache.hadoop.yarn.util.ConverterUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MRAppMaster
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(MRAppMaster.class);
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private Clock clock;
    private final long startTime;
    private final long appSubmitTime;
    private String appName;
    private final ApplicationAttemptId appAttemptID;
    private final ContainerId containerID;
    private final String nmHost;
    private final int nmPort;
    private final int nmHttpPort;
    protected final MRAppMetrics metrics;
    private Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun;
    private List<AMInfo> amInfos;
    private AppContext context;
    private Dispatcher dispatcher;
    private ClientService clientService;
    private Recovery recoveryServ;
    private ContainerAllocator containerAllocator;
    private ContainerLauncher containerLauncher;
    private TaskCleaner taskCleaner;
    private Speculator speculator;
    private TaskAttemptListener taskAttemptListener;
    private JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private JobId jobId;
    private boolean newApiCommitter;
    private OutputCommitter committer;
    private JobEventDispatcher jobEventDispatcher;
    private JobHistoryEventHandler jobHistoryEventHandler;
    private boolean inRecovery = false;
    private SpeculatorEventDispatcher speculatorEventDispatcher;
    private Job job;
    private Credentials fsTokens = new Credentials();
    private UserGroupInformation currentUser;
    private volatile boolean isLastAMRetry = false;

    public MRAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, long appSubmitTime) {
        this(applicationAttemptId, containerId, nmHost, nmPort, nmHttpPort, (Clock)new SystemClock(), appSubmitTime);
    }

    public MRAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime) {
        super(MRAppMaster.class.getName());
        this.clock = clock;
        this.startTime = clock.getTime();
        this.appSubmitTime = appSubmitTime;
        this.appAttemptID = applicationAttemptId;
        this.containerID = containerId;
        this.nmHost = nmHost;
        this.nmPort = nmPort;
        this.nmHttpPort = nmHttpPort;
        this.metrics = MRAppMetrics.create();
        LOG.info((Object)("Created MRAppMaster for application " + applicationAttemptId));
    }

    public void init(Configuration conf) {
        conf.setBoolean("yarn.dispatcher.exit-on-error", true);
        this.downloadTokensAndSetupUGI(conf);
        int numAMRetries = conf.getInt("yarn.resourcemanager.am.max-retries", 1);
        this.isLastAMRetry = this.appAttemptID.getAttemptId() >= numAMRetries;
        LOG.info((Object)("AM Retries: " + numAMRetries + " attempt num: " + this.appAttemptID.getAttemptId() + " is last retry: " + this.isLastAMRetry));
        this.context = new RunningAppContext(this, conf);
        this.appName = conf.get("mapreduce.job.name", "<missing app name>");
        conf.setInt("mapreduce.job.application.attempt.id", this.appAttemptID.getAttemptId());
        this.newApiCommitter = false;
        this.jobId = MRBuilderUtils.newJobId((ApplicationId)this.appAttemptID.getApplicationId(), (int)this.appAttemptID.getApplicationId().getId());
        int numReduceTasks = conf.getInt("mapreduce.job.reduces", 0);
        if (numReduceTasks > 0 && conf.getBoolean("mapred.reducer.new-api", false) || numReduceTasks == 0 && conf.getBoolean("mapred.mapper.new-api", false)) {
            this.newApiCommitter = true;
            LOG.info((Object)"Using mapred newApiCommitter.");
        }
        this.committer = this.createOutputCommitter(conf);
        boolean recoveryEnabled = conf.getBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        boolean recoverySupportedByCommitter = this.committer.isRecoverySupported();
        if (recoveryEnabled && recoverySupportedByCommitter && this.appAttemptID.getAttemptId() > 1) {
            LOG.info((Object)"Recovery is enabled. Will try to recover from previous life on best effort basis.");
            this.recoveryServ = this.createRecoveryService(this.context);
            this.addIfService((Object)this.recoveryServ);
            this.dispatcher = this.recoveryServ.getDispatcher();
            this.clock = this.recoveryServ.getClock();
            this.inRecovery = true;
        } else {
            LOG.info((Object)("Not starting RecoveryService: recoveryEnabled: " + recoveryEnabled + " recoverySupportedByCommitter: " + recoverySupportedByCommitter + " ApplicationAttemptID: " + this.appAttemptID.getAttemptId()));
            this.dispatcher = this.createDispatcher();
            this.addIfService((Object)this.dispatcher);
        }
        this.taskAttemptListener = this.createTaskAttemptListener(this.context);
        this.addIfService((Object)this.taskAttemptListener);
        this.taskCleaner = this.createTaskCleaner(this.context);
        this.addIfService((Object)this.taskCleaner);
        this.clientService = this.createClientService(this.context);
        this.addIfService((Object)this.clientService);
        EventHandler historyService = this.createJobHistoryHandler(this.context);
        this.dispatcher.register(EventType.class, historyService);
        this.jobEventDispatcher = new JobEventDispatcher(this, null);
        this.dispatcher.register(JobEventType.class, (EventHandler)this.jobEventDispatcher);
        this.dispatcher.register(TaskEventType.class, (EventHandler)new TaskEventDispatcher(this, null));
        this.dispatcher.register(TaskAttemptEventType.class, (EventHandler)new TaskAttemptEventDispatcher(this, null));
        this.dispatcher.register(TaskCleaner.EventType.class, (EventHandler)this.taskCleaner);
        if (conf.getBoolean("mapreduce.map.speculative", false) || conf.getBoolean("mapreduce.reduce.speculative", false)) {
            this.speculator = this.createSpeculator(conf, this.context);
            this.addIfService((Object)this.speculator);
        }
        this.speculatorEventDispatcher = new SpeculatorEventDispatcher(this, conf);
        this.dispatcher.register(Speculator.EventType.class, (EventHandler)this.speculatorEventDispatcher);
        this.containerAllocator = this.createContainerAllocator(this.clientService, this.context);
        this.addIfService((Object)this.containerAllocator);
        this.dispatcher.register(ContainerAllocator.EventType.class, (EventHandler)this.containerAllocator);
        this.containerLauncher = this.createContainerLauncher(this.context);
        this.addIfService((Object)this.containerLauncher);
        this.dispatcher.register(ContainerLauncher.EventType.class, (EventHandler)this.containerLauncher);
        this.addService((Service)this.createStagingDirCleaningService());
        this.addIfService((Object)historyService);
        super.init(conf);
    }

    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    private OutputCommitter createOutputCommitter(Configuration conf) {
        OutputCommitter committer = null;
        LOG.info((Object)("OutputCommitter set in config " + conf.get("mapred.output.committer.class")));
        if (this.newApiCommitter) {
            TaskId taskID = MRBuilderUtils.newTaskId((JobId)this.jobId, (int)0, (TaskType)TaskType.MAP);
            TaskAttemptId attemptID = MRBuilderUtils.newTaskAttemptId((TaskId)taskID, (int)0);
            TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)attemptID));
            try {
                OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)taskContext.getOutputFormatClass(), (Configuration)conf);
                committer = outputFormat.getOutputCommitter((TaskAttemptContext)taskContext);
            }
            catch (Exception e) {
                throw new YarnException((Throwable)e);
            }
        } else {
            committer = (OutputCommitter)ReflectionUtils.newInstance((Class)conf.getClass("mapred.output.committer.class", FileOutputCommitter.class, org.apache.hadoop.mapred.OutputCommitter.class), (Configuration)conf);
        }
        LOG.info((Object)("OutputCommitter is " + committer.getClass().getName()));
        return committer;
    }

    protected boolean keepJobFiles(JobConf conf) {
        return conf.getKeepTaskFilesPattern() != null || conf.getKeepFailedTaskFiles();
    }

    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get((Configuration)conf);
    }

    public void cleanupStagingDir() throws IOException {
        String jobTempDir = null;
        FileSystem fs = this.getFileSystem(this.getConfig());
        try {
            if (!this.keepJobFiles(new JobConf(this.getConfig()))) {
                jobTempDir = this.getConfig().get("mapreduce.job.dir");
                if (jobTempDir == null) {
                    LOG.warn((Object)"Job Staging directory is null");
                    return;
                }
                Path jobTempDirPath = new Path(jobTempDir);
                LOG.info((Object)("Deleting staging directory " + FileSystem.getDefaultUri((Configuration)this.getConfig()) + " " + jobTempDir));
                fs.delete(jobTempDirPath, true);
            }
        }
        catch (IOException io) {
            LOG.error((Object)("Failed to cleanup staging dir " + jobTempDir), (Throwable)io);
        }
    }

    protected void sysexit() {
        System.exit(0);
    }

    protected EventHandler<JobFinishEvent> createJobFinishEventHandler() {
        return new JobFinishEventHandler(this, null);
    }

    protected Recovery createRecoveryService(AppContext appContext) {
        return new RecoveryService(appContext.getApplicationAttemptId(), appContext.getClock(), this.getCommitter());
    }

    protected Job createJob(Configuration conf) {
        JobImpl newJob = new JobImpl(this.jobId, this.appAttemptID, conf, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.jobTokenSecretManager, this.fsTokens, this.clock, this.completedTasksFromPreviousRun, this.metrics, this.committer, this.newApiCommitter, this.currentUser.getUserName(), this.appSubmitTime, this.amInfos, this.context);
        RunningAppContext.access$700((RunningAppContext)((RunningAppContext)this.context)).put(newJob.getID(), newJob);
        this.dispatcher.register(JobFinishEvent.Type.class, this.createJobFinishEventHandler());
        return newJob;
    }

    protected void downloadTokensAndSetupUGI(Configuration conf) {
        try {
            this.currentUser = UserGroupInformation.getCurrentUser();
            if (UserGroupInformation.isSecurityEnabled()) {
                Path jobSubmitDir = FileContext.getLocalFSFileContext().makeQualified(new Path(new File("jobSubmitDir").getAbsolutePath()));
                Path jobTokenFile = new Path(jobSubmitDir, "appTokens");
                this.fsTokens.addAll(Credentials.readTokenStorageFile((Path)jobTokenFile, (Configuration)conf));
                LOG.info((Object)("jobSubmitDir=" + jobSubmitDir + " jobTokenFile=" + jobTokenFile));
                this.currentUser.addCredentials(this.fsTokens);
            }
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
    }

    protected void addIfService(Object object) {
        if (object instanceof Service) {
            this.addService((Service)object);
        }
    }

    protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
        this.jobHistoryEventHandler = new JobHistoryEventHandler(context, this.getStartCount());
        return this.jobHistoryEventHandler;
    }

    protected AbstractService createStagingDirCleaningService() {
        return new StagingDirCleaningService(this);
    }

    protected Speculator createSpeculator(Configuration conf, AppContext context) {
        try {
            Class speculatorClass = conf.getClass("yarn.app.mapreduce.am.job.speculator.class", DefaultSpeculator.class, Speculator.class);
            Constructor speculatorConstructor = speculatorClass.getConstructor(Configuration.class, AppContext.class);
            Speculator result = (Speculator)speculatorConstructor.newInstance(conf, context);
            return result;
        }
        catch (InstantiationException ex) {
            LOG.error((Object)"Can't make a speculator -- check yarn.app.mapreduce.am.job.speculator.class", (Throwable)ex);
            throw new YarnException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            LOG.error((Object)"Can't make a speculator -- check yarn.app.mapreduce.am.job.speculator.class", (Throwable)ex);
            throw new YarnException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            LOG.error((Object)"Can't make a speculator -- check yarn.app.mapreduce.am.job.speculator.class", (Throwable)ex);
            throw new YarnException((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            LOG.error((Object)"Can't make a speculator -- check yarn.app.mapreduce.am.job.speculator.class", (Throwable)ex);
            throw new YarnException((Throwable)ex);
        }
    }

    protected TaskAttemptListener createTaskAttemptListener(AppContext context) {
        TaskAttemptListenerImpl lis = new TaskAttemptListenerImpl(context, this.jobTokenSecretManager);
        return lis;
    }

    protected TaskCleaner createTaskCleaner(AppContext context) {
        return new TaskCleanerImpl(context);
    }

    protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
        return new ContainerAllocatorRouter(this, clientService, context);
    }

    protected ContainerLauncher createContainerLauncher(AppContext context) {
        return new ContainerLauncherRouter(this, context);
    }

    protected ClientService createClientService(AppContext context) {
        return new MRClientService(context);
    }

    public ApplicationId getAppID() {
        return this.appAttemptID.getApplicationId();
    }

    public ApplicationAttemptId getAttemptID() {
        return this.appAttemptID;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public OutputCommitter getCommitter() {
        return this.committer;
    }

    public boolean isNewApiCommitter() {
        return this.newApiCommitter;
    }

    public int getStartCount() {
        return this.appAttemptID.getAttemptId();
    }

    public AppContext getContext() {
        return this.context;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Map<TaskId, JobHistoryParser.TaskInfo> getCompletedTaskFromPreviousRun() {
        return this.completedTasksFromPreviousRun;
    }

    public List<AMInfo> getAllAMInfos() {
        return this.amInfos;
    }

    public ContainerAllocator getContainerAllocator() {
        return this.containerAllocator;
    }

    public ContainerLauncher getContainerLauncher() {
        return this.containerLauncher;
    }

    public TaskAttemptListener getTaskAttemptListener() {
        return this.taskAttemptListener;
    }

    public void start() {
        if (this.inRecovery) {
            this.completedTasksFromPreviousRun = this.recoveryServ.getCompletedTasks();
            this.amInfos = this.recoveryServ.getAMInfos();
        }
        if (this.amInfos == null) {
            this.amInfos = new LinkedList();
        }
        AMInfo amInfo = MRBuilderUtils.newAMInfo((ApplicationAttemptId)this.appAttemptID, (long)this.startTime, (ContainerId)this.containerID, (String)this.nmHost, (int)this.nmPort, (int)this.nmHttpPort);
        this.amInfos.add(amInfo);
        this.job = this.createJob(this.getConfig());
        for (AMInfo info : this.amInfos) {
            this.dispatcher.getEventHandler().handle((Event)new JobHistoryEvent(this.job.getID(), (HistoryEvent)new AMStartedEvent(info.getAppAttemptId(), info.getStartTime(), info.getContainerId(), info.getNodeManagerHost(), info.getNodeManagerPort(), info.getNodeManagerHttpPort())));
        }
        DefaultMetricsSystem.initialize((String)"MRAppMaster");
        JobEvent initJobEvent = new JobEvent(this.job.getID(), JobEventType.JOB_INIT);
        this.jobEventDispatcher.handle(initJobEvent);
        if (this.job.isUber()) {
            this.speculatorEventDispatcher.disableSpeculation();
            LOG.info((Object)("MRAppMaster uberizing job " + this.job.getID() + " in local container (\"uber-AM\") on node " + this.nmHost + ":" + this.nmPort + "."));
        } else {
            this.dispatcher.getEventHandler().handle((Event)new SpeculatorEvent(this.job.getID(), this.clock.getTime()));
            LOG.info((Object)("MRAppMaster launching normal, non-uberized, multi-container job " + this.job.getID() + "."));
        }
        super.start();
        this.startJobs();
    }

    protected void startJobs() {
        JobEvent startJobEvent = new JobEvent(this.job.getID(), JobEventType.JOB_START);
        this.dispatcher.getEventHandler().handle((Event)startJobEvent);
    }

    private static void validateInputParam(String value, String param) throws IOException {
        if (value == null) {
            String msg = param + " is null";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    public static void main(String[] args) {
        try {
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            String containerIdStr = System.getenv("AM_CONTAINER_ID");
            String nodeHostString = System.getenv("NM_HOST");
            String nodePortString = System.getenv("NM_PORT");
            String nodeHttpPortString = System.getenv("NM_HTTP_PORT");
            String appSubmitTimeStr = System.getenv("APP_SUBMIT_TIME_ENV");
            MRAppMaster.validateInputParam((String)containerIdStr, (String)"AM_CONTAINER_ID");
            MRAppMaster.validateInputParam((String)nodeHostString, (String)"NM_HOST");
            MRAppMaster.validateInputParam((String)nodePortString, (String)"NM_PORT");
            MRAppMaster.validateInputParam((String)nodeHttpPortString, (String)"NM_HTTP_PORT");
            MRAppMaster.validateInputParam((String)appSubmitTimeStr, (String)"APP_SUBMIT_TIME_ENV");
            ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
            ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
            long appSubmitTime = Long.parseLong(appSubmitTimeStr);
            MRAppMaster appMaster = new MRAppMaster(applicationAttemptId, containerId, nodeHostString, Integer.parseInt(nodePortString), Integer.parseInt(nodeHttpPortString), appSubmitTime);
            ShutdownHookManager.get().addShutdownHook((Runnable)new MRAppMasterShutdownHook(appMaster), 30);
            YarnConfiguration conf = new YarnConfiguration((Configuration)new JobConf());
            conf.addResource(new Path("job.xml"));
            String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
            conf.set("mapreduce.job.user.name", jobUserName);
            conf.setBoolean("fs.automatic.close", false);
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (YarnConfiguration)conf, (String)jobUserName);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting MRAppMaster", t);
            System.exit(1);
        }
    }

    protected static void initAndStartAppMaster(MRAppMaster appMaster, YarnConfiguration conf, String jobUserName) throws IOException, InterruptedException {
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation appMasterUgi = UserGroupInformation.createRemoteUser((String)jobUserName);
        appMasterUgi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Job access$300(MRAppMaster x0) {
        return x0.job;
    }

    static /* synthetic */ Log access$400() {
        return LOG;
    }

    static /* synthetic */ boolean access$502(MRAppMaster x0, boolean x1) {
        x0.isLastAMRetry = x1;
        return x0.isLastAMRetry;
    }

    static /* synthetic */ String access$800(MRAppMaster x0) {
        return x0.nmHost;
    }

    static /* synthetic */ int access$900(MRAppMaster x0) {
        return x0.nmPort;
    }

    static /* synthetic */ int access$1000(MRAppMaster x0) {
        return x0.nmHttpPort;
    }

    static /* synthetic */ ContainerId access$1100(MRAppMaster x0) {
        return x0.containerID;
    }

    static /* synthetic */ TaskAttemptListener access$1200(MRAppMaster x0) {
        return x0.taskAttemptListener;
    }

    static /* synthetic */ boolean access$500(MRAppMaster x0) {
        return x0.isLastAMRetry;
    }

    static /* synthetic */ ApplicationAttemptId access$1300(MRAppMaster x0) {
        return x0.appAttemptID;
    }

    static /* synthetic */ String access$1400(MRAppMaster x0) {
        return x0.appName;
    }

    static /* synthetic */ long access$1500(MRAppMaster x0) {
        return x0.startTime;
    }

    static /* synthetic */ Dispatcher access$1600(MRAppMaster x0) {
        return x0.dispatcher;
    }

    static /* synthetic */ Clock access$1700(MRAppMaster x0) {
        return x0.clock;
    }

    static /* synthetic */ AppContext access$1800(MRAppMaster x0) {
        return x0.context;
    }

    static /* synthetic */ Speculator access$1900(MRAppMaster x0) {
        return x0.speculator;
    }

    static /* synthetic */ ContainerAllocator access$2000(MRAppMaster x0) {
        return x0.containerAllocator;
    }

    static /* synthetic */ JobHistoryEventHandler access$2100(MRAppMaster x0) {
        return x0.jobHistoryEventHandler;
    }
}

