/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSAudit;
import org.apache.hadoop.crypto.key.kms.server.KMSAuditLogger;
import org.apache.hadoop.crypto.key.kms.server.SimpleKMSAuditLogger;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ThreadUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestKMSAudit {
    private PrintStream originalOut;
    private ByteArrayOutputStream memOut;
    private FilterOut filterOut;
    private PrintStream capturedOut;
    private KMSAudit kmsAudit;
    @Rule
    public final Timeout testTimeout = new Timeout(180000);

    @Before
    public void setUp() throws IOException {
        this.originalOut = System.err;
        this.memOut = new ByteArrayOutputStream();
        this.filterOut = new FilterOut(this.memOut);
        this.capturedOut = new PrintStream(this.filterOut);
        System.setErr(this.capturedOut);
        InputStream is = ThreadUtil.getResourceAsStream((String)"log4j-kmsaudit.properties");
        PropertyConfigurator.configure((InputStream)is);
        IOUtils.closeStream((Closeable)is);
        Configuration conf = new Configuration();
        this.kmsAudit = new KMSAudit(conf);
    }

    @After
    public void cleanUp() {
        System.setErr(this.originalOut);
        LogManager.resetConfiguration();
        this.kmsAudit.shutdown();
    }

    private String getAndResetLogOutput() {
        this.capturedOut.flush();
        String logOutput = new String(this.memOut.toByteArray());
        this.memOut = new ByteArrayOutputStream();
        this.filterOut.setOutputStream(this.memOut);
        return logOutput;
    }

    @Test
    public void testAggregation() throws Exception {
        UserGroupInformation luser = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)luser.getShortUserName()).thenReturn((Object)"luser");
        this.kmsAudit.ok(luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.DELETE_KEY, "k1", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.ROLL_NEW_VERSION, "k1", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.evictCacheForTesting();
        this.kmsAudit.ok(luser, KMS.KMSOp.DECRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.evictCacheForTesting();
        this.kmsAudit.ok(luser, KMS.KMSOp.REENCRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.REENCRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.REENCRYPT_EEK, "k1", "testmsg");
        this.kmsAudit.evictCacheForTesting();
        String out = this.getAndResetLogOutput();
        System.out.println(out);
        Assert.assertTrue((boolean)out.matches("OK\\[op=DECRYPT_EEK, key=k1, user=luser, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=DELETE_KEY, key=k1, user=luser\\] testmsgOK\\[op=ROLL_NEW_VERSION, key=k1, user=luser\\] testmsgOK\\[op=DECRYPT_EEK, key=k1, user=luser, accessCount=6, interval=[^m]{1,4}ms\\] testmsgOK\\[op=DECRYPT_EEK, key=k1, user=luser, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=REENCRYPT_EEK, key=k1, user=luser, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=REENCRYPT_EEK, key=k1, user=luser, accessCount=3, interval=[^m]{1,4}ms\\] testmsg"));
    }

    @Test
    public void testAggregationUnauth() throws Exception {
        UserGroupInformation luser = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)luser.getShortUserName()).thenReturn((Object)"luser");
        this.kmsAudit.unauthorized(luser, KMS.KMSOp.GENERATE_EEK, "k2");
        this.kmsAudit.evictCacheForTesting();
        this.kmsAudit.ok(luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.unauthorized(luser, KMS.KMSOp.GENERATE_EEK, "k3");
        Thread.sleep(1000L);
        this.kmsAudit.ok(luser, KMS.KMSOp.GENERATE_EEK, "k3", "testmsg");
        this.kmsAudit.evictCacheForTesting();
        String out = this.getAndResetLogOutput();
        System.out.println(out);
        Assert.assertTrue((out.matches("UNAUTHORIZED\\[op=GENERATE_EEK, key=k2, user=luser\\] OK\\[op=GENERATE_EEK, key=k3, user=luser, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=GENERATE_EEK, key=k3, user=luser, accessCount=5, interval=[^m]{1,4}ms\\] testmsgUNAUTHORIZED\\[op=GENERATE_EEK, key=k3, user=luser\\] OK\\[op=GENERATE_EEK, key=k3, user=luser, accessCount=1, interval=[^m]{1,4}ms\\] testmsg") || out.matches("UNAUTHORIZED\\[op=GENERATE_EEK, key=k2, user=luser\\] OK\\[op=GENERATE_EEK, key=k3, user=luser, accessCount=1, interval=[^m]{1,4}ms\\] testmsgUNAUTHORIZED\\[op=GENERATE_EEK, key=k3, user=luser\\] OK\\[op=GENERATE_EEK, key=k3, user=luser, accessCount=5, interval=[^m]{1,4}ms\\] testmsgOK\\[op=GENERATE_EEK, key=k3, user=luser, accessCount=1, interval=[^m]{1,4}ms\\] testmsg") ? 1 : 0) != 0);
    }

    @Test
    public void testAuditLogFormat() throws Exception {
        UserGroupInformation luser = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)luser.getShortUserName()).thenReturn((Object)"luser");
        this.kmsAudit.ok(luser, KMS.KMSOp.GENERATE_EEK, "k4", "testmsg");
        this.kmsAudit.ok(luser, KMS.KMSOp.GENERATE_EEK, "testmsg");
        this.kmsAudit.evictCacheForTesting();
        this.kmsAudit.unauthorized(luser, KMS.KMSOp.DECRYPT_EEK, "k4");
        this.kmsAudit.error(luser, "method", "url", "testmsg");
        this.kmsAudit.unauthenticated("remotehost", "method", "url", "testmsg");
        String out = this.getAndResetLogOutput();
        System.out.println(out);
        Assert.assertTrue((boolean)out.matches("OK\\[op=GENERATE_EEK, key=k4, user=luser, accessCount=1, interval=[^m]{1,4}ms\\] testmsgOK\\[op=GENERATE_EEK, user=luser\\] testmsgOK\\[op=GENERATE_EEK, key=k4, user=luser, accessCount=1, interval=[^m]{1,4}ms\\] testmsgUNAUTHORIZED\\[op=DECRYPT_EEK, key=k4, user=luser\\] ERROR\\[user=luser\\] Method:'method' Exception:'testmsg'UNAUTHENTICATED RemoteHost:remotehost Method:method URL:url ErrorMsg:'testmsg'"));
    }

    @Test
    public void testInitAuditLoggers() throws Exception {
        List loggers = (List)Whitebox.getInternalState((Object)this.kmsAudit, (String)"auditLoggers");
        Assert.assertEquals((long)1L, (long)loggers.size());
        Assert.assertEquals(SimpleKMSAuditLogger.class, ((KMSAuditLogger)loggers.get(0)).getClass());
        Configuration conf = new Configuration();
        conf.set("hadoop.kms.audit.logger", SimpleKMSAuditLogger.class.getName() + ", " + SimpleKMSAuditLogger.class.getName());
        KMSAudit audit = new KMSAudit(conf);
        loggers = (List)Whitebox.getInternalState((Object)audit, (String)"auditLoggers");
        Assert.assertEquals((long)1L, (long)loggers.size());
        Assert.assertEquals(SimpleKMSAuditLogger.class, ((KMSAuditLogger)loggers.get(0)).getClass());
        conf.set("hadoop.kms.audit.logger", SimpleKMSAuditLogger.class.getName() + ",unknown");
        try {
            new KMSAudit(conf);
            Assert.fail((String)"loggers configured but invalid, init should fail.");
        }
        catch (Exception ex) {
            GenericTestUtils.assertExceptionContains((String)"hadoop.kms.audit.logger", (Throwable)ex);
        }
    }

    private static class FilterOut
    extends FilterOutputStream {
        public FilterOut(OutputStream out) {
            super(out);
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }
    }
}

