/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.net.NetUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOfflineImageViewerForContentSummary {
    private static final Log LOG = LogFactory.getLog(TestOfflineImageViewerForContentSummary.class);
    private static File originalFsimage = null;
    private static ContentSummary summaryFromDFS = null;
    private static ContentSummary emptyDirSummaryFromDFS = null;
    private static ContentSummary fileSummaryFromDFS = null;
    private static ContentSummary symLinkSummaryFromDFS = null;
    private static ContentSummary symLinkSummaryForDirContainsFromDFS = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createOriginalFSImage() throws IOException {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            Path parentDir = new Path("/parentDir");
            Path childDir1 = new Path(parentDir, "childDir1");
            Path childDir2 = new Path(parentDir, "childDir2");
            Path dirForLinks = new Path("/dirForLinks");
            hdfs.mkdirs(parentDir);
            hdfs.mkdirs(childDir1);
            hdfs.mkdirs(childDir2);
            hdfs.mkdirs(dirForLinks);
            hdfs.setQuota(parentDir, 10L, 0x40000000L);
            Path file1OnParentDir = new Path(parentDir, "file1");
            try (FSDataOutputStream o = hdfs.create(file1OnParentDir);){
                o.write("123".getBytes());
            }
            o = hdfs.create(new Path(parentDir, "file2"));
            var9_9 = null;
            try {
                o.write("1234".getBytes());
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (o != null) {
                    if (var9_9 != null) {
                        try {
                            o.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        o.close();
                    }
                }
            }
            o = hdfs.create(new Path(childDir1, "file3"));
            var9_9 = null;
            try {
                o.write("123".getBytes());
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (o != null) {
                    if (var9_9 != null) {
                        try {
                            o.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        o.close();
                    }
                }
            }
            o = hdfs.create(new Path(parentDir, "file4"));
            var9_9 = null;
            try {
                o.write("123".getBytes());
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (o != null) {
                    if (var9_9 != null) {
                        try {
                            o.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        o.close();
                    }
                }
            }
            Path link1 = new Path("/link1");
            Path link2 = new Path("/dirForLinks/linkfordir1");
            hdfs.createSymlink(new Path("/parentDir/file4"), link1, true);
            summaryFromDFS = hdfs.getContentSummary(parentDir);
            emptyDirSummaryFromDFS = hdfs.getContentSummary(childDir2);
            fileSummaryFromDFS = hdfs.getContentSummary(file1OnParentDir);
            symLinkSummaryFromDFS = hdfs.getContentSummary(link1);
            hdfs.createSymlink(childDir1, link2, true);
            symLinkSummaryForDirContainsFromDFS = hdfs.getContentSummary(new Path("/dirForLinks"));
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            hdfs.saveNamespace();
            originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (originalFsimage == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
            LOG.debug((Object)("original FS image file is " + originalFsimage));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void deleteOriginalFSImage() {
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    @Test
    public void testGetContentSummaryForEmptyDirectory() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/parentDir/childDir2?op=GETCONTENTSUMMARY");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)200L, (long)connection.getResponseCode());
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            ContentSummary summary = webfs.getContentSummary(new Path("/parentDir/childDir2"));
            this.verifyContentSummary(emptyDirSummaryFromDFS, summary);
        }
    }

    @Test
    public void testGetContentSummaryForDirectory() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/parentDir/?op=GETCONTENTSUMMARY");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)200L, (long)connection.getResponseCode());
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            ContentSummary summary = webfs.getContentSummary(new Path("/parentDir/"));
            this.verifyContentSummary(summaryFromDFS, summary);
        }
    }

    @Test
    public void testGetContentSummaryForFile() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/parentDir/file1?op=GETCONTENTSUMMARY");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)200L, (long)connection.getResponseCode());
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            ContentSummary summary = webfs.getContentSummary(new Path("/parentDir/file1"));
            this.verifyContentSummary(fileSummaryFromDFS, summary);
        }
    }

    @Test
    public void testGetContentSummaryForSymlink() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            ContentSummary summary = webfs.getContentSummary(new Path("/link1"));
            this.verifyContentSummary(symLinkSummaryFromDFS, summary);
        }
    }

    @Test
    public void testGetContentSummaryForDirContainsSymlink() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            ContentSummary summary = webfs.getContentSummary(new Path("/dirForLinks/"));
            this.verifyContentSummary(symLinkSummaryForDirContainsFromDFS, summary);
        }
    }

    private void verifyContentSummary(ContentSummary expected, ContentSummary actual) {
        Assert.assertEquals((long)expected.getDirectoryCount(), (long)actual.getDirectoryCount());
        Assert.assertEquals((long)expected.getFileCount(), (long)actual.getFileCount());
        Assert.assertEquals((long)expected.getLength(), (long)actual.getLength());
        Assert.assertEquals((long)expected.getSpaceConsumed(), (long)actual.getSpaceConsumed());
        Assert.assertEquals((long)expected.getQuota(), (long)actual.getQuota());
        Assert.assertEquals((long)expected.getSpaceQuota(), (long)actual.getSpaceQuota());
    }

    @Test
    public void testGetContentSummaryResponseCode() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/dir123/?op=GETCONTENTSUMMARY");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        }
    }
}

