/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Supplier;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNameNodeStatusMXBean {
    public static final Log LOG = LogFactory.getLog(TestNameNodeStatusMXBean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNameNodeStatusMXBean() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            NameNode nn = cluster.getNameNode();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeStatus");
            String nnRole = (String)mbs.getAttribute(mxbeanName, "NNRole");
            Assert.assertEquals((Object)nn.getNNRole(), (Object)nnRole);
            String state = (String)mbs.getAttribute(mxbeanName, "State");
            Assert.assertEquals((Object)nn.getState(), (Object)state);
            String hostAndPort = (String)mbs.getAttribute(mxbeanName, "HostAndPort");
            Assert.assertEquals((Object)nn.getHostAndPort(), (Object)hostAndPort);
            boolean securityEnabled = (Boolean)mbs.getAttribute(mxbeanName, "SecurityEnabled");
            Assert.assertEquals((Object)nn.isSecurityEnabled(), (Object)securityEnabled);
            long lastHATransitionTime = (Long)mbs.getAttribute(mxbeanName, "LastHATransitionTime");
            Assert.assertEquals((long)nn.getLastHATransitionTime(), (long)lastHATransitionTime);
            long bytesWithFutureGenerationStamps = (Long)mbs.getAttribute(mxbeanName, "BytesWithFutureGenerationStamps");
            Assert.assertEquals((long)nn.getBytesWithFutureGenerationStamps(), (long)bytesWithFutureGenerationStamps);
            String slowPeersReport = (String)mbs.getAttribute(mxbeanName, "SlowPeersReport");
            Assert.assertEquals((Object)nn.getSlowPeersReport(), (Object)slowPeersReport);
            String slowDisksReport = (String)mbs.getAttribute(mxbeanName, "SlowDisksReport");
            Assert.assertEquals((Object)nn.getSlowDisksReport(), (Object)slowDisksReport);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameNodeMXBeanSlowDisksEnabled() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.datanode.fileio.profiling.sampling.percentage", 100);
        conf.setTimeDuration("dfs.datanode.outliers.report.interval", 1000L, TimeUnit.MILLISECONDS);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            String slowDiskPath = "test/data1/slowVolume";
            datanode.getDiskMetrics().addSlowDiskForTesting(slowDiskPath, null);
            NameNode nn = cluster.getNameNode();
            final DatanodeManager datanodeManager = nn.getNamesystem().getBlockManager().getDatanodeManager();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeStatus");
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return datanodeManager.getSlowDisksReport() != null;
                }
            }, (int)1000, (int)100000);
            String slowDisksReport = (String)mbs.getAttribute(mxbeanName, "SlowDisksReport");
            Assert.assertEquals((Object)datanodeManager.getSlowDisksReport(), (Object)slowDisksReport);
            Assert.assertTrue((boolean)slowDisksReport.contains(slowDiskPath));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

