/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.EnumMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.TestEditLog;
import org.apache.hadoop.hdfs.util.Holder;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestEditLogFileInputStream {
    private static final Log LOG = LogFactory.getLog(TestEditLogFileInputStream.class);
    private static final byte[] FAKE_LOG_DATA = TestEditLog.HADOOP20_SOME_EDITS;
    private static final File TEST_DIR = PathUtils.getTestDir(TestEditLogFileInputStream.class);

    @Test
    public void testReadURL() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        ((HttpURLConnection)Mockito.doReturn((Object)new ByteArrayInputStream(FAKE_LOG_DATA)).when((Object)conn)).getInputStream();
        ((HttpURLConnection)Mockito.doReturn((Object)200).when((Object)conn)).getResponseCode();
        ((HttpURLConnection)Mockito.doReturn((Object)Integer.toString(FAKE_LOG_DATA.length)).when((Object)conn)).getHeaderField("Content-Length");
        URLConnectionFactory factory = (URLConnectionFactory)Mockito.mock(URLConnectionFactory.class);
        ((URLConnectionFactory)Mockito.doReturn((Object)conn).when((Object)factory)).openConnection((URL)Mockito.any(), Matchers.anyBoolean());
        URL url = new URL("http://localhost/fakeLog");
        EditLogInputStream elis = EditLogFileInputStream.fromUrl((URLConnectionFactory)factory, (URL)url, (long)-12345L, (long)-12345L, (boolean)false);
        EnumMap<FSEditLogOpCodes, Holder<Integer>> counts = FSImageTestUtil.countEditLogOpTypes(elis);
        Assert.assertThat((Object)counts.get((Object)FSEditLogOpCodes.OP_ADD).held, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)counts.get((Object)FSEditLogOpCodes.OP_SET_GENSTAMP_V1).held, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)counts.get((Object)FSEditLogOpCodes.OP_CLOSE).held, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertEquals((long)FAKE_LOG_DATA.length, (long)elis.length());
        elis.close();
    }

    @Test(timeout=60000L)
    public void testScanCorruptEditLog() throws Exception {
        Configuration conf = new Configuration();
        File editLog = new File(GenericTestUtils.getTempPath((String)"testCorruptEditLog"));
        LOG.debug((Object)("Creating test edit log file: " + editLog));
        EditLogFileOutputStream elos = new EditLogFileOutputStream(conf, editLog.getAbsoluteFile(), 8192);
        elos.create(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        FSEditLogOp.OpInstanceCache cache = new FSEditLogOp.OpInstanceCache();
        FSEditLogOp.MkdirOp mkdirOp = FSEditLogOp.MkdirOp.getInstance((FSEditLogOp.OpInstanceCache)cache);
        mkdirOp.reset();
        mkdirOp.setRpcCallId(123);
        mkdirOp.setTransactionId(1L);
        mkdirOp.setInodeId(789L);
        mkdirOp.setPath("/mydir");
        PermissionStatus perms = PermissionStatus.createImmutable((String)"myuser", (String)"mygroup", (FsPermission)FsPermission.createImmutable((short)511));
        mkdirOp.setPermissionStatus(perms);
        elos.write((FSEditLogOp)mkdirOp);
        mkdirOp.reset();
        mkdirOp.setRpcCallId(456);
        mkdirOp.setTransactionId(2L);
        mkdirOp.setInodeId(123L);
        mkdirOp.setPath("/mydir2");
        perms = PermissionStatus.createImmutable((String)"myuser", (String)"mygroup", (FsPermission)FsPermission.createImmutable((short)438));
        mkdirOp.setPermissionStatus(perms);
        elos.write((FSEditLogOp)mkdirOp);
        elos.setReadyToFlush();
        elos.flushAndSync(false);
        elos.close();
        long fileLen = editLog.length();
        LOG.debug((Object)("Corrupting last 4 bytes of edit log file " + editLog + ", whose length is " + fileLen));
        RandomAccessFile rwf = new RandomAccessFile(editLog, "rw");
        rwf.seek(fileLen - 4L);
        int b = rwf.readInt();
        rwf.seek(fileLen - 4L);
        rwf.writeInt(b + 1);
        rwf.close();
        EditLogFileInputStream elis = new EditLogFileInputStream(editLog);
        Assert.assertEquals((long)NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION, (long)elis.getVersion(true));
        Assert.assertEquals((long)1L, (long)elis.scanNextOp());
        LOG.debug((Object)("Read transaction 1 from " + editLog));
        try {
            elis.scanNextOp();
            Assert.fail((String)"Expected scanNextOp to fail when op checksum was corrupt.");
        }
        catch (IOException e) {
            LOG.debug((Object)"Caught expected checksum error when reading corrupt transaction 2", (Throwable)e);
            GenericTestUtils.assertExceptionContains((String)"Transaction is corrupt.", (Throwable)e);
        }
        elis.close();
    }
}

