/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAuditLoggerWithCommands {
    static final int NUM_DATA_NODES = 2;
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    private static MiniDFSCluster cluster = null;
    private static FileSystem fileSys = null;
    private static FileSystem fs2 = null;
    private static FileSystem fs = null;
    private static GenericTestUtils.LogCapturer auditlog;
    static Configuration conf;
    static UserGroupInformation user1;
    static UserGroupInformation user2;
    private static NamenodeProtocols proto;

    @BeforeClass
    public static void initialize() throws Exception {
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.permissions.enabled", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
        user1 = UserGroupInformation.createUserForTesting((String)"theDoctor", (String[])new String[]{"tardis"});
        user2 = UserGroupInformation.createUserForTesting((String)"theEngineer", (String[])new String[]{"hadoop"});
        auditlog = GenericTestUtils.LogCapturer.captureLogs((Log)FSNamesystem.auditLog);
        proto = cluster.getNameNodeRpc();
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs2 = DFSTestUtil.getFileSystemAs(user2, conf);
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        fs.close();
        fs2.close();
        fileSys.close();
        cluster.shutdown();
    }

    @Test
    public void testGetContentSummary() throws IOException {
        Path dir1 = new Path("/dir1");
        Path dir2 = new Path("/dir2");
        String acePattern = ".*allowed=false.*ugi=theEngineer.*cmd=contentSummary.*";
        fs.mkdirs(dir1, new FsPermission(384));
        fs.mkdirs(dir2, new FsPermission(384));
        fs.setOwner(dir1, user1.getUserName(), user1.getPrimaryGroupName());
        fs.setOwner(dir2, user2.getUserName(), user2.getPrimaryGroupName());
        try {
            fs2.getContentSummary(new Path("/"));
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(acePattern);
        try {
            fs2.getContentSummary(new Path("/dir3"));
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log from getContentSummary", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testSetQuota() throws Exception {
        Path path = new Path("/testdir/testdir1");
        fs.mkdirs(path);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).setQuota(path, 10L, 10L);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String acePattern = ".*allowed=false.*ugi=theDoctor.*cmd=setQuota.*";
        int length = this.verifyAuditLogs(acePattern);
        fileSys.close();
        try {
            ((DistributedFileSystem)fileSys).setQuota(path, 10L, 10L);
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log from getContentSummary", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testConcat() throws Exception {
        Path file1 = new Path("/file1");
        Path file2 = new Path("/file2");
        Path targetDir = new Path("/target");
        String acePattern = ".*allowed=false.*ugi=theDoctor.*cmd=concat.*";
        fs.createNewFile(file1);
        fs.createNewFile(file2);
        fs.mkdirs(targetDir);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            fileSys.concat(targetDir, new Path[]{file1, file2});
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(acePattern);
        fileSys.close();
        try {
            fileSys.concat(targetDir, new Path[]{file1, file2});
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log from Concat", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testCreateRenameSnapShot() throws Exception {
        Path srcDir = new Path("/src");
        String aceCreatePattern = ".*allowed=false.*ugi=theDoctor.*cmd=createSnapshot.*";
        String aceRenamePattern = ".*allowed=false.*ugi=theDoctor.*cmd=renameSnapshot.*";
        fs.mkdirs(srcDir);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        cluster.getNamesystem().allowSnapshot(srcDir.toString());
        try {
            fileSys.createSnapshot(srcDir);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.verifyAuditLogs(aceCreatePattern);
        try {
            Path s1 = fs.createSnapshot(srcDir);
            fileSys.renameSnapshot(srcDir, s1.getName(), "test");
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException s1) {
            // empty catch block
        }
        int length = auditlog.getOutput().split("\n").length;
        this.verifyAuditLogs(aceRenamePattern);
        try {
            fs.createSnapshot(new Path("/test1"));
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fs.renameSnapshot(new Path("/test1"), "abc", "test2");
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteSnapshot() throws Exception {
        Path s1;
        Path srcDir = new Path("/src");
        fs.mkdirs(srcDir);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        cluster.getNamesystem().allowSnapshot(srcDir.toString());
        try {
            s1 = fs.createSnapshot(srcDir);
            fileSys.deleteSnapshot(srcDir, s1.getName());
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceDeletePattern = ".*allowed=false.*ugi=theDoctor.*cmd=deleteSnapshot.*";
        int length = this.verifyAuditLogs(aceDeletePattern);
        fileSys.close();
        try {
            s1 = fs.createSnapshot(srcDir);
            fileSys.deleteSnapshot(srcDir, s1.getName());
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length + 1 == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testAddCacheDirective() throws Exception {
        this.removeExistingCachePools(null);
        proto.addCachePool(new CachePoolInfo("pool1").setMode(new FsPermission(0)));
        CacheDirectiveInfo alpha = new CacheDirectiveInfo.Builder().setPath(new Path("/alpha")).setPool("pool1").build();
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).addCacheDirective(alpha);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceAddCachePattern = ".*allowed=false.*ugi=theDoctor.*cmd=addCache.*";
        int length = this.verifyAuditLogs(aceAddCachePattern);
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).addCacheDirective(alpha);
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testModifyCacheDirective() throws Exception {
        this.removeExistingCachePools(null);
        proto.addCachePool(new CachePoolInfo("pool1").setMode(new FsPermission(0)));
        CacheDirectiveInfo alpha = new CacheDirectiveInfo.Builder().setPath(new Path("/alpha")).setPool("pool1").build();
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        Long id = ((DistributedFileSystem)fs).addCacheDirective(alpha);
        try {
            ((DistributedFileSystem)fileSys).modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(id).setReplication(Short.valueOf((short)1)).build());
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceModifyCachePattern = ".*allowed=false.*ugi=theDoctor.*cmd=modifyCache.*";
        this.verifyAuditLogs(aceModifyCachePattern);
        fileSys.close();
        try {
            ((DistributedFileSystem)fileSys).modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(id).setReplication(Short.valueOf((short)1)).build());
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveCacheDirective() throws Exception {
        this.removeExistingCachePools(null);
        proto.addCachePool(new CachePoolInfo("pool1").setMode(new FsPermission(0)));
        CacheDirectiveInfo alpha = new CacheDirectiveInfo.Builder().setPath(new Path("/alpha")).setPool("pool1").build();
        String aceRemoveCachePattern = ".*allowed=false.*ugi=theDoctor.*cmd=removeCache.*";
        int length = -1;
        Long id = ((DistributedFileSystem)fs).addCacheDirective(alpha);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).removeCacheDirective(id.longValue());
            Assert.fail((String)"It should have failed with an AccessControlException");
        }
        catch (AccessControlException ace) {
            length = this.verifyAuditLogs(aceRemoveCachePattern);
        }
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).removeCacheDirective(id.longValue());
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testGetSnapshotDiffReport() throws Exception {
        Path snapshotDirPath = new Path("/test");
        fs.mkdirs(snapshotDirPath, new FsPermission(0));
        cluster.getNamesystem().allowSnapshot(snapshotDirPath.toString());
        Path s1 = fs.createSnapshot(snapshotDirPath);
        Path s2 = fs.createSnapshot(snapshotDirPath);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).getSnapshotDiffReport(snapshotDirPath, s1.getName(), s2.getName());
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceSnapshotDiffPattern = ".*allowed=false.*ugi=theDoctor.*cmd=computeSnapshotDiff.*";
        int length = this.verifyAuditLogs(aceSnapshotDiffPattern);
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).getSnapshotDiffReport(snapshotDirPath, s1.getName(), s2.getName());
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testGetQuotaUsage() throws Exception {
        Path path = new Path("/test");
        fs.mkdirs(path, new FsPermission(0));
        String aceGetQuotaUsagePattern = ".*allowed=false.*ugi=theDoctor.*cmd=quotaUsage.*";
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            fileSys.getQuotaUsage(path);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceGetQuotaUsagePattern);
        fileSys.close();
        try {
            fileSys.getQuotaUsage(path);
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testAddCachePool() throws Exception {
        this.removeExistingCachePools(null);
        CachePoolInfo cacheInfo = new CachePoolInfo("pool1").setMode(new FsPermission(0));
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).addCachePool(cacheInfo);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceAddCachePoolPattern = ".*allowed=false.*ugi=theDoctor.*cmd=addCachePool.*";
        int length = this.verifyAuditLogs(aceAddCachePoolPattern);
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).addCachePool(cacheInfo);
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testModifyCachePool() throws Exception {
        this.removeExistingCachePools(null);
        CachePoolInfo cacheInfo = new CachePoolInfo("pool1").setMode(new FsPermission(0));
        ((DistributedFileSystem)fs).addCachePool(cacheInfo);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).modifyCachePool(cacheInfo);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceModifyCachePoolPattern = ".*allowed=false.*ugi=theDoctor.*cmd=modifyCachePool.*";
        int length = this.verifyAuditLogs(aceModifyCachePoolPattern);
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).modifyCachePool(cacheInfo);
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveCachePool() throws Exception {
        this.removeExistingCachePools(null);
        CachePoolInfo cacheInfo = new CachePoolInfo("pool1").setMode(new FsPermission(0));
        ((DistributedFileSystem)fs).addCachePool(cacheInfo);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            ((DistributedFileSystem)fileSys).removeCachePool("pool1");
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String aceRemoveCachePoolPattern = ".*allowed=false.*ugi=theDoctor.*cmd=removeCachePool.*";
        int length = this.verifyAuditLogs(aceRemoveCachePoolPattern);
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
        try {
            fileSys.close();
            ((DistributedFileSystem)fileSys).removeCachePool("pool1");
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testGetEZForPath() throws Exception {
        Path path = new Path("/test");
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.mkdirs(path, new FsPermission(0));
        String aceGetEzForPathPattern = ".*allowed=false.*ugi=theDoctor.*cmd=getEZForPath.*";
        try {
            ((DistributedFileSystem)fileSys).getEZForPath(path);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceGetEzForPathPattern);
        fileSys.close();
        try {
            ((DistributedFileSystem)fileSys).getEZForPath(path);
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testRenameTo() throws Exception {
        Path path = new Path("/test");
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.mkdirs(path, new FsPermission(0));
        String aceRenameToPattern = ".*allowed=false.*ugi=theDoctor.*cmd=rename.*";
        try {
            fileSys.rename(path, path);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceRenameToPattern);
        fileSys.close();
        try {
            fileSys.rename(path, path);
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testGetXattrs() throws Exception {
        Path path = new Path("/test");
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.mkdirs(path, new FsPermission(0));
        String aceGetXattrsPattern = ".*allowed=false.*ugi=theDoctor.*cmd=getXAttrs.*";
        try {
            fileSys.getXAttrs(path);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceGetXattrsPattern);
        fileSys.close();
        try {
            fileSys.getXAttrs(path);
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
    }

    @Test
    public void testListXattrs() throws Exception {
        Path path = new Path("/test");
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.mkdirs(path);
        fs.setOwner(path, user1.getUserName(), user1.getPrimaryGroupName());
        String aceListXattrsPattern = ".*allowed=true.*ugi=theDoctor.*cmd=listXAttrs.*";
        fileSys.listXAttrs(path);
        this.verifyAuditLogs(aceListXattrsPattern);
    }

    @Test
    public void testGetAclStatus() throws Exception {
        Path path = new Path("/test");
        fs.mkdirs(path);
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs.setOwner(path, user1.getUserName(), user1.getPrimaryGroupName());
        FSDirectory dir = cluster.getNamesystem().getFSDirectory();
        FSDirectory mockedDir = (FSDirectory)Mockito.spy((Object)dir);
        AccessControlException ex = new AccessControlException();
        ((FSDirectory)Mockito.doThrow((Throwable)ex).when((Object)mockedDir)).getPermissionChecker();
        cluster.getNamesystem().setFSDirectory(mockedDir);
        String aceGetAclStatus = ".*allowed=false.*ugi=theDoctor.*cmd=getAclStatus.*";
        try {
            fileSys.getAclStatus(path);
            Assert.fail((String)"The operation should have failed with AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int length = this.verifyAuditLogs(aceGetAclStatus);
        fileSys.close();
        try {
            fileSys.getAclStatus(path);
            this.verifyAuditLogs(aceGetAclStatus);
            Assert.fail((String)"The operation should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Unexpected log!", (length == auditlog.getOutput().split("\n").length ? 1 : 0) != 0);
        cluster.getNamesystem().setFSDirectory(dir);
    }

    @Test
    public void testDelegationTokens() throws Exception {
        final Token dt = fs.getDelegationToken("foo");
        String getDT = ".*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*";
        this.verifyAuditLogs(true, ".*cmd=getDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        UserGroupInformation foo = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[0]);
        foo.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                dt.renew(conf);
                return null;
            }
        });
        this.verifyAuditLogs(true, ".*cmd=renewDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        try {
            dt.renew(conf);
            Assert.fail((String)"Renewing a token with non-renewer should fail");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.verifyAuditLogs(false, ".*cmd=renewDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        UserGroupInformation bar = UserGroupInformation.createUserForTesting((String)"bar", (String[])new String[0]);
        try {
            bar.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    dt.cancel(conf);
                    return null;
                }
            });
            Assert.fail((String)"Canceling a token with non-renewer should fail");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.verifyAuditLogs(false, ".*cmd=cancelDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        dt.cancel(conf);
        this.verifyAuditLogs(true, ".*cmd=cancelDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
    }

    private int verifyAuditLogs(boolean allowed, String pattern) {
        return this.verifyAuditLogs(".*allowed=" + allowed + pattern);
    }

    private int verifyAuditLogs(String pattern) {
        int length = auditlog.getOutput().split("\n").length;
        String lastAudit = auditlog.getOutput().split("\n")[length - 1];
        Assert.assertTrue((String)"Unexpected log!", (boolean)lastAudit.matches(pattern));
        return length;
    }

    private void removeExistingCachePools(String prevPool) throws Exception {
        BatchedRemoteIterator.BatchedEntries entries = proto.listCachePools(prevPool);
        for (int i = 0; i < entries.size(); ++i) {
            proto.removeCachePool(((CachePoolEntry)entries.get(i)).getInfo().getPoolName());
        }
    }
}

