/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.TestStateStoreDriverBase;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileSystemImpl;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStateStoreFileSystem
extends TestStateStoreDriverBase {
    private static MiniDFSCluster dfsCluster;

    @BeforeClass
    public static void setupCluster() throws Exception {
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration(StateStoreFileSystemImpl.class);
        conf.set("dfs.federation.router.store.driver.fs.path", "/hdfs-federation/");
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        builder.numDataNodes(1);
        dfsCluster = builder.build();
        dfsCluster.waitClusterUp();
        TestStateStoreFileSystem.getStateStore(conf);
    }

    @AfterClass
    public static void tearDownCluster() {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    @Before
    public void startup() throws IOException {
        TestStateStoreFileSystem.removeAll(this.getStateStoreDriver());
    }

    @Test
    public void testInsert() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testInsert(this.getStateStoreDriver());
    }

    @Test
    public void testUpdate() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testInsert(this.getStateStoreDriver());
    }

    @Test
    public void testDelete() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testInsert(this.getStateStoreDriver());
    }

    @Test
    public void testFetchErrors() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testFetchErrors(this.getStateStoreDriver());
    }
}

