/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.hdfs.server.federation.store.records.StateStoreVersion;
import org.junit.AfterClass;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStateStoreDriverBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestStateStoreDriverBase.class);
    private static StateStoreService stateStore;
    private static Configuration conf;
    private static final Random RANDOM;

    protected StateStoreDriver getStateStoreDriver() {
        return stateStore.getDriver();
    }

    @AfterClass
    public static void tearDownCluster() {
        if (stateStore != null) {
            stateStore.stop();
        }
    }

    public static void getStateStore(Configuration config) throws Exception {
        conf = config;
        stateStore = FederationStateStoreTestUtils.newStateStore(conf);
    }

    private String generateRandomString() {
        String randomString = "randomString-" + RANDOM.nextInt();
        return randomString;
    }

    private long generateRandomLong() {
        return RANDOM.nextLong();
    }

    private <T extends Enum> T generateRandomEnum(Class<T> enumClass) {
        int x = RANDOM.nextInt(((Enum[])enumClass.getEnumConstants()).length);
        Enum data = ((Enum[])enumClass.getEnumConstants())[x];
        return (T)data;
    }

    private <T extends BaseRecord> T generateFakeRecord(Class<T> recordClass) throws IllegalArgumentException, IllegalAccessException, IOException {
        if (recordClass == MembershipState.class) {
            return (T)MembershipState.newInstance((String)this.generateRandomString(), (String)this.generateRandomString(), (String)this.generateRandomString(), (String)this.generateRandomString(), (String)this.generateRandomString(), (String)this.generateRandomString(), (String)this.generateRandomString(), (String)this.generateRandomString(), (String)this.generateRandomString(), (FederationNamenodeServiceState)this.generateRandomEnum(FederationNamenodeServiceState.class), (boolean)false);
        }
        if (recordClass == MountTable.class) {
            String src = "/" + this.generateRandomString();
            Map<String, String> destMap = Collections.singletonMap(this.generateRandomString(), "/" + this.generateRandomString());
            return (T)MountTable.newInstance((String)src, destMap);
        }
        if (recordClass == RouterState.class) {
            RouterState routerState = RouterState.newInstance((String)this.generateRandomString(), (long)this.generateRandomLong(), (RouterServiceState)this.generateRandomEnum(RouterServiceState.class));
            StateStoreVersion version = this.generateFakeRecord(StateStoreVersion.class);
            routerState.setStateStoreVersion(version);
            return (T)routerState;
        }
        return null;
    }

    private boolean validateRecord(BaseRecord original, BaseRecord committed, boolean assertEquals) {
        boolean ret = true;
        Map<String, Class<?>> fields = TestStateStoreDriverBase.getFields(original);
        for (String key : fields.keySet()) {
            if (key.equals("dateModified") || key.equals("dateCreated") || key.equals("proto")) continue;
            Object data1 = TestStateStoreDriverBase.getField(original, key);
            Object data2 = TestStateStoreDriverBase.getField(committed, key);
            if (assertEquals) {
                Assert.assertEquals((String)("Field " + key + " does not match"), (Object)data1, (Object)data2);
                continue;
            }
            if (data1.equals(data2)) continue;
            ret = false;
        }
        long now = stateStore.getDriver().getTime();
        Assert.assertTrue((committed.getDateCreated() <= now && committed.getDateCreated() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((committed.getDateModified() >= committed.getDateCreated() ? 1 : 0) != 0);
        return ret;
    }

    public static void removeAll(StateStoreDriver driver) throws IOException {
        driver.removeAll(MembershipState.class);
        driver.removeAll(MountTable.class);
    }

    public <T extends BaseRecord> void testInsert(StateStoreDriver driver, Class<T> recordClass) throws IllegalArgumentException, IllegalAccessException, IOException {
        Assert.assertTrue((boolean)driver.removeAll(recordClass));
        QueryResult queryResult0 = driver.get(recordClass);
        List records0 = queryResult0.getRecords();
        Assert.assertTrue((boolean)records0.isEmpty());
        T record = this.generateFakeRecord(recordClass);
        driver.put(record, true, false);
        QueryResult queryResult1 = driver.get(recordClass);
        List records1 = queryResult1.getRecords();
        Assert.assertEquals((long)1L, (long)records1.size());
        BaseRecord record0 = (BaseRecord)records1.get(0);
        this.validateRecord((BaseRecord)record, record0, true);
        ArrayList<T> insertList = new ArrayList<T>();
        for (int i = 0; i < 10; ++i) {
            T newRecord = this.generateFakeRecord(recordClass);
            insertList.add(newRecord);
        }
        driver.putAll(insertList, true, false);
        QueryResult queryResult2 = driver.get(recordClass);
        List records2 = queryResult2.getRecords();
        Assert.assertEquals((long)11L, (long)records2.size());
    }

    public <T extends BaseRecord> void testFetchErrors(StateStoreDriver driver, Class<T> clazz) throws IllegalAccessException, IOException {
        driver.removeAll(clazz);
        QueryResult result0 = driver.get(clazz);
        Assert.assertNotNull((Object)result0);
        List records0 = result0.getRecords();
        Assert.assertEquals((long)records0.size(), (long)0L);
        T record = this.generateFakeRecord(clazz);
        Assert.assertTrue((boolean)driver.put(record, true, false));
        QueryResult result1 = driver.get(clazz);
        List records1 = result1.getRecords();
        Assert.assertEquals((long)1L, (long)records1.size());
        this.validateRecord((BaseRecord)record, (BaseRecord)records1.get(0), true);
        T fakeRecord = this.generateFakeRecord(clazz);
        Query query = new Query(fakeRecord);
        BaseRecord getRecord = driver.get(clazz, query);
        Assert.assertNull((Object)getRecord);
        Assert.assertEquals((long)driver.getMultiple(clazz, query).size(), (long)0L);
    }

    public <T extends BaseRecord> void testPut(StateStoreDriver driver, Class<T> clazz) throws IllegalArgumentException, ReflectiveOperationException, IOException, SecurityException {
        driver.removeAll(clazz);
        QueryResult records = driver.get(clazz);
        Assert.assertTrue((boolean)records.getRecords().isEmpty());
        ArrayList<T> insertList = new ArrayList<T>();
        for (int i = 0; i < 10; ++i) {
            T newRecord = this.generateFakeRecord(clazz);
            insertList.add(newRecord);
        }
        Assert.assertTrue((boolean)driver.putAll(insertList, false, true));
        records = driver.get(clazz);
        Assert.assertEquals((long)records.getRecords().size(), (long)10L);
        T updatedRecord = this.generateFakeRecord(clazz);
        BaseRecord existingRecord = (BaseRecord)records.getRecords().get(0);
        Map primaryKeys = existingRecord.getPrimaryKeys();
        for (Map.Entry entry : primaryKeys.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Class<?> fieldType = TestStateStoreDriverBase.getFieldType(existingRecord, key);
            Object field = TestStateStoreDriverBase.fromString(value, fieldType);
            Assert.assertTrue((boolean)TestStateStoreDriverBase.setField(updatedRecord, key, field));
        }
        Assert.assertFalse((boolean)driver.put(updatedRecord, false, true));
        QueryResult newRecords = driver.get(clazz);
        Assert.assertTrue((newRecords.getRecords().size() == 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"A single entry was improperly updated in the store", (long)10L, (long)this.countMatchingEntries(records.getRecords(), newRecords.getRecords()));
        Assert.assertTrue((boolean)driver.put(updatedRecord, true, false));
        newRecords = driver.get(clazz);
        Assert.assertEquals((long)10L, (long)newRecords.getRecords().size());
        Assert.assertEquals((String)("Record of type " + clazz + " not updated in the store"), (long)9L, (long)this.countMatchingEntries(records.getRecords(), newRecords.getRecords()));
    }

    private int countMatchingEntries(Collection<? extends BaseRecord> committedList, Collection<? extends BaseRecord> matchList) {
        int matchingCount = 0;
        block2: for (BaseRecord baseRecord : committedList) {
            for (BaseRecord baseRecord2 : matchList) {
                try {
                    if (!baseRecord2.getPrimaryKey().equals(baseRecord.getPrimaryKey())) continue;
                    if (!this.validateRecord(baseRecord2, baseRecord, false)) continue block2;
                    ++matchingCount;
                    continue block2;
                }
                catch (Exception exception) {
                }
            }
        }
        return matchingCount;
    }

    public <T extends BaseRecord> void testRemove(StateStoreDriver driver, Class<T> clazz) throws IllegalArgumentException, IllegalAccessException, IOException {
        Assert.assertTrue((boolean)driver.removeAll(clazz));
        QueryResult records = driver.get(clazz);
        Assert.assertTrue((boolean)records.getRecords().isEmpty());
        ArrayList<T> insertList = new ArrayList<T>();
        for (int i = 0; i < 10; ++i) {
            T newRecord = this.generateFakeRecord(clazz);
            insertList.add(newRecord);
        }
        Assert.assertTrue((boolean)driver.putAll(insertList, false, true));
        records = driver.get(clazz);
        Assert.assertEquals((long)records.getRecords().size(), (long)10L);
        Assert.assertTrue((boolean)driver.remove((BaseRecord)records.getRecords().get(0)));
        records = driver.get(clazz);
        Assert.assertEquals((long)records.getRecords().size(), (long)9L);
        BaseRecord firstRecord = (BaseRecord)records.getRecords().get(0);
        Query query0 = new Query(firstRecord);
        Assert.assertTrue((driver.remove(clazz, query0) > 0 ? 1 : 0) != 0);
        BaseRecord secondRecord = (BaseRecord)records.getRecords().get(1);
        Query query1 = new Query(secondRecord);
        Assert.assertTrue((driver.remove(clazz, query1) > 0 ? 1 : 0) != 0);
        records = driver.get(clazz);
        Assert.assertEquals((long)records.getRecords().size(), (long)7L);
        Assert.assertTrue((boolean)driver.removeAll(clazz));
        records = driver.get(clazz);
        Assert.assertTrue((boolean)records.getRecords().isEmpty());
    }

    public void testInsert(StateStoreDriver driver) throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testInsert(driver, MembershipState.class);
        this.testInsert(driver, MountTable.class);
    }

    public void testPut(StateStoreDriver driver) throws IllegalArgumentException, ReflectiveOperationException, IOException, SecurityException {
        this.testPut(driver, MembershipState.class);
        this.testPut(driver, MountTable.class);
    }

    public void testRemove(StateStoreDriver driver) throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testRemove(driver, MembershipState.class);
        this.testRemove(driver, MountTable.class);
    }

    public void testFetchErrors(StateStoreDriver driver) throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testFetchErrors(driver, MembershipState.class);
        this.testFetchErrors(driver, MountTable.class);
    }

    public void testMetrics(StateStoreDriver driver) throws IOException, IllegalArgumentException, IllegalAccessException {
        MountTable insertRecord = this.generateFakeRecord(MountTable.class);
        StateStoreMetrics metrics = stateStore.getMetrics();
        Assert.assertEquals((long)0L, (long)metrics.getWriteOps());
        driver.put((BaseRecord)insertRecord, true, false);
        Assert.assertEquals((long)1L, (long)metrics.getWriteOps());
        metrics.reset();
        Assert.assertEquals((long)0L, (long)metrics.getWriteOps());
        driver.put((BaseRecord)insertRecord, true, false);
        Assert.assertEquals((long)1L, (long)metrics.getWriteOps());
        metrics.reset();
        Assert.assertEquals((long)0L, (long)metrics.getReadOps());
        String querySourcePath = insertRecord.getSourcePath();
        MountTable partial = MountTable.newInstance();
        partial.setSourcePath(querySourcePath);
        Query query = new Query((BaseRecord)partial);
        driver.get(MountTable.class, query);
        Assert.assertEquals((long)1L, (long)metrics.getReadOps());
        metrics.reset();
        Assert.assertEquals((long)0L, (long)metrics.getReadOps());
        driver.get(MountTable.class);
        Assert.assertEquals((long)1L, (long)metrics.getReadOps());
        metrics.reset();
        Assert.assertEquals((long)0L, (long)metrics.getReadOps());
        driver.getMultiple(MountTable.class, query);
        Assert.assertEquals((long)1L, (long)metrics.getReadOps());
        metrics.reset();
        Assert.assertEquals((long)0L, (long)metrics.getFailureOps());
        driver.put((BaseRecord)insertRecord, false, true);
        Assert.assertEquals((long)1L, (long)metrics.getFailureOps());
        metrics.reset();
        Assert.assertEquals((long)0L, (long)metrics.getRemoveOps());
        driver.remove((BaseRecord)insertRecord);
        Assert.assertEquals((long)1L, (long)metrics.getRemoveOps());
        metrics.reset();
        driver.put((BaseRecord)insertRecord, true, false);
        Assert.assertEquals((long)0L, (long)metrics.getRemoveOps());
        driver.remove(MountTable.class, query);
        Assert.assertEquals((long)1L, (long)metrics.getRemoveOps());
        metrics.reset();
        driver.put((BaseRecord)insertRecord, true, false);
        Assert.assertEquals((long)0L, (long)metrics.getRemoveOps());
        driver.removeAll(MountTable.class);
        Assert.assertEquals((long)1L, (long)metrics.getRemoveOps());
    }

    private static boolean setField(BaseRecord record, String fieldName, Object data) {
        Method m = TestStateStoreDriverBase.locateSetter(record, fieldName);
        if (m != null) {
            try {
                m.invoke((Object)record, data);
            }
            catch (Exception e) {
                LOG.error("Cannot set field " + fieldName + " on object " + record.getClass().getName() + " to data " + data + " of type " + data.getClass(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static Method locateSetter(BaseRecord record, String fieldName) {
        for (Method m : record.getClass().getMethods()) {
            if (!m.getName().equalsIgnoreCase("set" + fieldName)) continue;
            return m;
        }
        return null;
    }

    private static Map<String, Class<?>> getFields(BaseRecord record) {
        HashMap getters = new HashMap();
        for (Method m : record.getClass().getDeclaredMethods()) {
            if (!m.getName().startsWith("get")) continue;
            try {
                Class<?> type = m.getReturnType();
                char[] c = m.getName().substring(3).toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                String key = new String(c);
                getters.put(key, type);
            }
            catch (Exception e) {
                LOG.error("Cannot execute getter " + m.getName() + " on object " + record);
            }
        }
        return getters;
    }

    private static Class<?> getFieldType(BaseRecord record, String fieldName) {
        Method m = TestStateStoreDriverBase.locateGetter(record, fieldName);
        return m.getReturnType();
    }

    private static Object getField(BaseRecord record, String fieldName) {
        Object result = null;
        Method m = TestStateStoreDriverBase.locateGetter(record, fieldName);
        if (m != null) {
            try {
                result = m.invoke((Object)record, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("Cannot get field " + fieldName + " on object " + record);
            }
        }
        return result;
    }

    private static Method locateGetter(BaseRecord record, String fieldName) {
        for (Method m : record.getClass().getMethods()) {
            if (!m.getName().equalsIgnoreCase("get" + fieldName)) continue;
            return m;
        }
        return null;
    }

    @Deprecated
    private static <T> T fromString(String data, Class<T> clazz) {
        if (data.equals("null")) {
            return null;
        }
        if (clazz == String.class) {
            return (T)data;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return (T)Long.valueOf(data);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (T)Integer.valueOf(data);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return (T)Double.valueOf(data);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return (T)Float.valueOf(data);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return (T)Boolean.valueOf(data);
        }
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, data);
        }
        return null;
    }

    static {
        RANDOM = new Random();
    }
}

