/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.RouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterMountTable {
    private static StateStoreDFSCluster cluster;
    private static RouterDFSCluster.NamenodeContext nnContext;
    private static RouterDFSCluster.RouterContext routerContext;
    private static MountTableResolver mountTable;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        cluster.addRouterOverrides(conf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        nnContext = cluster.getRandomNamenode();
        routerContext = cluster.getRandomRouter();
        Router router = routerContext.getRouter();
        mountTable = (MountTableResolver)router.getSubclusterResolver();
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testReadOnly() throws Exception {
        MountTable readOnlyEntry = MountTable.newInstance((String)"/readonly", Collections.singletonMap("ns0", "/testdir"));
        readOnlyEntry.setReadOnly(true);
        Assert.assertTrue((boolean)this.addMountTable(readOnlyEntry));
        MountTable regularEntry = MountTable.newInstance((String)"/regular", Collections.singletonMap("ns0", "/testdir"));
        Assert.assertTrue((boolean)this.addMountTable(regularEntry));
        FileSystem nnFs = nnContext.getFileSystem();
        FileSystem routerFs = routerContext.getFileSystem();
        Assert.assertTrue((boolean)routerFs.mkdirs(new Path("/regular/newdir")));
        FileStatus dirStatusNn = nnFs.getFileStatus(new Path("/testdir/newdir"));
        Assert.assertTrue((boolean)dirStatusNn.isDirectory());
        FileStatus dirStatusRegular = routerFs.getFileStatus(new Path("/regular/newdir"));
        Assert.assertTrue((boolean)dirStatusRegular.isDirectory());
        FileStatus dirStatusReadOnly = routerFs.getFileStatus(new Path("/readonly/newdir"));
        Assert.assertTrue((boolean)dirStatusReadOnly.isDirectory());
        try {
            routerFs.mkdirs(new Path("/readonly/newdirfail"));
            Assert.fail((String)"We should not be able to write into a read only mount point");
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            Assert.assertTrue((boolean)msg.startsWith("/readonly/newdirfail is in a read only mount point"));
        }
    }

    private boolean addMountTable(MountTable entry) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)entry);
        AddMountTableEntryResponse addResponse = mountTableManager.addMountTableEntry(addRequest);
        mountTable.loadCache(true);
        return addResponse.getStatus();
    }
}

