/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.RouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.impl.MountTableStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.tools.federation.RouterAdmin;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterAdminCLI {
    private static StateStoreDFSCluster cluster;
    private static RouterDFSCluster.RouterContext routerContext;
    private static StateStoreService stateStore;
    private static RouterAdmin admin;
    private static RouterClient client;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        cluster.addRouterOverrides(conf);
        cluster.startRouters();
        routerContext = cluster.getRandomRouter();
        Router router = routerContext.getRouter();
        stateStore = router.getStateStore();
        Configuration routerConf = new Configuration();
        InetSocketAddress routerSocket = router.getAdminServerAddress();
        routerConf.setSocketAddr("dfs.federation.router.admin-address", routerSocket);
        admin = new RouterAdmin(routerConf);
        client = routerContext.getAdminClient();
    }

    @AfterClass
    public static void tearDownCluster() {
        cluster.stopRouter(routerContext);
        cluster.shutdown();
        cluster = null;
    }

    @After
    public void tearDown() {
        System.setOut(OLD_OUT);
    }

    @Test
    public void testAddMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-addmounttable";
        String dest = "/addmounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        List destinations = mountTable.getDestinations();
        Assert.assertEquals((long)1L, (long)destinations.size());
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)destinations.get(0)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)destinations.get(0)).getDest());
        Assert.assertFalse((boolean)mountTable.isReadOnly());
        dest = dest + "-new";
        argv = new String[]{"-add", src, nsId, dest, "-readonly"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((long)2L, (long)mountTable.getDestinations().size());
        Assert.assertEquals((Object)nsId, (Object)((RemoteLocation)mountTable.getDestinations().get(1)).getNameserviceId());
        Assert.assertEquals((Object)dest, (Object)((RemoteLocation)mountTable.getDestinations().get(1)).getDest());
        Assert.assertTrue((boolean)mountTable.isReadOnly());
    }

    @Test
    public void testListMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-lsmounttable";
        String dest = "/lsmounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        System.setOut(new PrintStream(this.out));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        argv = new String[]{"-ls", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains(src));
        this.out.reset();
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)"/");
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        argv = new String[]{"-ls"};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains(src));
        String outStr = this.out.toString();
        for (MountTable entry : getResponse.getEntries()) {
            Assert.assertTrue((boolean)outStr.contains(entry.getSourcePath()));
        }
    }

    @Test
    public void testRemoveMountTable() throws Exception {
        String nsId = "ns0";
        String src = "/test-rmmounttable";
        String dest = "/rmmounttable";
        String[] argv = new String[]{"-add", src, nsId, dest};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance((String)src);
        GetMountTableEntriesResponse getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        MountTable mountTable = (MountTable)getResponse.getEntries().get(0);
        Assert.assertEquals((Object)src, (Object)mountTable.getSourcePath());
        argv = new String[]{"-rm", src};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        stateStore.loadCache(MountTableStoreImpl.class, true);
        getResponse = client.getMountTableManager().getMountTableEntries(getRequest);
        Assert.assertEquals((long)0L, (long)getResponse.getEntries().size());
        String invalidPath = "/invalid";
        System.setOut(new PrintStream(this.out));
        argv = new String[]{"-rm", invalidPath};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        Assert.assertTrue((boolean)this.out.toString().contains("Cannot remove mount point " + invalidPath));
    }

    static {
        OLD_OUT = System.out;
    }
}

