/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation;

import com.google.common.base.Supplier;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;

public final class FederationTestUtils {
    public static final String[] NAMESERVICES = new String[]{"ns0", "ns1"};
    public static final String[] NAMENODES = new String[]{"nn0", "nn1", "nn2", "nn3"};
    public static final String[] ROUTERS = new String[]{"router0", "router1", "router2", "router3"};

    private FederationTestUtils() {
    }

    public static void verifyException(Object obj, String methodName, Class<? extends Exception> exceptionClass, Class<?>[] parameterTypes, Object[] arguments) {
        Throwable triggeredException = null;
        try {
            Method m = obj.getClass().getMethod(methodName, parameterTypes);
            m.invoke(obj, arguments);
        }
        catch (InvocationTargetException ex) {
            triggeredException = ex.getTargetException();
        }
        catch (Exception e) {
            triggeredException = e;
        }
        if (exceptionClass != null) {
            Assert.assertNotNull((String)("No exception was triggered, expected exception" + exceptionClass.getName()), (Object)triggeredException);
            Assert.assertEquals(exceptionClass, triggeredException.getClass());
        } else {
            Assert.assertNull((String)"Exception was triggered but no exception was expected", (Object)triggeredException);
        }
    }

    public static NamenodeStatusReport createNamenodeReport(String ns, String nn, HAServiceProtocol.HAServiceState state) {
        Random rand = new Random();
        NamenodeStatusReport report = new NamenodeStatusReport(ns, nn, "localhost:" + rand.nextInt(10000), "localhost:" + rand.nextInt(10000), "localhost:" + rand.nextInt(10000), "testwebaddress-" + ns + nn);
        if (state == null) {
            return report;
        }
        report.setHAServiceState(state);
        NamespaceInfo nsInfo = new NamespaceInfo(1, "tesclusterid", ns, 0L, "testbuildvesion", "testsoftwareversion");
        report.setNamespaceInfo(nsInfo);
        return report;
    }

    public static void waitNamenodeRegistered(final ActiveNamenodeResolver resolver, final String nsId, final String nnId, final FederationNamenodeServiceState state) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    List namenodes = resolver.getNamenodesForNameserviceId(nsId);
                    if (namenodes != null) {
                        for (FederationNamenodeContext namenode : namenodes) {
                            if (namenode.getNamenodeId() != nnId && !namenode.getNamenodeId().equals(nnId)) continue;
                            return state == null || namenode.getState().equals((Object)state);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }, (int)1000, (int)20000);
    }

    public static boolean verifyDate(Date d1, Date d2, long precision) {
        return Math.abs(d1.getTime() - d2.getTime()) < precision;
    }

    public static <T> T getBean(String name, Class<T> obj) throws MalformedObjectNameException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName poolName = new ObjectName(name);
        return JMX.newMXBeanProxy(mBeanServer, poolName, obj);
    }

    public static boolean addDirectory(FileSystem context, String path) throws IOException {
        context.mkdirs(new Path(path), new FsPermission("777"));
        return FederationTestUtils.verifyFileExists(context, path);
    }

    public static FileStatus getFileStatus(FileSystem context, String path) throws IOException {
        return context.getFileStatus(new Path(path));
    }

    public static boolean verifyFileExists(FileSystem context, String path) {
        try {
            FileStatus status = FederationTestUtils.getFileStatus(context, path);
            if (status != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean checkForFileInDirectory(FileSystem context, String testPath, String targetFile) throws IOException, AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IllegalArgumentException {
        FileStatus[] fileStatus = context.listStatus(new Path(testPath));
        String file = null;
        String verifyPath = testPath + "/" + targetFile;
        if (testPath.equals("/")) {
            verifyPath = testPath + targetFile;
        }
        Boolean found = false;
        for (int i = 0; i < fileStatus.length; ++i) {
            FileStatus f = fileStatus[i];
            file = Path.getPathWithoutSchemeAndAuthority((Path)f.getPath()).toString();
            if (!file.equals(verifyPath)) continue;
            found = true;
        }
        return found;
    }

    public static int countContents(FileSystem context, String testPath) throws IOException {
        Path path = new Path(testPath);
        FileStatus[] fileStatus = context.listStatus(path);
        return fileStatus.length;
    }

    public static void createFile(FileSystem fs, String path, long length) throws IOException {
        FsPermission permissions = new FsPermission("700");
        FSDataOutputStream writeStream = fs.create(new Path(path), permissions, true, 1000, (short)1, 0x8000000L, null);
        int i = 0;
        while ((long)i < length) {
            writeStream.write(i);
            ++i;
        }
        writeStream.close();
    }

    public static String readFile(FileSystem fs, String path) throws IOException {
        String line;
        Path fileName = new Path(path);
        InputStreamReader reader = new InputStreamReader((InputStream)fs.open(fileName));
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder data = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            data.append(line);
        }
        bufferedReader.close();
        reader.close();
        return data.toString();
    }

    public static boolean deleteFile(FileSystem fs, String path) throws IOException {
        return fs.delete(new Path(path), true);
    }
}

