/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Iterator;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.LowRedundancyBlocks;
import org.junit.Assert;
import org.junit.Test;

public class TestLowRedundancyBlockQueues {
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();

    private BlockInfo genBlockInfo(long id) {
        return new BlockInfoContiguous(new Block(id), 3);
    }

    private BlockInfo genStripedBlockInfo(long id, long numBytes) {
        BlockInfoStriped sblk = new BlockInfoStriped(new Block(id), this.ecPolicy);
        sblk.setNumBytes(numBytes);
        return sblk;
    }

    private void verifyBlockStats(LowRedundancyBlocks queues, int lowRedundancyReplicaCount, int corruptReplicaCount, int corruptReplicationOneCount, int lowRedundancyStripedCount, int corruptStripedCount) {
        Assert.assertEquals((String)"Low redundancy replica count incorrect!", (long)lowRedundancyReplicaCount, (long)queues.getLowRedundancyBlocks());
        Assert.assertEquals((String)"Corrupt replica count incorrect!", (long)corruptReplicaCount, (long)queues.getCorruptBlocks());
        Assert.assertEquals((String)"Corrupt replica one count incorrect!", (long)corruptReplicationOneCount, (long)queues.getCorruptReplicationOneBlocks());
        Assert.assertEquals((String)"Low redundancy striped blocks count incorrect!", (long)lowRedundancyStripedCount, (long)queues.getLowRedundancyECBlockGroups());
        Assert.assertEquals((String)"Corrupt striped blocks count incorrect!", (long)corruptStripedCount, (long)queues.getCorruptECBlockGroups());
        Assert.assertEquals((String)"Low Redundancy count incorrect!", (long)(lowRedundancyReplicaCount + lowRedundancyStripedCount), (long)queues.getLowRedundancyBlockCount());
        Assert.assertEquals((String)"LowRedundancyBlocks queue size incorrect!", (long)(lowRedundancyReplicaCount + corruptReplicaCount + lowRedundancyStripedCount + corruptStripedCount), (long)queues.size());
    }

    @Test
    public void testBlockPriorities() throws Throwable {
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        BlockInfo block1 = this.genBlockInfo(1L);
        BlockInfo block2 = this.genBlockInfo(2L);
        BlockInfo block_very_low_redundancy = this.genBlockInfo(3L);
        BlockInfo block_corrupt = this.genBlockInfo(4L);
        BlockInfo block_corrupt_repl_one = this.genBlockInfo(5L);
        this.assertAdded(queues, block1, 1, 0, 3);
        this.assertInLevel(queues, (Block)block1, 0);
        this.verifyBlockStats(queues, 1, 0, 0, 0, 0);
        Assert.assertFalse((boolean)queues.add(block1, 1, 0, 0, 3));
        this.verifyBlockStats(queues, 1, 0, 0, 0, 0);
        this.assertAdded(queues, block2, 2, 0, 3);
        this.assertInLevel(queues, (Block)block2, 2);
        this.verifyBlockStats(queues, 2, 0, 0, 0, 0);
        this.assertAdded(queues, block_corrupt, 0, 0, 3);
        this.assertInLevel(queues, (Block)block_corrupt, 4);
        this.verifyBlockStats(queues, 2, 1, 0, 0, 0);
        this.assertAdded(queues, block_very_low_redundancy, 4, 0, 25);
        this.assertInLevel(queues, (Block)block_very_low_redundancy, 1);
        this.verifyBlockStats(queues, 3, 1, 0, 0, 0);
        this.assertAdded(queues, block_corrupt_repl_one, 0, 0, 1);
        this.verifyBlockStats(queues, 3, 2, 1, 0, 0);
        queues.update(block_corrupt_repl_one, 0, 0, 0, 3, 0, 2);
        this.verifyBlockStats(queues, 3, 2, 0, 0, 0);
        queues.update(block_corrupt, 0, 0, 0, 1, 0, -2);
        this.verifyBlockStats(queues, 3, 2, 1, 0, 0);
        queues.update(block_very_low_redundancy, 0, 0, 0, 1, -4, -24);
        this.verifyBlockStats(queues, 2, 3, 2, 0, 0);
    }

    @Test
    public void testStripedBlockPriorities() throws Throwable {
        int dataBlkNum = this.ecPolicy.getNumDataUnits();
        int parityBlkNUm = this.ecPolicy.getNumParityUnits();
        this.doTestStripedBlockPriorities(1, parityBlkNUm);
        this.doTestStripedBlockPriorities(dataBlkNum, parityBlkNUm);
    }

    private void doTestStripedBlockPriorities(int dataBlkNum, int parityBlkNum) throws Throwable {
        int groupSize = dataBlkNum + parityBlkNum;
        long numBytes = this.ecPolicy.getCellSize() * dataBlkNum;
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        int numUR = 0;
        int numCorrupt = 0;
        int i = 0;
        while (dataBlkNum + i < groupSize) {
            BlockInfo block = this.genStripedBlockInfo(-100 - 100 * i, numBytes);
            this.assertAdded(queues, block, dataBlkNum + i, 0, groupSize);
            Assert.assertEquals((long)(++numUR), (long)queues.getLowRedundancyBlockCount());
            Assert.assertEquals((long)(numUR + numCorrupt), (long)queues.size());
            if (i == 0) {
                this.assertInLevel(queues, (Block)block, 0);
            } else if (i * 3 < parityBlkNum + 1) {
                this.assertInLevel(queues, (Block)block, 1);
            } else {
                this.assertInLevel(queues, (Block)block, 2);
            }
            this.verifyBlockStats(queues, 0, 0, 0, numUR, 0);
            ++i;
        }
        BlockInfo block_corrupt = this.genStripedBlockInfo(-10L, numBytes);
        Assert.assertEquals((long)numCorrupt, (long)queues.getCorruptBlockSize());
        this.verifyBlockStats(queues, 0, 0, 0, numUR, numCorrupt);
        this.assertAdded(queues, block_corrupt, dataBlkNum - 1, 0, groupSize);
        this.verifyBlockStats(queues, 0, 0, 0, numUR, ++numCorrupt);
        this.assertInLevel(queues, (Block)block_corrupt, 4);
    }

    private void assertAdded(LowRedundancyBlocks queues, BlockInfo block, int curReplicas, int decomissionedReplicas, int expectedReplicas) {
        Assert.assertTrue((String)("Failed to add " + block), (boolean)queues.add(block, curReplicas, 0, decomissionedReplicas, expectedReplicas));
    }

    private void assertInLevel(LowRedundancyBlocks queues, Block block, int level) {
        Iterator bi = queues.iterator(level);
        while (bi.hasNext()) {
            Block next = (Block)bi.next();
            if (!block.equals((Object)next)) continue;
            return;
        }
        Assert.fail((String)("Block " + block + " not found in level " + level));
    }
}

