/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;

import com.google.common.annotations.VisibleForTesting;

/**
 * Used to inject certain faults for testing.
 */
public class EncryptionFaultInjector {
  @VisibleForTesting
  public static EncryptionFaultInjector instance =
      new EncryptionFaultInjector();

  @VisibleForTesting
  public static EncryptionFaultInjector getInstance() {
    return instance;
  }

  @VisibleForTesting
  public void startFileNoKey() throws IOException {}

  @VisibleForTesting
  public void startFileBeforeGenerateKey() throws IOException {}

  @VisibleForTesting
  public void startFileAfterGenerateKey() throws IOException {}
}
