/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.mockito.Mockito;

public class DataNodeTestUtils {
    private static final String DIR_FAILURE_SUFFIX = ".origin";

    public static DatanodeRegistration getDNRegistrationForBP(DataNode dn, String bpid) throws IOException {
        return dn.getDNRegistrationForBP(bpid);
    }

    public static void setHeartbeatsDisabledForTests(DataNode dn, boolean heartbeatsDisabledForTests) {
        dn.setHeartbeatsDisabledForTests(heartbeatsDisabledForTests);
    }

    public static void triggerDeletionReport(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerDeletionReportForTests();
        }
    }

    public static void triggerHeartbeat(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerHeartbeatForTests();
        }
    }

    public static void triggerBlockReport(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerBlockReportForTests();
        }
    }

    public static DatanodeProtocolClientSideTranslatorPB spyOnBposToNN(DataNode dn, NameNode nn) {
        String bpid = nn.getNamesystem().getBlockPoolId();
        BPOfferService bpos = null;
        for (BPOfferService thisBpos : dn.getAllBpOs()) {
            if (!thisBpos.getBlockPoolId().equals(bpid)) continue;
            bpos = thisBpos;
            break;
        }
        Preconditions.checkArgument((bpos != null ? 1 : 0) != 0, (String)"No such bpid: %s", (Object[])new Object[]{bpid});
        BPServiceActor bpsa = null;
        for (BPServiceActor thisBpsa : bpos.getBPServiceActors()) {
            if (!thisBpsa.getNNSocketAddress().equals(nn.getServiceRpcAddress())) continue;
            bpsa = thisBpsa;
            break;
        }
        Preconditions.checkArgument((bpsa != null ? 1 : 0) != 0, (String)"No service actor to NN at %s", (Object[])new Object[]{nn.getServiceRpcAddress()});
        DatanodeProtocolClientSideTranslatorPB origNN = bpsa.getNameNodeProxy();
        DatanodeProtocolClientSideTranslatorPB spy = (DatanodeProtocolClientSideTranslatorPB)Mockito.spy((Object)origNN);
        bpsa.setNameNode(spy);
        return spy;
    }

    public static InterDatanodeProtocol createInterDatanodeProtocolProxy(DataNode dn, DatanodeID datanodeid, Configuration conf, boolean connectToDnViaHostname) throws IOException {
        if (connectToDnViaHostname != dn.getDnConf().connectToDnViaHostname) {
            throw new AssertionError((Object)"Unexpected DN hostname configuration");
        }
        return DataNode.createInterDataNodeProtocolProxy((DatanodeID)datanodeid, (Configuration)conf, (int)dn.getDnConf().socketTimeout, (boolean)dn.getDnConf().connectToDnViaHostname);
    }

    public static FsDatasetSpi<?> getFSDataset(DataNode dn) {
        return dn.getFSDataset();
    }

    public static File getFile(DataNode dn, String bpid, long bid) {
        return FsDatasetTestUtil.getFile(dn.getFSDataset(), bpid, bid);
    }

    public static File getBlockFile(DataNode dn, String bpid, Block b) throws IOException {
        return FsDatasetTestUtil.getBlockFile(dn.getFSDataset(), bpid, b);
    }

    public static File getMetaFile(DataNode dn, String bpid, Block b) throws IOException {
        return FsDatasetTestUtil.getMetaFile(dn.getFSDataset(), bpid, b);
    }

    public static boolean unlinkBlock(DataNode dn, ExtendedBlock bk, int numLinks) throws IOException {
        return FsDatasetTestUtil.unlinkBlock(dn.getFSDataset(), bk, numLinks);
    }

    public static long getPendingAsyncDeletions(DataNode dn) {
        return FsDatasetTestUtil.getPendingAsyncDeletions(dn.getFSDataset());
    }

    public static ReplicaInfo fetchReplicaInfo(DataNode dn, String bpid, long blkId) {
        return FsDatasetTestUtil.fetchReplicaInfo(dn.getFSDataset(), bpid, blkId);
    }

    public static void injectDataDirFailure(File ... dirs) throws IOException {
        for (File dir : dirs) {
            File renamedTo = new File(dir.getPath() + DIR_FAILURE_SUFFIX);
            if (renamedTo.exists()) {
                throw new IOException(String.format("Can not inject failure to dir: %s because %s exists.", dir, renamedTo));
            }
            if (!dir.renameTo(renamedTo)) {
                throw new IOException(String.format("Failed to rename %s to %s.", dir, renamedTo));
            }
            if (dir.createNewFile()) continue;
            throw new IOException(String.format("Failed to create file %s to inject disk failure.", dir));
        }
    }

    public static void restoreDataDirFromFailure(File ... dirs) throws IOException {
        for (File dir : dirs) {
            File renamedDir = new File(dir.getPath() + DIR_FAILURE_SUFFIX);
            if (!renamedDir.exists()) continue;
            if (dir.exists()) {
                if (!dir.isFile()) {
                    throw new IOException("Injected failure data dir is supposed to be file: " + dir);
                }
                if (!dir.delete()) {
                    throw new IOException("Failed to delete injected failure data dir: " + dir);
                }
            }
            if (renamedDir.renameTo(dir)) continue;
            throw new IOException(String.format("Failed to recover injected failure data dir %s to %s.", renamedDir, dir));
        }
    }
}

