/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHdfsAdmin {
    private static final Path TEST_PATH = new Path("/test");
    private final Configuration conf = new Configuration();
    private MiniDFSCluster cluster;

    @Before
    public void setUpCluster() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).build();
    }

    @After
    public void shutDownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testHdfsAdminSetQuota() throws Exception {
        HdfsAdmin dfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        try (FileSystem fs = null;){
            fs = FileSystem.get((Configuration)this.conf);
            Assert.assertTrue((boolean)fs.mkdirs(TEST_PATH));
            Assert.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assert.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
            dfsAdmin.setSpaceQuota(TEST_PATH, 10L);
            Assert.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assert.assertEquals((long)10L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
            dfsAdmin.setQuota(TEST_PATH, 10L);
            Assert.assertEquals((long)10L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assert.assertEquals((long)10L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
            dfsAdmin.clearSpaceQuota(TEST_PATH);
            Assert.assertEquals((long)10L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assert.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
            dfsAdmin.clearQuota(TEST_PATH);
            Assert.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assert.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHdfsAdminWithBadUri() throws IOException, URISyntaxException {
        new HdfsAdmin(new URI("file:///bad-scheme"), this.conf);
    }
}

