/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestGenericJournalConf {
    private static final String DUMMY_URI = "dummy://test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testNotConfigured() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.dir", DUMMY_URI);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testClassDoesntExist() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.journal-plugin.dummy", "org.apache.hadoop.nonexistent");
        conf.set("dfs.namenode.edits.dir", DUMMY_URI);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadConstructor() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.journal-plugin.dummy", BadConstructorJournalManager.class.getName());
        conf.set("dfs.namenode.edits.dir", DUMMY_URI);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            Assert.fail((String)"Should have failed before this point");
        }
        catch (IllegalArgumentException iae) {
            if (!iae.getMessage().contains("Unable to construct journal")) {
                Assert.fail((String)"Should have failed with unable to construct exception");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDummyJournalManager() throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.journal-plugin.dummy", DummyJournalManager.class.getName());
        conf.set("dfs.namenode.edits.dir", DUMMY_URI);
        conf.setInt("dfs.namenode.resource.checked.volumes.minimum", 0);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            Assert.assertTrue((boolean)DummyJournalManager.shouldPromptCalled);
            Assert.assertTrue((boolean)DummyJournalManager.formatCalled);
            Assert.assertNotNull((Object)DummyJournalManager.conf);
            Assert.assertEquals((Object)new URI(DUMMY_URI), (Object)DummyJournalManager.uri);
            Assert.assertNotNull((Object)DummyJournalManager.nsInfo);
            Assert.assertEquals((Object)DummyJournalManager.nsInfo.getClusterID(), (Object)cluster.getNameNode().getNamesystem().getClusterId());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static class BadConstructorJournalManager
    extends DummyJournalManager {
        public BadConstructorJournalManager() {
            super(null, null, null);
        }

        @Override
        public void doPreUpgrade() throws IOException {
        }

        @Override
        public void doUpgrade(Storage storage) throws IOException {
        }

        @Override
        public void doFinalize() throws IOException {
        }

        @Override
        public boolean canRollBack(StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion) throws IOException {
            return false;
        }

        @Override
        public void doRollback() throws IOException {
        }

        @Override
        public long getJournalCTime() throws IOException {
            return -1L;
        }
    }

    public static class DummyJournalManager
    implements JournalManager {
        static Configuration conf = null;
        static URI uri = null;
        static NamespaceInfo nsInfo = null;
        static boolean formatCalled = false;
        static boolean shouldPromptCalled = false;

        public DummyJournalManager(Configuration conf, URI u, NamespaceInfo nsInfo) {
            DummyJournalManager.conf = conf;
            uri = u;
            DummyJournalManager.nsInfo = nsInfo;
        }

        public void format(NamespaceInfo nsInfo) throws IOException {
            formatCalled = true;
        }

        public EditLogOutputStream startLogSegment(long txId, int layoutVersion) throws IOException {
            return (EditLogOutputStream)Mockito.mock(EditLogOutputStream.class);
        }

        public void finalizeLogSegment(long firstTxId, long lastTxId) throws IOException {
        }

        public void selectInputStreams(Collection<EditLogInputStream> streams, long fromTxnId, boolean inProgressOk) {
        }

        public void setOutputBufferCapacity(int size) {
        }

        public void purgeLogsOlderThan(long minTxIdToKeep) throws IOException {
        }

        public void recoverUnfinalizedSegments() throws IOException {
        }

        public void close() throws IOException {
        }

        public boolean hasSomeData() throws IOException {
            shouldPromptCalled = true;
            return false;
        }

        public void doPreUpgrade() throws IOException {
        }

        public void doUpgrade(Storage storage) throws IOException {
        }

        public void doFinalize() throws IOException {
        }

        public boolean canRollBack(StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion) throws IOException {
            return false;
        }

        public void doRollback() throws IOException {
        }

        public void discardSegments(long startTxId) throws IOException {
        }

        public long getJournalCTime() throws IOException {
            return -1L;
        }
    }
}

