/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.mover;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.mover.Mover;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMover {
    static Mover newMover(Configuration conf) throws IOException {
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((long)1L, (long)namenodes.size());
        List nncs = NameNodeConnector.newNameNodeConnectors((Collection)namenodes, (String)Mover.class.getSimpleName(), (Path)Mover.MOVER_ID_PATH, (Configuration)conf);
        return new Mover((NameNodeConnector)nncs.get(0), conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduleSameBlock() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String file = "/testScheduleSameBlock/file";
            FSDataOutputStream out = dfs.create(new Path("/testScheduleSameBlock/file"));
            out.writeChars("testScheduleSameBlock");
            out.close();
            Mover mover = TestMover.newMover((Configuration)conf);
            mover.init();
            Mover.Processor processor = new Mover.Processor(mover);
            LocatedBlock lb = dfs.getClient().getLocatedBlocks("/testScheduleSameBlock/file", 0L).get(0);
            List locations = Mover.MLocation.toLocations((LocatedBlock)lb);
            Mover.MLocation ml = (Mover.MLocation)locations.get(0);
            Dispatcher.DBlock db = mover.newDBlock(lb.getBlock().getLocalBlock(), locations);
            ArrayList<StorageType> storageTypes = new ArrayList<StorageType>(Arrays.asList(StorageType.DEFAULT, StorageType.DEFAULT));
            Assert.assertTrue((boolean)processor.scheduleMoveReplica(db, ml, storageTypes));
            Assert.assertFalse((boolean)processor.scheduleMoveReplica(db, ml, storageTypes));
        }
        finally {
            cluster.shutdown();
        }
    }

    private void checkMovePaths(List<Path> actual, Path ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (Path p : expected) {
            Assert.assertTrue((boolean)actual.contains(p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCli() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).numDataNodes(0).build();
        try {
            Configuration conf = cluster.getConfiguration(0);
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "bar"});
                Assert.fail((String)"Expected exception for illegal path bar");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"bar is not absolute", (Throwable)e);
            }
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[0]);
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)namenodes.size());
            Assert.assertEquals((long)1L, (long)movePaths.size());
            URI nn = (URI)namenodes.iterator().next();
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            Assert.assertNull(movePaths.get(nn));
            movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "/bar"});
            namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)movePaths.size());
            nn = (URI)namenodes.iterator().next();
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            this.checkMovePaths((List)movePaths.get(nn), new Path("/foo"), new Path("/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCliWithHAConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        HATestUtil.setFailoverConfigurations(cluster, (Configuration)conf, "MyCluster");
        try {
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo", "/bar"});
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)1L, (long)namenodes.size());
            Assert.assertEquals((long)1L, (long)movePaths.size());
            URI nn = (URI)namenodes.iterator().next();
            Assert.assertEquals((Object)new URI("hdfs://MyCluster"), (Object)nn);
            Assert.assertTrue((boolean)movePaths.containsKey(nn));
            this.checkMovePaths((List)movePaths.get(nn), new Path("/foo"), new Path("/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCliWithFederation() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).numDataNodes(0).build();
        HdfsConfiguration conf = new HdfsConfiguration();
        DFSTestUtil.setFederatedConfiguration(cluster, (Configuration)conf);
        try {
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)3L, (long)namenodes.size());
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "/foo"});
                Assert.fail((String)"Expect exception for missing authority information");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"does not contain scheme and authority", (Throwable)e);
            }
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "hdfs:///foo"});
                Assert.fail((String)"Expect exception for missing authority information");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"does not contain scheme and authority", (Throwable)e);
            }
            try {
                Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", "wrong-hdfs://ns1/foo"});
                Assert.fail((String)"Expect exception for wrong scheme");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains((String)"Cannot resolve the path", (Throwable)e);
            }
            Iterator iter = namenodes.iterator();
            URI nn1 = (URI)iter.next();
            URI nn2 = (URI)iter.next();
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", nn1 + "/foo", nn1 + "/bar", nn2 + "/foo/bar"});
            Assert.assertEquals((long)2L, (long)movePaths.size());
            this.checkMovePaths((List)movePaths.get(nn1), new Path("/foo"), new Path("/bar"));
            this.checkMovePaths((List)movePaths.get(nn2), new Path("/foo/bar"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoverCliWithFederationHA() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).nnTopology(MiniDFSNNTopology.simpleHAFederatedTopology(3)).numDataNodes(0).build();
        HdfsConfiguration conf = new HdfsConfiguration();
        DFSTestUtil.setFederatedHAConfiguration(cluster, (Configuration)conf);
        try {
            Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
            Assert.assertEquals((long)3L, (long)namenodes.size());
            Iterator iter = namenodes.iterator();
            URI nn1 = (URI)iter.next();
            URI nn2 = (URI)iter.next();
            URI nn3 = (URI)iter.next();
            Map movePaths = Mover.Cli.getNameNodePathsToMove((Configuration)conf, (String[])new String[]{"-p", nn1 + "/foo", nn1 + "/bar", nn2 + "/foo/bar", nn3 + "/foobar"});
            Assert.assertEquals((long)3L, (long)movePaths.size());
            this.checkMovePaths((List)movePaths.get(nn1), new Path("/foo"), new Path("/bar"));
            this.checkMovePaths((List)movePaths.get(nn2), new Path("/foo/bar"));
            this.checkMovePaths((List)movePaths.get(nn3), new Path("/foobar"));
        }
        finally {
            cluster.shutdown();
        }
    }
}

