/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.File;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3HttpServer;
import org.apache.hadoop.hdfs.nfs.nfs3.RpcProgramNfs3;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNfs3HttpServer {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestNfs3HttpServer.class.getSimpleName();
    private static NfsConfiguration conf = new NfsConfiguration();
    private static MiniDFSCluster cluster;
    private static String keystoresDir;
    private static String sslConfDir;

    @BeforeClass
    public static void setUp() throws Exception {
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTP_AND_HTTPS.name());
        conf.set("nfs.http.address", "localhost:0");
        conf.set("nfs.https.address", "localhost:0");
        conf.setInt("nfs.server.port", 0);
        conf.setInt("nfs.mountd.port", 0);
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestNfs3HttpServer.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        FileUtil.fullyDelete((File)new File(BASEDIR));
        if (cluster != null) {
            cluster.shutdown();
        }
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    @Test
    public void testHttpServer() throws Exception {
        Nfs3 nfs = new Nfs3(conf);
        nfs.startServiceInternal(false);
        RpcProgramNfs3 nfsd = (RpcProgramNfs3)nfs.getRpcProgram();
        Nfs3HttpServer infoServer = nfsd.getInfoServer();
        String urlRoot = infoServer.getServerURI().toString();
        String pageContents = DFSTestUtil.urlGet((URL)new URL(urlRoot + "/jmx"));
        Assert.assertTrue((String)("Bad contents: " + pageContents), (boolean)pageContents.contains("java.lang:type="));
        System.out.println("pc:" + pageContents);
        int port = infoServer.getSecurePort();
        Assert.assertTrue((String)"Can't get https port", (port > 0 ? 1 : 0) != 0);
    }
}

