/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.DFSClientCache;
import org.apache.hadoop.security.UserGroupInformation;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDFSClientCache {
    @Test
    public void testEviction() throws IOException {
        NfsConfiguration conf = new NfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://localhost");
        int MAX_CACHE_SIZE = 2;
        DFSClientCache cache = new DFSClientCache(conf, 2);
        DFSClient c1 = cache.getDfsClient("test1");
        Assert.assertTrue((boolean)cache.getDfsClient("test1").toString().contains("ugi=test1"));
        Assert.assertEquals((Object)c1, (Object)cache.getDfsClient("test1"));
        Assert.assertFalse((boolean)TestDFSClientCache.isDfsClientClose((DFSClient)c1));
        cache.getDfsClient("test2");
        Assert.assertTrue((boolean)TestDFSClientCache.isDfsClientClose((DFSClient)c1));
        Assert.assertEquals((long)1L, (long)cache.clientCache.size());
    }

    @Test
    public void testGetUserGroupInformationSecure() throws IOException {
        String userName = "user1";
        String currentUser = "test-user";
        NfsConfiguration conf = new NfsConfiguration();
        UserGroupInformation currentUserUgi = UserGroupInformation.createRemoteUser((String)currentUser);
        currentUserUgi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        UserGroupInformation.setLoginUser((UserGroupInformation)currentUserUgi);
        DFSClientCache cache = new DFSClientCache(conf);
        UserGroupInformation ugiResult = cache.getUserGroupInformation(userName, currentUserUgi);
        Assert.assertThat((Object)ugiResult.getUserName(), (Matcher)Is.is((Object)userName));
        Assert.assertThat((Object)ugiResult.getRealUser(), (Matcher)Is.is((Object)currentUserUgi));
        Assert.assertThat((Object)ugiResult.getAuthenticationMethod(), (Matcher)Is.is((Object)UserGroupInformation.AuthenticationMethod.PROXY));
    }

    @Test
    public void testGetUserGroupInformation() throws IOException {
        String userName = "user1";
        String currentUser = "currentUser";
        UserGroupInformation currentUserUgi = UserGroupInformation.createUserForTesting((String)currentUser, (String[])new String[0]);
        NfsConfiguration conf = new NfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://localhost");
        DFSClientCache cache = new DFSClientCache(conf);
        UserGroupInformation ugiResult = cache.getUserGroupInformation(userName, currentUserUgi);
        Assert.assertThat((Object)ugiResult.getUserName(), (Matcher)Is.is((Object)userName));
        Assert.assertThat((Object)ugiResult.getRealUser(), (Matcher)Is.is((Object)currentUserUgi));
        Assert.assertThat((Object)ugiResult.getAuthenticationMethod(), (Matcher)Is.is((Object)UserGroupInformation.AuthenticationMethod.PROXY));
    }

    private static boolean isDfsClientClose(DFSClient c) {
        try {
            c.exists("");
        }
        catch (IOException e) {
            return e.getMessage().equals("Filesystem closed");
        }
        return false;
    }
}

