/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.nfs.nfs3.RpcProgramNfs3;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.nfs.NfsFileType;
import org.apache.hadoop.nfs.NfsTime;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.WccAttr;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.security.IdMappingServiceProvider;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;

/*
 * Exception performing whole class analysis ignored.
 */
public class Nfs3Utils {
    public static final String INODEID_PATH_PREFIX = "/.reserved/.inodes/";
    public static final String READ_RPC_START = "READ_RPC_CALL_START____";
    public static final String READ_RPC_END = "READ_RPC_CALL_END______";
    public static final String WRITE_RPC_START = "WRITE_RPC_CALL_START____";
    public static final String WRITE_RPC_END = "WRITE_RPC_CALL_END______";

    public static String getFileIdPath(FileHandle handle) {
        return Nfs3Utils.getFileIdPath((long)handle.getFileId());
    }

    public static String getFileIdPath(long fileId) {
        return "/.reserved/.inodes/" + fileId;
    }

    public static HdfsFileStatus getFileStatus(DFSClient client, String fileIdPath) throws IOException {
        return client.getFileLinkInfo(fileIdPath);
    }

    public static Nfs3FileAttributes getNfs3FileAttrFromFileStatus(HdfsFileStatus fs, IdMappingServiceProvider iug) {
        NfsFileType fileType = fs.isDir() ? NfsFileType.NFSDIR : NfsFileType.NFSREG;
        fileType = fs.isSymlink() ? NfsFileType.NFSLNK : fileType;
        return new Nfs3FileAttributes(fileType, fs.getChildrenNum(), fs.getPermission().toShort(), iug.getUidAllowingUnknown(fs.getOwner()), iug.getGidAllowingUnknown(fs.getGroup()), fs.getLen(), 0L, fs.getFileId(), fs.getModificationTime(), fs.getAccessTime());
    }

    public static Nfs3FileAttributes getFileAttr(DFSClient client, String fileIdPath, IdMappingServiceProvider iug) throws IOException {
        HdfsFileStatus fs = Nfs3Utils.getFileStatus((DFSClient)client, (String)fileIdPath);
        return fs == null ? null : Nfs3Utils.getNfs3FileAttrFromFileStatus((HdfsFileStatus)fs, (IdMappingServiceProvider)iug);
    }

    public static WccAttr getWccAttr(DFSClient client, String fileIdPath) throws IOException {
        HdfsFileStatus fstat = Nfs3Utils.getFileStatus((DFSClient)client, (String)fileIdPath);
        if (fstat == null) {
            return null;
        }
        long size = fstat.isDir() ? Nfs3FileAttributes.getDirSize((int)fstat.getChildrenNum()) : fstat.getLen();
        return new WccAttr(size, new NfsTime(fstat.getModificationTime()), new NfsTime(fstat.getModificationTime()));
    }

    public static WccAttr getWccAttr(Nfs3FileAttributes attr) {
        return attr == null ? new WccAttr() : new WccAttr(attr.getSize(), attr.getMtime(), attr.getCtime());
    }

    public static WccData createWccData(WccAttr preOpAttr, DFSClient dfsClient, String fileIdPath, IdMappingServiceProvider iug) throws IOException {
        Nfs3FileAttributes postOpDirAttr = Nfs3Utils.getFileAttr((DFSClient)dfsClient, (String)fileIdPath, (IdMappingServiceProvider)iug);
        return new WccData(preOpAttr, postOpDirAttr);
    }

    public static void writeChannel(Channel channel, XDR out, int xid) {
        if (channel == null) {
            RpcProgramNfs3.LOG.info((Object)"Null channel should only happen in tests. Do nothing.");
            return;
        }
        if (RpcProgramNfs3.LOG.isDebugEnabled()) {
            RpcProgramNfs3.LOG.debug((Object)("WRITE_RPC_CALL_END______" + xid));
        }
        ChannelBuffer outBuf = XDR.writeMessageTcp((XDR)out, (boolean)true);
        channel.write((Object)outBuf);
    }

    public static void writeChannelCommit(Channel channel, XDR out, int xid) {
        if (RpcProgramNfs3.LOG.isDebugEnabled()) {
            RpcProgramNfs3.LOG.debug((Object)("Commit done:" + xid));
        }
        ChannelBuffer outBuf = XDR.writeMessageTcp((XDR)out, (boolean)true);
        channel.write((Object)outBuf);
    }

    private static boolean isSet(int access, int bits) {
        return (access & bits) == bits;
    }

    public static int getAccessRights(int mode, int type) {
        int rtn = 0;
        if (Nfs3Utils.isSet((int)mode, (int)4)) {
            rtn |= 1;
            if (type == NfsFileType.NFSDIR.toValue()) {
                rtn |= 2;
            }
        }
        if (Nfs3Utils.isSet((int)mode, (int)2)) {
            rtn |= 4;
            rtn |= 8;
            rtn |= 0x10;
        }
        if (Nfs3Utils.isSet((int)mode, (int)1)) {
            rtn = type == NfsFileType.NFSREG.toValue() ? (rtn |= 0x20) : (rtn |= 2);
        }
        return rtn;
    }

    public static int getAccessRightsForUserGroup(int uid, int gid, int[] auxGids, Nfs3FileAttributes attr) {
        int mode = attr.getMode();
        if (uid == attr.getUid()) {
            return Nfs3Utils.getAccessRights((int)(mode >> 6), (int)attr.getType());
        }
        if (gid == attr.getGid()) {
            return Nfs3Utils.getAccessRights((int)(mode >> 3), (int)attr.getType());
        }
        if (auxGids != null) {
            for (int auxGid : auxGids) {
                if (attr.getGid() != auxGid) continue;
                return Nfs3Utils.getAccessRights((int)(mode >> 3), (int)attr.getType());
            }
        }
        return Nfs3Utils.getAccessRights((int)mode, (int)attr.getType());
    }

    public static long bytesToLong(byte[] data) {
        long n = 0xFFL & (long)data[0];
        for (int i = 1; i < 8; ++i) {
            n = n << 8 | 0xFFL & (long)data[i];
        }
        return n;
    }

    public static byte[] longToByte(long v) {
        byte[] data = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return data;
    }
}

