/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtx;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtxCache;
import org.apache.hadoop.nfs.nfs3.FileHandle;

class OpenFileCtxCache {
    private static final Log LOG = LogFactory.getLog(OpenFileCtxCache.class);
    private final ConcurrentMap<FileHandle, OpenFileCtx> openFileMap = Maps.newConcurrentMap();
    private final int maxStreams;
    private final long streamTimeout;
    private final StreamMonitor streamMonitor;

    OpenFileCtxCache(Configuration config, long streamTimeout) {
        this.maxStreams = config.getInt("dfs.nfs3.max.open.files", 256);
        LOG.info((Object)("Maximum open streams is " + this.maxStreams));
        this.streamTimeout = streamTimeout;
        this.streamMonitor = new StreamMonitor(this);
    }

    @VisibleForTesting
    Map.Entry<FileHandle, OpenFileCtx> getEntryToEvict() {
        Iterator it = this.openFileMap.entrySet().iterator();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("openFileMap size:" + this.openFileMap.size()));
        }
        Map.Entry<FileHandle, OpenFileCtx> idlest = null;
        while (it.hasNext()) {
            Map.Entry<FileHandle, OpenFileCtx> pairs = it.next();
            OpenFileCtx ctx = (OpenFileCtx)pairs.getValue();
            if (!ctx.getActiveState()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got one inactive stream: " + ctx));
                }
                return pairs;
            }
            if (ctx.hasPendingWork()) continue;
            if (idlest == null) {
                idlest = pairs;
                continue;
            }
            if (ctx.getLastAccessTime() >= idlest.getValue().getLastAccessTime()) continue;
            idlest = pairs;
        }
        if (idlest == null) {
            LOG.warn((Object)"No eviction candidate. All streams have pending work.");
            return null;
        }
        long idleTime = System.currentTimeMillis() - ((OpenFileCtx)idlest.getValue()).getLastAccessTime();
        if (idleTime < 10000L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("idlest stream's idle time:" + idleTime));
            }
            LOG.warn((Object)"All opened streams are busy, can't remove any from cache.");
            return null;
        }
        return idlest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean put(FileHandle h, OpenFileCtx context) {
        OpenFileCtx toEvict = null;
        OpenFileCtxCache openFileCtxCache = this;
        synchronized (openFileCtxCache) {
            Preconditions.checkState((this.openFileMap.size() <= this.maxStreams ? 1 : 0) != 0, (Object)("stream cache size " + this.openFileMap.size() + "  is larger than maximum" + this.maxStreams));
            if (this.openFileMap.size() == this.maxStreams) {
                Map.Entry pairs = this.getEntryToEvict();
                if (pairs == null) {
                    return false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Evict stream ctx: " + pairs.getValue()));
                }
                Preconditions.checkState(((toEvict = (OpenFileCtx)this.openFileMap.remove(pairs.getKey())) == pairs.getValue() ? 1 : 0) != 0, (Object)"The deleted entry is not the same as odlest found.");
            }
            this.openFileMap.put(h, context);
        }
        if (toEvict != null) {
            toEvict.cleanup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void scan(long streamTimeout) {
        ArrayList<OpenFileCtx> ctxToRemove = new ArrayList<OpenFileCtx>();
        Iterator it = this.openFileMap.entrySet().iterator();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("openFileMap size:" + this.openFileMap.size()));
        }
        while (it.hasNext()) {
            Map.Entry pairs = it.next();
            FileHandle handle = (FileHandle)pairs.getKey();
            OpenFileCtx ctx = (OpenFileCtx)pairs.getValue();
            if (!ctx.streamCleanup(handle.getFileId(), streamTimeout)) continue;
            OpenFileCtxCache openFileCtxCache = this;
            synchronized (openFileCtxCache) {
                OpenFileCtx ctx2 = (OpenFileCtx)this.openFileMap.get(handle);
                if (ctx2 != null && ctx2.streamCleanup(handle.getFileId(), streamTimeout)) {
                    this.openFileMap.remove(handle);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("After remove stream " + handle.getFileId() + ", the stream number:" + this.openFileMap.size()));
                    }
                    ctxToRemove.add(ctx2);
                }
            }
        }
        for (OpenFileCtx ofc : ctxToRemove) {
            ofc.cleanup();
        }
    }

    OpenFileCtx get(FileHandle key) {
        return (OpenFileCtx)this.openFileMap.get(key);
    }

    int size() {
        return this.openFileMap.size();
    }

    void start() {
        this.streamMonitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAll() {
        ArrayList<OpenFileCtx> cleanedContext = new ArrayList<OpenFileCtx>();
        OpenFileCtxCache openFileCtxCache = this;
        synchronized (openFileCtxCache) {
            Iterator it = this.openFileMap.entrySet().iterator();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("openFileMap size:" + this.openFileMap.size()));
            }
            while (it.hasNext()) {
                Map.Entry pairs = it.next();
                OpenFileCtx ctx = (OpenFileCtx)pairs.getValue();
                it.remove();
                cleanedContext.add(ctx);
            }
        }
        for (OpenFileCtx ofc : cleanedContext) {
            ofc.cleanup();
        }
    }

    void shutdown() {
        if (this.streamMonitor != null && this.streamMonitor.isAlive()) {
            this.streamMonitor.shouldRun(false);
            this.streamMonitor.interrupt();
            try {
                this.streamMonitor.join(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.cleanAll();
    }

    static /* synthetic */ long access$000(OpenFileCtxCache x0) {
        return x0.streamTimeout;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }
}

