/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.nfs.mount.Mountd;
import org.apache.hadoop.hdfs.nfs.nfs3.RpcProgramNfs3;
import org.apache.hadoop.nfs.nfs3.Nfs3Base;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.util.StringUtils;

public class Nfs3
extends Nfs3Base {
    private Mountd mountd;

    public Nfs3(Configuration conf) throws IOException {
        super((RpcProgram)new RpcProgramNfs3(conf), conf);
        this.mountd = new Mountd(conf);
    }

    public Mountd getMountd() {
        return this.mountd;
    }

    @VisibleForTesting
    public void startServiceInternal(boolean register) throws IOException {
        this.mountd.start(register);
        this.start(register);
    }

    public static void main(String[] args) throws IOException {
        StringUtils.startupShutdownMessage(Nfs3.class, (String[])args, (Log)LOG);
        Nfs3 nfsServer = new Nfs3(new Configuration());
        nfsServer.startServiceInternal(true);
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
    }
}

