/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.GlobFilter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.lib.service.FileSystemAccess;
import org.apache.hadoop.util.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
public class FSOperations {
    private static Map<String, Object> toJson(FileStatus fileStatus) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("FileStatus", FSOperations.toJsonInner(fileStatus, true));
        return json;
    }

    private static Map<String, Object> toJson(FileStatus[] fileStatuses, boolean isFile) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, JSONArray> inner = new LinkedHashMap<String, JSONArray>();
        JSONArray statuses = new JSONArray();
        for (FileStatus f : fileStatuses) {
            statuses.add(FSOperations.toJsonInner(f, isFile));
        }
        inner.put("FileStatus", statuses);
        json.put("FileStatuses", inner);
        return json;
    }

    private static Map<String, Object> toJsonInner(FileStatus fileStatus, boolean emptyPathSuffix) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("pathSuffix", emptyPathSuffix ? "" : fileStatus.getPath().getName());
        json.put("type", HttpFSFileSystem.FILE_TYPE.getType(fileStatus).toString());
        json.put("length", fileStatus.getLen());
        json.put("owner", fileStatus.getOwner());
        json.put("group", fileStatus.getGroup());
        json.put("permission", HttpFSFileSystem.permissionToString(fileStatus.getPermission()));
        json.put("accessTime", fileStatus.getAccessTime());
        json.put("modificationTime", fileStatus.getModificationTime());
        json.put("blockSize", fileStatus.getBlockSize());
        json.put("replication", fileStatus.getReplication());
        if (fileStatus.getPermission().getAclBit()) {
            json.put("aclBit", true);
        }
        if (fileStatus.getPermission().getEncryptedBit()) {
            json.put("encBit", true);
        }
        if (fileStatus.getPermission().getErasureCodedBit()) {
            json.put("ecBit", true);
        }
        return json;
    }

    private static Map<String, Object> toJson(FileSystem.DirectoryEntries entries, boolean isFile) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> inner = new LinkedHashMap<String, Object>();
        Map<String, Object> fileStatuses = FSOperations.toJson(entries.getEntries(), isFile);
        inner.put("partialListing", fileStatuses);
        inner.put("remainingEntries", entries.hasMore() ? 1 : 0);
        json.put("DirectoryListing", inner);
        return json;
    }

    private static Map<String, Object> aclStatusToJSON(AclStatus aclStatus) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> inner = new LinkedHashMap<String, Object>();
        JSONArray entriesArray = new JSONArray();
        inner.put("owner", aclStatus.getOwner());
        inner.put("group", aclStatus.getGroup());
        inner.put("stickyBit", aclStatus.isStickyBit());
        for (AclEntry e : aclStatus.getEntries()) {
            entriesArray.add((Object)e.toString());
        }
        inner.put("entries", entriesArray);
        json.put("AclStatus", inner);
        return json;
    }

    private static Map fileChecksumToJSON(FileChecksum checksum) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("algorithm", checksum.getAlgorithmName());
        json.put("bytes", StringUtils.byteToHexString((byte[])checksum.getBytes()));
        json.put("length", checksum.getLength());
        LinkedHashMap<String, LinkedHashMap<String, Object>> response = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        response.put("FileChecksum", json);
        return response;
    }

    private static Map xAttrsToJSON(Map<String, byte[]> xAttrs, XAttrCodec encoding) throws IOException {
        LinkedHashMap<String, JSONArray> jsonMap = new LinkedHashMap<String, JSONArray>();
        JSONArray jsonArray = new JSONArray();
        if (xAttrs != null) {
            for (Map.Entry<String, byte[]> e : xAttrs.entrySet()) {
                LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
                json.put("name", e.getKey());
                if (e.getValue() != null) {
                    json.put("value", XAttrCodec.encodeValue((byte[])e.getValue(), (XAttrCodec)encoding));
                }
                jsonArray.add(json);
            }
        }
        jsonMap.put("XAttrs", jsonArray);
        return jsonMap;
    }

    private static Map xAttrNamesToJSON(List<String> names) throws IOException {
        LinkedHashMap<String, String> jsonMap = new LinkedHashMap<String, String>();
        jsonMap.put("XAttrNames", JSONArray.toJSONString(names));
        return jsonMap;
    }

    private static Map contentSummaryToJSON(ContentSummary contentSummary) {
        LinkedHashMap<String, Long> json = new LinkedHashMap<String, Long>();
        json.put("directoryCount", contentSummary.getDirectoryCount());
        json.put("fileCount", contentSummary.getFileCount());
        json.put("length", contentSummary.getLength());
        json.put("quota", contentSummary.getQuota());
        json.put("spaceConsumed", contentSummary.getSpaceConsumed());
        json.put("spaceQuota", contentSummary.getSpaceQuota());
        LinkedHashMap<String, LinkedHashMap<String, Long>> response = new LinkedHashMap<String, LinkedHashMap<String, Long>>();
        response.put("ContentSummary", json);
        return response;
    }

    private static JSONObject toJSON(String name, Object value) {
        JSONObject json = new JSONObject();
        json.put((Object)name, value);
        return json;
    }

    private static JSONObject storagePolicyToJSON(BlockStoragePolicySpi policy) {
        BlockStoragePolicy p = (BlockStoragePolicy)policy;
        JSONObject policyJson = new JSONObject();
        policyJson.put((Object)"id", (Object)p.getId());
        policyJson.put((Object)"name", (Object)p.getName());
        policyJson.put((Object)"storageTypes", (Object)FSOperations.toJsonArray(p.getStorageTypes()));
        policyJson.put((Object)"creationFallbacks", (Object)FSOperations.toJsonArray(p.getCreationFallbacks()));
        policyJson.put((Object)"replicationFallbacks", (Object)FSOperations.toJsonArray(p.getReplicationFallbacks()));
        policyJson.put((Object)"copyOnCreateFile", (Object)p.isCopyOnCreateFile());
        return policyJson;
    }

    private static JSONArray toJsonArray(StorageType[] storageTypes) {
        JSONArray jsonArray = new JSONArray();
        for (StorageType type : storageTypes) {
            jsonArray.add((Object)type.toString());
        }
        return jsonArray;
    }

    private static JSONObject storagePoliciesToJSON(Collection<? extends BlockStoragePolicySpi> storagePolicies) {
        JSONObject json = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        JSONObject policies = new JSONObject();
        if (storagePolicies != null) {
            for (BlockStoragePolicySpi blockStoragePolicySpi : storagePolicies) {
                JSONObject policyMap = FSOperations.storagePolicyToJSON(blockStoragePolicySpi);
                jsonArray.add((Object)policyMap);
            }
        }
        policies.put((Object)"BlockStoragePolicy", (Object)jsonArray);
        json.put((Object)"BlockStoragePolicies", (Object)policies);
        return json;
    }

    @InterfaceAudience.Private
    public static class FSRenameSnapshot
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String oldSnapshotName;
        private String snapshotName;

        public FSRenameSnapshot(String path, String oldSnapshotName, String snapshotName) {
            this.path = new Path(path);
            this.oldSnapshotName = oldSnapshotName;
            this.snapshotName = snapshotName;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.renameSnapshot(this.path, this.oldSnapshotName, this.snapshotName);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSDeleteSnapshot
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String snapshotName;

        public FSDeleteSnapshot(String path, String snapshotName) {
            this.path = new Path(path);
            this.snapshotName = snapshotName;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.deleteSnapshot(this.path, this.snapshotName);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSCreateSnapshot
    implements FileSystemAccess.FileSystemExecutor<String> {
        private Path path;
        private String snapshotName;

        public FSCreateSnapshot(String path, String snapshotName) {
            this.path = new Path(path);
            this.snapshotName = snapshotName;
        }

        @Override
        public String execute(FileSystem fs) throws IOException {
            Path snapshotPath = fs.createSnapshot(this.path, this.snapshotName);
            JSONObject json = FSOperations.toJSON("Path", snapshotPath.toString());
            return json.toJSONString().replaceAll("\\\\", "");
        }
    }

    @InterfaceAudience.Private
    public static class FSUnsetStoragePolicy
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;

        public FSUnsetStoragePolicy(String path) {
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.unsetStoragePolicy(this.path);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetStoragePolicy
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String policyName;

        public FSSetStoragePolicy(String path, String policyName) {
            this.path = new Path(path);
            this.policyName = policyName;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setStoragePolicy(this.path, this.policyName);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSGetStoragePolicy
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;

        public FSGetStoragePolicy(String path) {
            this.path = new Path(path);
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            BlockStoragePolicySpi storagePolicy = fs.getStoragePolicy(this.path);
            JSONObject json = new JSONObject();
            json.put((Object)"BlockStoragePolicy", (Object)FSOperations.storagePolicyToJSON(storagePolicy));
            return json;
        }
    }

    @InterfaceAudience.Private
    public static class FSGetAllStoragePolicies
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            Collection storagePolicies = fs.getAllStoragePolicies();
            return FSOperations.storagePoliciesToJSON(storagePolicies);
        }
    }

    @InterfaceAudience.Private
    public static class FSGetXAttrs
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;
        private List<String> names;
        private XAttrCodec encoding;

        public FSGetXAttrs(String path, List<String> names, XAttrCodec encoding) {
            this.path = new Path(path);
            this.names = names;
            this.encoding = encoding;
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            Map xattrs = null;
            xattrs = this.names != null && !this.names.isEmpty() ? fs.getXAttrs(this.path, this.names) : fs.getXAttrs(this.path);
            return FSOperations.xAttrsToJSON(xattrs, this.encoding);
        }
    }

    @InterfaceAudience.Private
    public static class FSListXAttrs
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSListXAttrs(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            List names = fs.listXAttrs(this.path);
            return FSOperations.xAttrNamesToJSON(names);
        }
    }

    @InterfaceAudience.Private
    public static class FSRemoveXAttr
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String name;

        public FSRemoveXAttr(String path, String name) {
            this.path = new Path(path);
            this.name = name;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.removeXAttr(this.path, this.name);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetXAttr
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String name;
        private byte[] value;
        private EnumSet<XAttrSetFlag> flag;

        public FSSetXAttr(String path, String name, String encodedValue, EnumSet<XAttrSetFlag> flag) throws IOException {
            this.path = new Path(path);
            this.name = name;
            this.value = XAttrCodec.decodeValue((String)encodedValue);
            this.flag = flag;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setXAttr(this.path, this.name, this.value, this.flag);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetTimes
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private long mTime;
        private long aTime;

        public FSSetTimes(String path, long mTime, long aTime) {
            this.path = new Path(path);
            this.mTime = mTime;
            this.aTime = aTime;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setTimes(this.path, this.mTime, this.aTime);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetReplication
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private short replication;

        public FSSetReplication(String path, short replication) {
            this.path = new Path(path);
            this.replication = replication;
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            boolean ret = fs.setReplication(this.path, this.replication);
            JSONObject json = new JSONObject();
            json.put((Object)"boolean", (Object)ret);
            return json;
        }
    }

    @InterfaceAudience.Private
    public static class FSAclStatus
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSAclStatus(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            AclStatus status = fs.getAclStatus(this.path);
            return FSOperations.aclStatusToJSON(status);
        }
    }

    @InterfaceAudience.Private
    public static class FSTrashRoot
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;

        public FSTrashRoot(String path) {
            this.path = new Path(path);
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            Path trashRoot = fs.getTrashRoot(this.path);
            JSONObject json = new JSONObject();
            json.put((Object)"Path", (Object)trashRoot.toUri().getPath());
            return json;
        }
    }

    @InterfaceAudience.Private
    public static class FSRemoveDefaultAcl
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;

        public FSRemoveDefaultAcl(String path) {
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.removeDefaultAcl(this.path);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSRemoveAclEntries
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private List<AclEntry> aclEntries;

        public FSRemoveAclEntries(String path, String aclSpec) {
            this.path = new Path(path);
            this.aclEntries = AclEntry.parseAclSpec((String)aclSpec, (boolean)false);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.removeAclEntries(this.path, this.aclEntries);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSModifyAclEntries
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private List<AclEntry> aclEntries;

        public FSModifyAclEntries(String path, String aclSpec) {
            this.path = new Path(path);
            this.aclEntries = AclEntry.parseAclSpec((String)aclSpec, (boolean)true);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.modifyAclEntries(this.path, this.aclEntries);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSRemoveAcl
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;

        public FSRemoveAcl(String path) {
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.removeAcl(this.path);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetAcl
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private List<AclEntry> aclEntries;

        public FSSetAcl(String path, String aclSpec) {
            this.path = new Path(path);
            this.aclEntries = AclEntry.parseAclSpec((String)aclSpec, (boolean)true);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setAcl(this.path, this.aclEntries);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetPermission
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private short permission;

        public FSSetPermission(String path, short permission) {
            this.path = new Path(path);
            this.permission = permission;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            FsPermission fsPermission = new FsPermission(this.permission);
            fs.setPermission(this.path, fsPermission);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSSetOwner
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private String owner;
        private String group;

        public FSSetOwner(String path, String owner, String group) {
            this.path = new Path(path);
            this.owner = owner;
            this.group = group;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.setOwner(this.path, this.owner, this.group);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSRename
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private Path toPath;

        public FSRename(String path, String toPath) {
            this.path = new Path(path);
            this.toPath = new Path(toPath);
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            boolean renamed = fs.rename(this.path, this.toPath);
            return FSOperations.toJSON("boolean", renamed);
        }
    }

    @InterfaceAudience.Private
    public static class FSOpen
    implements FileSystemAccess.FileSystemExecutor<InputStream> {
        private Path path;

        public FSOpen(String path) {
            this.path = new Path(path);
        }

        @Override
        public InputStream execute(FileSystem fs) throws IOException {
            int bufferSize = HttpFSServerWebApp.get().getConfig().getInt("httpfs.buffer.size", 4096);
            return fs.open(this.path, bufferSize);
        }
    }

    @InterfaceAudience.Private
    public static class FSMkdirs
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private short permission;

        public FSMkdirs(String path, short permission) {
            this.path = new Path(path);
            this.permission = permission;
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            FsPermission fsPermission = new FsPermission(this.permission);
            boolean mkdirs = fs.mkdirs(this.path, fsPermission);
            return FSOperations.toJSON("boolean", mkdirs);
        }
    }

    @InterfaceAudience.Private
    public static class FSListStatusBatch
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private final Path path;
        private final byte[] token;

        public FSListStatusBatch(String path, byte[] token) throws IOException {
            this.path = new Path(path);
            this.token = (byte[])token.clone();
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            WrappedFileSystem wrappedFS = new WrappedFileSystem(fs);
            FileSystem.DirectoryEntries entries = wrappedFS.listStatusBatch(this.path, this.token);
            return FSOperations.toJson(entries, wrappedFS.getFileStatus(this.path).isFile());
        }

        private static class WrappedFileSystem
        extends FilterFileSystem {
            public WrappedFileSystem(FileSystem f) {
                super(f);
            }

            public FileSystem.DirectoryEntries listStatusBatch(Path f, byte[] token) throws FileNotFoundException, IOException {
                return super.listStatusBatch(f, token);
            }
        }
    }

    @InterfaceAudience.Private
    public static class FSListStatus
    implements FileSystemAccess.FileSystemExecutor<Map>,
    PathFilter {
        private Path path;
        private PathFilter filter;

        public FSListStatus(String path, String filter) throws IOException {
            this.path = new Path(path);
            this.filter = filter == null ? this : new GlobFilter(filter);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            FileStatus[] fileStatuses = fs.listStatus(this.path, this.filter);
            return FSOperations.toJson(fileStatuses, fs.getFileStatus(this.path).isFile());
        }

        public boolean accept(Path path) {
            return true;
        }
    }

    @InterfaceAudience.Private
    public static class FSHomeDir
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            Path homeDir = fs.getHomeDirectory();
            JSONObject json = new JSONObject();
            json.put((Object)"Path", (Object)homeDir.toUri().getPath());
            return json;
        }
    }

    @InterfaceAudience.Private
    public static class FSFileStatus
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSFileStatus(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            FileStatus status = fs.getFileStatus(this.path);
            return FSOperations.toJson(status);
        }
    }

    @InterfaceAudience.Private
    public static class FSFileChecksum
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSFileChecksum(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            FileChecksum checksum = fs.getFileChecksum(this.path);
            return FSOperations.fileChecksumToJSON(checksum);
        }
    }

    @InterfaceAudience.Private
    public static class FSDelete
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private boolean recursive;

        public FSDelete(String path, boolean recursive) {
            this.path = new Path(path);
            this.recursive = recursive;
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            boolean deleted = fs.delete(this.path, this.recursive);
            return FSOperations.toJSON(StringUtils.toLowerCase((String)"boolean"), deleted);
        }
    }

    @InterfaceAudience.Private
    public static class FSCreate
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private InputStream is;
        private Path path;
        private short permission;
        private boolean override;
        private short replication;
        private long blockSize;

        public FSCreate(InputStream is, String path, short perm, boolean override, short repl, long blockSize) {
            this.is = is;
            this.path = new Path(path);
            this.permission = perm;
            this.override = override;
            this.replication = repl;
            this.blockSize = blockSize;
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            if (this.replication == -1) {
                this.replication = fs.getDefaultReplication(this.path);
            }
            if (this.blockSize == -1L) {
                this.blockSize = fs.getDefaultBlockSize(this.path);
            }
            FsPermission fsPermission = new FsPermission(this.permission);
            int bufferSize = fs.getConf().getInt("httpfs.buffer.size", 4096);
            FSDataOutputStream os = fs.create(this.path, fsPermission, this.override, bufferSize, this.replication, this.blockSize, null);
            IOUtils.copyBytes((InputStream)this.is, (OutputStream)os, (int)bufferSize, (boolean)true);
            os.close();
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSContentSummary
    implements FileSystemAccess.FileSystemExecutor<Map> {
        private Path path;

        public FSContentSummary(String path) {
            this.path = new Path(path);
        }

        @Override
        public Map execute(FileSystem fs) throws IOException {
            ContentSummary contentSummary = fs.getContentSummary(this.path);
            return FSOperations.contentSummaryToJSON(contentSummary);
        }
    }

    @InterfaceAudience.Private
    public static class FSTruncate
    implements FileSystemAccess.FileSystemExecutor<JSONObject> {
        private Path path;
        private long newLength;

        public FSTruncate(String path, long newLength) {
            this.path = new Path(path);
            this.newLength = newLength;
        }

        @Override
        public JSONObject execute(FileSystem fs) throws IOException {
            boolean result = fs.truncate(this.path, this.newLength);
            return FSOperations.toJSON(StringUtils.toLowerCase((String)"boolean"), result);
        }
    }

    @InterfaceAudience.Private
    public static class FSConcat
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private Path path;
        private Path[] sources;

        public FSConcat(String path, String[] sources) {
            this.sources = new Path[sources.length];
            for (int i = 0; i < sources.length; ++i) {
                this.sources[i] = new Path(sources[i]);
            }
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            fs.concat(this.path, this.sources);
            return null;
        }
    }

    @InterfaceAudience.Private
    public static class FSAppend
    implements FileSystemAccess.FileSystemExecutor<Void> {
        private InputStream is;
        private Path path;

        public FSAppend(InputStream is, String path) {
            this.is = is;
            this.path = new Path(path);
        }

        @Override
        public Void execute(FileSystem fs) throws IOException {
            int bufferSize = fs.getConf().getInt("httpfs.buffer.size", 4096);
            FSDataOutputStream os = fs.append(this.path, bufferSize);
            IOUtils.copyBytes((InputStream)this.is, (OutputStream)os, (int)bufferSize, (boolean)true);
            os.close();
            return null;
        }
    }
}

