/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.http.client.HttpFSUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.lib.wsrs.EnumSetParam;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator;
import org.apache.hadoop.util.HttpExceptionUtils;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@InterfaceAudience.Private
public class HttpFSFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable {
    public static final String SERVICE_NAME = "/webhdfs";
    public static final String SERVICE_VERSION = "/v1";
    public static final String SCHEME = "webhdfs";
    public static final String OP_PARAM = "op";
    public static final String DO_AS_PARAM = "doas";
    public static final String OVERWRITE_PARAM = "overwrite";
    public static final String REPLICATION_PARAM = "replication";
    public static final String BLOCKSIZE_PARAM = "blocksize";
    public static final String PERMISSION_PARAM = "permission";
    public static final String ACLSPEC_PARAM = "aclspec";
    public static final String DESTINATION_PARAM = "destination";
    public static final String RECURSIVE_PARAM = "recursive";
    public static final String SOURCES_PARAM = "sources";
    public static final String OWNER_PARAM = "owner";
    public static final String GROUP_PARAM = "group";
    public static final String MODIFICATION_TIME_PARAM = "modificationtime";
    public static final String ACCESS_TIME_PARAM = "accesstime";
    public static final String XATTR_NAME_PARAM = "xattr.name";
    public static final String XATTR_VALUE_PARAM = "xattr.value";
    public static final String XATTR_SET_FLAG_PARAM = "flag";
    public static final String XATTR_ENCODING_PARAM = "encoding";
    public static final String NEW_LENGTH_PARAM = "newlength";
    public static final String START_AFTER_PARAM = "startAfter";
    public static final String POLICY_NAME_PARAM = "storagepolicy";
    public static final String SNAPSHOT_NAME_PARAM = "snapshotname";
    public static final String OLD_SNAPSHOT_NAME_PARAM = "oldsnapshotname";
    public static final Short DEFAULT_PERMISSION = 493;
    public static final String ACLSPEC_DEFAULT = "";
    public static final String RENAME_JSON = "boolean";
    public static final String TRUNCATE_JSON = "boolean";
    public static final String DELETE_JSON = "boolean";
    public static final String MKDIRS_JSON = "boolean";
    public static final String HOME_DIR_JSON = "Path";
    public static final String TRASH_DIR_JSON = "Path";
    public static final String SET_REPLICATION_JSON = "boolean";
    public static final String UPLOAD_CONTENT_TYPE = "application/octet-stream";
    public static final String SNAPSHOT_JSON = "Path";
    public static final String FILE_STATUSES_JSON = "FileStatuses";
    public static final String FILE_STATUS_JSON = "FileStatus";
    public static final String PATH_SUFFIX_JSON = "pathSuffix";
    public static final String TYPE_JSON = "type";
    public static final String LENGTH_JSON = "length";
    public static final String OWNER_JSON = "owner";
    public static final String GROUP_JSON = "group";
    public static final String PERMISSION_JSON = "permission";
    public static final String ACCESS_TIME_JSON = "accessTime";
    public static final String MODIFICATION_TIME_JSON = "modificationTime";
    public static final String BLOCK_SIZE_JSON = "blockSize";
    public static final String REPLICATION_JSON = "replication";
    public static final String XATTRS_JSON = "XAttrs";
    public static final String XATTR_NAME_JSON = "name";
    public static final String XATTR_VALUE_JSON = "value";
    public static final String XATTRNAMES_JSON = "XAttrNames";
    public static final String FILE_CHECKSUM_JSON = "FileChecksum";
    public static final String CHECKSUM_ALGORITHM_JSON = "algorithm";
    public static final String CHECKSUM_BYTES_JSON = "bytes";
    public static final String CHECKSUM_LENGTH_JSON = "length";
    public static final String CONTENT_SUMMARY_JSON = "ContentSummary";
    public static final String CONTENT_SUMMARY_DIRECTORY_COUNT_JSON = "directoryCount";
    public static final String CONTENT_SUMMARY_FILE_COUNT_JSON = "fileCount";
    public static final String CONTENT_SUMMARY_LENGTH_JSON = "length";
    public static final String CONTENT_SUMMARY_QUOTA_JSON = "quota";
    public static final String CONTENT_SUMMARY_SPACE_CONSUMED_JSON = "spaceConsumed";
    public static final String CONTENT_SUMMARY_SPACE_QUOTA_JSON = "spaceQuota";
    public static final String ACL_STATUS_JSON = "AclStatus";
    public static final String ACL_STICKY_BIT_JSON = "stickyBit";
    public static final String ACL_ENTRIES_JSON = "entries";
    public static final String ACL_BIT_JSON = "aclBit";
    public static final String ENC_BIT_JSON = "encBit";
    public static final String EC_BIT_JSON = "ecBit";
    public static final String DIRECTORY_LISTING_JSON = "DirectoryListing";
    public static final String PARTIAL_LISTING_JSON = "partialListing";
    public static final String REMAINING_ENTRIES_JSON = "remainingEntries";
    public static final String STORAGE_POLICIES_JSON = "BlockStoragePolicies";
    public static final String STORAGE_POLICY_JSON = "BlockStoragePolicy";
    public static final int HTTP_TEMPORARY_REDIRECT = 307;
    private static final String HTTP_GET = "GET";
    private static final String HTTP_PUT = "PUT";
    private static final String HTTP_POST = "POST";
    private static final String HTTP_DELETE = "DELETE";
    private DelegationTokenAuthenticatedURL authURL;
    private DelegationTokenAuthenticatedURL.Token authToken = new DelegationTokenAuthenticatedURL.Token();
    private URI uri;
    private Path workingDir;
    private UserGroupInformation realUser;

    private HttpURLConnection getConnection(String method, Map<String, String> params, Path path, boolean makeQualified) throws IOException {
        return this.getConnection(method, params, null, path, makeQualified);
    }

    private HttpURLConnection getConnection(final String method, Map<String, String> params, Map<String, List<String>> multiValuedParams, Path path, boolean makeQualified) throws IOException {
        if (makeQualified) {
            path = this.makeQualified(path);
        }
        final URL url = HttpFSUtils.createURL(path, params, multiValuedParams);
        try {
            return (HttpURLConnection)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<HttpURLConnection>(){

                @Override
                public HttpURLConnection run() throws Exception {
                    return HttpFSFileSystem.this.getConnection(url, method);
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    private HttpURLConnection getConnection(URL url, String method) throws IOException {
        try {
            HttpURLConnection conn = this.authURL.openConnection(url, this.authToken);
            conn.setRequestMethod(method);
            if (method.equals(HTTP_POST) || method.equals(HTTP_PUT)) {
                conn.setDoOutput(true);
            }
            return conn;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.realUser = ugi.getRealUser();
        if (this.realUser == null) {
            this.realUser = UserGroupInformation.getLoginUser();
        }
        super.initialize(name, conf);
        try {
            this.uri = new URI(name.getScheme() + "://" + name.getAuthority());
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        Class klass = this.getConf().getClass("httpfs.authenticator.class", KerberosDelegationTokenAuthenticator.class, DelegationTokenAuthenticator.class);
        DelegationTokenAuthenticator authenticator = (DelegationTokenAuthenticator)ReflectionUtils.newInstance((Class)klass, (Configuration)this.getConf());
        this.authURL = new DelegationTokenAuthenticatedURL(authenticator);
    }

    public String getScheme() {
        return SCHEME;
    }

    public URI getUri() {
        return this.uri;
    }

    protected int getDefaultPort() {
        return 9870;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.OPEN.toString());
        HttpURLConnection conn = this.getConnection(Operation.OPEN.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        return new FSDataInputStream((InputStream)new HttpFSDataInputStream(conn.getInputStream(), bufferSize));
    }

    public static String permissionToString(FsPermission p) {
        return Integer.toString(p == null ? DEFAULT_PERMISSION.shortValue() : p.toShort(), 8);
    }

    private FSDataOutputStream uploadData(String method, Path f, Map<String, String> params, int bufferSize, int expectedStatus) throws IOException {
        HttpURLConnection conn = this.getConnection(method, params, f, true);
        conn.setInstanceFollowRedirects(false);
        boolean exceptionAlreadyHandled = false;
        try {
            if (conn.getResponseCode() == 307) {
                exceptionAlreadyHandled = true;
                String location = conn.getHeaderField("Location");
                if (location != null) {
                    conn = this.getConnection(new URL(location), method);
                    conn.setRequestProperty("Content-Type", UPLOAD_CONTENT_TYPE);
                    try {
                        BufferedOutputStream os = new BufferedOutputStream(conn.getOutputStream(), bufferSize);
                        return new HttpFSDataOutputStream(conn, os, expectedStatus, this.statistics);
                    }
                    catch (IOException ex) {
                        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)expectedStatus);
                        throw ex;
                    }
                }
                HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)307);
                throw new IOException("Missing HTTP 'Location' header for [" + conn.getURL() + "]");
            }
            throw new IOException(MessageFormat.format("Expected HTTP status was [307], received [{0}]", conn.getResponseCode()));
        }
        catch (IOException ex) {
            if (exceptionAlreadyHandled) {
                throw ex;
            }
            HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)307);
            throw ex;
        }
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.CREATE.toString());
        params.put(OVERWRITE_PARAM, Boolean.toString(overwrite));
        params.put("replication", Short.toString(replication));
        params.put(BLOCKSIZE_PARAM, Long.toString(blockSize));
        params.put("permission", HttpFSFileSystem.permissionToString(permission));
        return this.uploadData(Operation.CREATE.getMethod(), f, params, bufferSize, 201);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.APPEND.toString());
        return this.uploadData(Operation.APPEND.getMethod(), f, params, bufferSize, 200);
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.TRUNCATE.toString());
        params.put(NEW_LENGTH_PARAM, Long.toString(newLength));
        HttpURLConnection conn = this.getConnection(Operation.TRUNCATE.getMethod(), params, f, true);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return (Boolean)json.get((Object)"boolean");
    }

    public void concat(Path f, Path[] psrcs) throws IOException {
        ArrayList<String> strPaths = new ArrayList<String>(psrcs.length);
        for (Path psrc : psrcs) {
            strPaths.add(psrc.toUri().getPath());
        }
        String srcs = StringUtils.join((CharSequence)",", strPaths);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.CONCAT.toString());
        params.put(SOURCES_PARAM, srcs);
        HttpURLConnection conn = this.getConnection(Operation.CONCAT.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.RENAME.toString());
        params.put(DESTINATION_PARAM, dst.toString());
        HttpURLConnection conn = this.getConnection(Operation.RENAME.getMethod(), params, src, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return (Boolean)json.get((Object)"boolean");
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.delete(f, false);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.DELETE.toString());
        params.put(RECURSIVE_PARAM, Boolean.toString(recursive));
        HttpURLConnection conn = this.getConnection(Operation.DELETE.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return (Boolean)json.get((Object)"boolean");
    }

    private FileStatus[] toFileStatuses(JSONObject json, Path f) {
        json = (JSONObject)json.get((Object)FILE_STATUSES_JSON);
        JSONArray jsonArray = (JSONArray)json.get((Object)FILE_STATUS_JSON);
        FileStatus[] array = new FileStatus[jsonArray.size()];
        f = this.makeQualified(f);
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = this.createFileStatus(f, (JSONObject)jsonArray.get(i));
        }
        return array;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.LISTSTATUS.toString());
        HttpURLConnection conn = this.getConnection(Operation.LISTSTATUS.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return this.toFileStatuses(json, f);
    }

    public FileSystem.DirectoryEntries listStatusBatch(Path f, byte[] token) throws FileNotFoundException, IOException {
        long remainingEntries;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.LISTSTATUS_BATCH.toString());
        if (token != null) {
            params.put(START_AFTER_PARAM, new String(token, Charsets.UTF_8));
        }
        HttpURLConnection conn = this.getConnection(Operation.LISTSTATUS_BATCH.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        JSONObject listing = (JSONObject)json.get((Object)DIRECTORY_LISTING_JSON);
        FileStatus[] statuses = this.toFileStatuses((JSONObject)listing.get((Object)PARTIAL_LISTING_JSON), f);
        byte[] newToken = null;
        if (statuses.length > 0) {
            newToken = statuses[statuses.length - 1].getPath().getName().toString().getBytes(Charsets.UTF_8);
        }
        boolean hasMore = (remainingEntries = ((Long)listing.get((Object)REMAINING_ENTRIES_JSON)).longValue()) > 0L;
        return new FileSystem.DirectoryEntries(statuses, newToken, hasMore);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        if (this.workingDir == null) {
            this.workingDir = this.getHomeDirectory();
        }
        return this.workingDir;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.MKDIRS.toString());
        params.put("permission", HttpFSFileSystem.permissionToString(permission));
        HttpURLConnection conn = this.getConnection(Operation.MKDIRS.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return (Boolean)json.get((Object)"boolean");
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETFILESTATUS.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETFILESTATUS.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        json = (JSONObject)json.get((Object)FILE_STATUS_JSON);
        f = this.makeQualified(f);
        return this.createFileStatus(f, json);
    }

    public Path getHomeDirectory() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETHOMEDIRECTORY.toString());
        try {
            HttpURLConnection conn = this.getConnection(Operation.GETHOMEDIRECTORY.getMethod(), params, new Path(this.getUri().toString(), "/"), false);
            HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
            JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
            return new Path((String)json.get((Object)"Path"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Path getTrashRoot(Path fullPath) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETTRASHROOT.toString());
        try {
            HttpURLConnection conn = this.getConnection(Operation.GETTRASHROOT.getMethod(), params, fullPath, true);
            HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
            JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
            return new Path((String)json.get((Object)"Path"));
        }
        catch (IOException ex) {
            LOG.warn((Object)("Cannot find trash root of " + fullPath), (Throwable)ex);
            return super.getTrashRoot(fullPath);
        }
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.SETOWNER.toString());
        params.put("owner", username);
        params.put("group", groupname);
        HttpURLConnection conn = this.getConnection(Operation.SETOWNER.getMethod(), params, p, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.SETPERMISSION.toString());
        params.put("permission", HttpFSFileSystem.permissionToString(permission));
        HttpURLConnection conn = this.getConnection(Operation.SETPERMISSION.getMethod(), params, p, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.SETTIMES.toString());
        params.put(MODIFICATION_TIME_PARAM, Long.toString(mtime));
        params.put(ACCESS_TIME_PARAM, Long.toString(atime));
        HttpURLConnection conn = this.getConnection(Operation.SETTIMES.getMethod(), params, p, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.SETREPLICATION.toString());
        params.put("replication", Short.toString(replication));
        HttpURLConnection conn = this.getConnection(Operation.SETREPLICATION.getMethod(), params, src, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return (Boolean)json.get((Object)"boolean");
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.MODIFYACLENTRIES.toString());
        params.put(ACLSPEC_PARAM, AclEntry.aclSpecToString(aclSpec));
        HttpURLConnection conn = this.getConnection(Operation.MODIFYACLENTRIES.getMethod(), params, path, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.REMOVEACLENTRIES.toString());
        params.put(ACLSPEC_PARAM, AclEntry.aclSpecToString(aclSpec));
        HttpURLConnection conn = this.getConnection(Operation.REMOVEACLENTRIES.getMethod(), params, path, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.REMOVEDEFAULTACL.toString());
        HttpURLConnection conn = this.getConnection(Operation.REMOVEDEFAULTACL.getMethod(), params, path, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void removeAcl(Path path) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.REMOVEACL.toString());
        HttpURLConnection conn = this.getConnection(Operation.REMOVEACL.getMethod(), params, path, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.SETACL.toString());
        params.put(ACLSPEC_PARAM, AclEntry.aclSpecToString(aclSpec));
        HttpURLConnection conn = this.getConnection(Operation.SETACL.getMethod(), params, path, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETACLSTATUS.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETACLSTATUS.getMethod(), params, path, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        json = (JSONObject)json.get((Object)ACL_STATUS_JSON);
        return this.createAclStatus(json);
    }

    static FsPermission toFsPermission(JSONObject json) {
        String s = (String)json.get((Object)"permission");
        return new FsPermission(Short.parseShort(s, 8));
    }

    private FileStatus createFileStatus(Path parent, JSONObject json) {
        boolean ecBit;
        String pathSuffix = (String)json.get((Object)PATH_SUFFIX_JSON);
        Path path = pathSuffix.equals(ACLSPEC_DEFAULT) ? parent : new Path(parent, pathSuffix);
        FILE_TYPE type = FILE_TYPE.valueOf((String)json.get((Object)TYPE_JSON));
        long len = (Long)json.get((Object)"length");
        String owner = (String)json.get((Object)"owner");
        String group = (String)json.get((Object)"group");
        FsPermission permission = HttpFSFileSystem.toFsPermission(json);
        long aTime = (Long)json.get((Object)ACCESS_TIME_JSON);
        long mTime = (Long)json.get((Object)MODIFICATION_TIME_JSON);
        long blockSize = (Long)json.get((Object)BLOCK_SIZE_JSON);
        short replication = ((Long)json.get((Object)"replication")).shortValue();
        Boolean aclBit = (Boolean)json.get((Object)ACL_BIT_JSON);
        Boolean encBit = (Boolean)json.get((Object)ENC_BIT_JSON);
        Boolean erasureBit = (Boolean)json.get((Object)EC_BIT_JSON);
        boolean aBit = aclBit != null ? aclBit : false;
        boolean eBit = encBit != null ? encBit : false;
        boolean bl = ecBit = erasureBit != null ? erasureBit : false;
        if (aBit || eBit || ecBit) {
            FsPermissionExtension deprecatedPerm = new FsPermissionExtension(permission, aBit, eBit, ecBit);
            return new FileStatus(len, FILE_TYPE.DIRECTORY == type, (int)replication, blockSize, mTime, aTime, (FsPermission)deprecatedPerm, owner, group, null, path, aBit, eBit, ecBit);
        }
        return new FileStatus(len, FILE_TYPE.DIRECTORY == type, (int)replication, blockSize, mTime, aTime, permission, owner, group, path);
    }

    private AclStatus createAclStatus(JSONObject json) {
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder().owner((String)json.get((Object)"owner")).group((String)json.get((Object)"group")).stickyBit(((Boolean)json.get((Object)ACL_STICKY_BIT_JSON)).booleanValue());
        JSONArray entries = (JSONArray)json.get((Object)ACL_ENTRIES_JSON);
        for (Object e : entries) {
            aclStatusBuilder.addEntry(AclEntry.parseAclEntry((String)e.toString(), (boolean)true));
        }
        return aclStatusBuilder.build();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETCONTENTSUMMARY.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETCONTENTSUMMARY.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)((JSONObject)HttpFSUtils.jsonParse(conn)).get((Object)CONTENT_SUMMARY_JSON);
        return new ContentSummary.Builder().length(((Long)json.get((Object)"length")).longValue()).fileCount(((Long)json.get((Object)CONTENT_SUMMARY_FILE_COUNT_JSON)).longValue()).directoryCount(((Long)json.get((Object)CONTENT_SUMMARY_DIRECTORY_COUNT_JSON)).longValue()).quota(((Long)json.get((Object)CONTENT_SUMMARY_QUOTA_JSON)).longValue()).spaceConsumed(((Long)json.get((Object)CONTENT_SUMMARY_SPACE_CONSUMED_JSON)).longValue()).spaceQuota(((Long)json.get((Object)CONTENT_SUMMARY_SPACE_QUOTA_JSON)).longValue()).build();
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETFILECHECKSUM.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETFILECHECKSUM.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        final JSONObject json = (JSONObject)((JSONObject)HttpFSUtils.jsonParse(conn)).get((Object)FILE_CHECKSUM_JSON);
        return new FileChecksum(){

            public String getAlgorithmName() {
                return (String)json.get((Object)HttpFSFileSystem.CHECKSUM_ALGORITHM_JSON);
            }

            public int getLength() {
                return ((Long)json.get((Object)"length")).intValue();
            }

            public byte[] getBytes() {
                return StringUtils.hexStringToByte((String)((String)json.get((Object)HttpFSFileSystem.CHECKSUM_BYTES_JSON)));
            }

            public void write(DataOutput out) throws IOException {
                throw new UnsupportedOperationException();
            }

            public void readFields(DataInput in) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Token<?> getDelegationToken(final String renewer) throws IOException {
        try {
            return (Token)UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Token<?>>(){

                @Override
                public Token<?> run() throws Exception {
                    return HttpFSFileSystem.this.authURL.getDelegationToken(HttpFSFileSystem.this.uri.toURL(), HttpFSFileSystem.this.authToken, renewer);
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    public long renewDelegationToken(Token<?> token) throws IOException {
        try {
            return (Long)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws Exception {
                    return HttpFSFileSystem.this.authURL.renewDelegationToken(HttpFSFileSystem.this.uri.toURL(), HttpFSFileSystem.this.authToken);
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    public void cancelDelegationToken(Token<?> token) throws IOException {
        this.authURL.cancelDelegationToken(this.uri.toURL(), this.authToken);
    }

    public Token<?> getRenewToken() {
        return null;
    }

    public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
    }

    public void setXAttr(Path f, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.SETXATTR.toString());
        params.put(XATTR_NAME_PARAM, name);
        if (value != null) {
            params.put(XATTR_VALUE_PARAM, XAttrCodec.encodeValue((byte[])value, (XAttrCodec)XAttrCodec.HEX));
        }
        params.put(XATTR_SET_FLAG_PARAM, EnumSetParam.toString(flag));
        HttpURLConnection conn = this.getConnection(Operation.SETXATTR.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public byte[] getXAttr(Path f, String name) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETXATTRS.toString());
        params.put(XATTR_NAME_PARAM, name);
        HttpURLConnection conn = this.getConnection(Operation.GETXATTRS.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        Map<String, byte[]> xAttrs = this.createXAttrMap((JSONArray)json.get((Object)XATTRS_JSON));
        return xAttrs != null ? xAttrs.get(name) : null;
    }

    private Map<String, byte[]> createXAttrMap(JSONArray jsonArray) throws IOException {
        HashMap xAttrs = Maps.newHashMap();
        for (Object obj : jsonArray) {
            JSONObject jsonObj = (JSONObject)obj;
            String name = (String)jsonObj.get((Object)XATTR_NAME_JSON);
            byte[] value = XAttrCodec.decodeValue((String)((String)jsonObj.get((Object)XATTR_VALUE_JSON)));
            xAttrs.put(name, value);
        }
        return xAttrs;
    }

    private List<String> createXAttrNames(String xattrNamesStr) throws IOException {
        JSONParser parser = new JSONParser();
        try {
            JSONArray jsonArray = (JSONArray)parser.parse(xattrNamesStr);
            ArrayList names = Lists.newArrayListWithCapacity((int)jsonArray.size());
            for (Object name : jsonArray) {
                names.add((String)name);
            }
            return names;
        }
        catch (ParseException e) {
            throw new IOException("JSON parser error, " + e.getMessage(), e);
        }
    }

    public Map<String, byte[]> getXAttrs(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETXATTRS.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETXATTRS.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return this.createXAttrMap((JSONArray)json.get((Object)XATTRS_JSON));
    }

    public Map<String, byte[]> getXAttrs(Path f, List<String> names) throws IOException {
        Preconditions.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"XAttr names cannot be null or empty.");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETXATTRS.toString());
        HashMap multiValuedParams = Maps.newHashMap();
        multiValuedParams.put(XATTR_NAME_PARAM, names);
        HttpURLConnection conn = this.getConnection(Operation.GETXATTRS.getMethod(), params, multiValuedParams, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return this.createXAttrMap((JSONArray)json.get((Object)XATTRS_JSON));
    }

    public List<String> listXAttrs(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.LISTXATTRS.toString());
        HttpURLConnection conn = this.getConnection(Operation.LISTXATTRS.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return this.createXAttrNames((String)json.get((Object)XATTRNAMES_JSON));
    }

    public void removeXAttr(Path f, String name) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.REMOVEXATTR.toString());
        params.put(XATTR_NAME_PARAM, name);
        HttpURLConnection conn = this.getConnection(Operation.REMOVEXATTR.getMethod(), params, f, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public Collection<BlockStoragePolicy> getAllStoragePolicies() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETALLSTORAGEPOLICY.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETALLSTORAGEPOLICY.getMethod(), params, new Path(this.getUri().toString(), "/"), false);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return this.createStoragePolicies((JSONObject)json.get((Object)STORAGE_POLICIES_JSON));
    }

    private Collection<BlockStoragePolicy> createStoragePolicies(JSONObject map) throws IOException {
        JSONArray jsonArray = (JSONArray)map.get((Object)STORAGE_POLICY_JSON);
        BlockStoragePolicy[] policies = new BlockStoragePolicy[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            policies[i] = this.createStoragePolicy((JSONObject)jsonArray.get(i));
        }
        return Arrays.asList(policies);
    }

    public BlockStoragePolicy getStoragePolicy(Path src) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.GETSTORAGEPOLICY.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETSTORAGEPOLICY.getMethod(), params, src, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return this.createStoragePolicy((JSONObject)json.get((Object)STORAGE_POLICY_JSON));
    }

    private BlockStoragePolicy createStoragePolicy(JSONObject policyJson) throws IOException {
        byte id = ((Number)policyJson.get((Object)"id")).byteValue();
        String name = (String)policyJson.get((Object)XATTR_NAME_JSON);
        StorageType[] storageTypes = this.toStorageTypes((JSONArray)policyJson.get((Object)"storageTypes"));
        StorageType[] creationFallbacks = this.toStorageTypes((JSONArray)policyJson.get((Object)"creationFallbacks"));
        StorageType[] replicationFallbacks = this.toStorageTypes((JSONArray)policyJson.get((Object)"replicationFallbacks"));
        Boolean copyOnCreateFile = (Boolean)policyJson.get((Object)"copyOnCreateFile");
        return new BlockStoragePolicy(id, name, storageTypes, creationFallbacks, replicationFallbacks, copyOnCreateFile.booleanValue());
    }

    private StorageType[] toStorageTypes(JSONArray array) throws IOException {
        if (array == null) {
            return null;
        }
        ArrayList<StorageType> storageTypes = new ArrayList<StorageType>(array.size());
        for (Object name : array) {
            storageTypes.add(StorageType.parseStorageType((String)((String)name)));
        }
        return storageTypes.toArray(new StorageType[storageTypes.size()]);
    }

    public void setStoragePolicy(Path src, String policyName) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.SETSTORAGEPOLICY.toString());
        params.put(POLICY_NAME_PARAM, policyName);
        HttpURLConnection conn = this.getConnection(Operation.SETSTORAGEPOLICY.getMethod(), params, src, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void unsetStoragePolicy(Path src) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.UNSETSTORAGEPOLICY.toString());
        HttpURLConnection conn = this.getConnection(Operation.UNSETSTORAGEPOLICY.getMethod(), params, src, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public final Path createSnapshot(Path path, String snapshotName) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.CREATESNAPSHOT.toString());
        if (snapshotName != null) {
            params.put(SNAPSHOT_NAME_PARAM, snapshotName);
        }
        HttpURLConnection conn = this.getConnection(Operation.CREATESNAPSHOT.getMethod(), params, path, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse(conn);
        return new Path((String)json.get((Object)"Path"));
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.RENAMESNAPSHOT.toString());
        params.put(SNAPSHOT_NAME_PARAM, snapshotNewName);
        params.put(OLD_SNAPSHOT_NAME_PARAM, snapshotOldName);
        HttpURLConnection conn = this.getConnection(Operation.RENAMESNAPSHOT.getMethod(), params, path, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, Operation.DELETESNAPSHOT.toString());
        params.put(SNAPSHOT_NAME_PARAM, snapshotName);
        HttpURLConnection conn = this.getConnection(Operation.DELETESNAPSHOT.getMethod(), params, path, true);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    private static class HttpFSDataOutputStream
    extends FSDataOutputStream {
        private HttpURLConnection conn;
        private int closeStatus;

        public HttpFSDataOutputStream(HttpURLConnection conn, OutputStream out, int closeStatus, FileSystem.Statistics stats) throws IOException {
            super(out, stats);
            this.conn = conn;
            this.closeStatus = closeStatus;
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                HttpExceptionUtils.validateResponse((HttpURLConnection)this.conn, (int)this.closeStatus);
            }
        }
    }

    private static class HttpFSDataInputStream
    extends FilterInputStream
    implements Seekable,
    PositionedReadable {
        protected HttpFSDataInputStream(InputStream in, int bufferSize) {
            super(new BufferedInputStream(in, bufferSize));
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seek(long pos) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getPos() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    @InterfaceAudience.Private
    public static enum Operation {
        OPEN("GET"),
        GETFILESTATUS("GET"),
        LISTSTATUS("GET"),
        GETHOMEDIRECTORY("GET"),
        GETCONTENTSUMMARY("GET"),
        GETFILECHECKSUM("GET"),
        GETFILEBLOCKLOCATIONS("GET"),
        INSTRUMENTATION("GET"),
        GETACLSTATUS("GET"),
        GETTRASHROOT("GET"),
        APPEND("POST"),
        CONCAT("POST"),
        TRUNCATE("POST"),
        CREATE("PUT"),
        MKDIRS("PUT"),
        RENAME("PUT"),
        SETOWNER("PUT"),
        SETPERMISSION("PUT"),
        SETREPLICATION("PUT"),
        SETTIMES("PUT"),
        MODIFYACLENTRIES("PUT"),
        REMOVEACLENTRIES("PUT"),
        REMOVEDEFAULTACL("PUT"),
        REMOVEACL("PUT"),
        SETACL("PUT"),
        DELETE("DELETE"),
        SETXATTR("PUT"),
        GETXATTRS("GET"),
        REMOVEXATTR("PUT"),
        LISTXATTRS("GET"),
        LISTSTATUS_BATCH("GET"),
        GETALLSTORAGEPOLICY("GET"),
        GETSTORAGEPOLICY("GET"),
        SETSTORAGEPOLICY("PUT"),
        UNSETSTORAGEPOLICY("POST"),
        CREATESNAPSHOT("PUT"),
        DELETESNAPSHOT("DELETE"),
        RENAMESNAPSHOT("PUT");

        private String httpMethod;

        private Operation(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public String getMethod() {
            return this.httpMethod;
        }
    }

    public static enum FILE_TYPE {
        FILE,
        DIRECTORY,
        SYMLINK;


        public static FILE_TYPE getType(FileStatus fileStatus) {
            if (fileStatus.isFile()) {
                return FILE;
            }
            if (fileStatus.isDirectory()) {
                return DIRECTORY;
            }
            if (fileStatus.isSymlink()) {
                return SYMLINK;
            }
            throw new IllegalArgumentException("Could not determine filetype for: " + fileStatus.getPath());
        }
    }
}

