/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.HadoopUsersConfTestHelper;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestJetty;
import org.apache.hadoop.test.TestJettyHelper;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

public class TestHttpFSServerNoACLs
extends HTestCase {
    private MiniDFSCluster miniDfs;
    private Configuration nnConf;

    private void startMiniDFS() throws Exception {
        File testDirRoot = TestDirHelper.getTestDir();
        if (System.getProperty("hadoop.log.dir") == null) {
            System.setProperty("hadoop.log.dir", new File(testDirRoot, "hadoop-log").getAbsolutePath());
        }
        if (System.getProperty("test.build.data") == null) {
            System.setProperty("test.build.data", new File(testDirRoot, "hadoop-data").getAbsolutePath());
        }
        Configuration conf = HadoopUsersConfTestHelper.getBaseConf();
        HadoopUsersConfTestHelper.addUserConf((Configuration)conf);
        conf.set("fs.hdfs.impl.disable.cache", "true");
        conf.set("dfs.block.access.token.enable", "false");
        conf.set("dfs.permissions", "true");
        conf.set("hadoop.security.authentication", "simple");
        conf.setBoolean("dfs.namenode.acls.enabled", false);
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        builder.numDataNodes(2);
        this.miniDfs = builder.build();
        this.nnConf = this.miniDfs.getConfiguration(0);
    }

    private void createHttpFSServer() throws Exception {
        File homeDir = TestDirHelper.getTestDir();
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        HttpFSServerWebApp.setHomeDirForCurrentThread((String)homeDir.getAbsolutePath());
        File secretFile = new File(new File(homeDir, "conf"), "secret");
        FileWriter w = new FileWriter(secretFile);
        w.write("secret");
        ((Writer)w).close();
        File hadoopConfDir = new File(new File(homeDir, "conf"), "hadoop-conf");
        if (!hadoopConfDir.mkdirs()) {
            throw new IOException();
        }
        String fsDefaultName = this.nnConf.get("fs.defaultFS");
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", fsDefaultName);
        conf.setBoolean("dfs.namenode.acls.enabled", false);
        File hdfsSite = new File(hadoopConfDir, "hdfs-site.xml");
        FileOutputStream os = new FileOutputStream(hdfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        conf = new Configuration(false);
        conf.set("httpfs.hadoop.config.dir", hadoopConfDir.toString());
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".groups", HadoopUsersConfTestHelper.getHadoopProxyUserGroups());
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".hosts", HadoopUsersConfTestHelper.getHadoopProxyUserHosts());
        conf.set("httpfs.authentication.signature.secret.file", secretFile.getAbsolutePath());
        File httpfsSite = new File(new File(homeDir, "conf"), "httpfs-site.xml");
        os = new FileOutputStream(httpfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("webapp");
        if (url == null) {
            throw new IOException();
        }
        WebAppContext context = new WebAppContext(url.getPath(), "/webhdfs");
        Server server = TestJettyHelper.getJettyServer();
        server.addHandler((Handler)context);
        server.start();
    }

    private void getStatus(String filename, String command, boolean expectOK) throws Exception {
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        if (filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        String pathOps = MessageFormat.format("/webhdfs/v1/{0}?user.name={1}&op={2}", filename, user, command);
        URL url = new URL(TestJettyHelper.getJettyURL(), pathOps);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        int resp = conn.getResponseCode();
        if (expectOK) {
            Assert.assertEquals((long)200L, (long)resp);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String res = reader.readLine();
            Assert.assertTrue((!res.contains("aclBit") ? 1 : 0) != 0);
            Assert.assertTrue((boolean)res.contains("owner"));
        } else {
            Assert.assertEquals((long)500L, (long)resp);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            String res = reader.readLine();
            Assert.assertTrue((boolean)res.contains("AclException"));
            Assert.assertTrue((boolean)res.contains("Support for ACLs has been disabled"));
        }
    }

    private void putCmd(String filename, String command, String params, boolean expectOK) throws Exception {
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        if (filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        String pathOps = MessageFormat.format("/webhdfs/v1/{0}?user.name={1}{2}{3}&op={4}", filename, user, params == null ? "" : "&", params == null ? "" : params, command);
        URL url = new URL(TestJettyHelper.getJettyURL(), pathOps);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        conn.connect();
        int resp = conn.getResponseCode();
        if (expectOK) {
            Assert.assertEquals((long)200L, (long)resp);
        } else {
            Assert.assertEquals((long)500L, (long)resp);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            String err = reader.readLine();
            Assert.assertTrue((boolean)err.contains("AclException"));
            Assert.assertTrue((boolean)err.contains("Support for ACLs has been disabled"));
        }
    }

    @Test
    @TestDir
    @TestJetty
    public void testWithNoAcls() throws Exception {
        String aclUser1 = "user:foo:rw-";
        String aclUser2 = "user:bar:r--";
        String aclGroup1 = "group::r--";
        String aclSpec = "aclspec=user::rwx,user:foo:rw-,group::r--,other::---";
        String modAclSpec = "aclspec=user:bar:r--";
        String remAclSpec = "aclspec=user:foo:rw-";
        String defUser1 = "default:user:glarch:r-x";
        String defSpec1 = "aclspec=default:user:glarch:r-x";
        String dir = "/noACLs";
        String path = "/noACLs/foo";
        this.startMiniDFS();
        this.createHttpFSServer();
        FileSystem fs = FileSystem.get((Configuration)this.nnConf);
        fs.mkdirs(new Path("/noACLs"));
        FSDataOutputStream os = fs.create(new Path("/noACLs/foo"));
        os.write(1);
        os.close();
        this.getStatus("/noACLs/foo", "GETFILESTATUS", true);
        this.getStatus("/noACLs", "LISTSTATUS", true);
        this.getStatus("/noACLs/foo", "GETACLSTATUS", false);
        this.putCmd("/noACLs/foo", "SETACL", "aclspec=user::rwx,user:foo:rw-,group::r--,other::---", false);
        this.putCmd("/noACLs/foo", "MODIFYACLENTRIES", "aclspec=user:bar:r--", false);
        this.putCmd("/noACLs/foo", "REMOVEACLENTRIES", "aclspec=user:foo:rw-", false);
        this.putCmd("/noACLs/foo", "REMOVEACL", null, false);
        this.putCmd("/noACLs", "SETACL", "aclspec=default:user:glarch:r-x", false);
        this.putCmd("/noACLs", "REMOVEDEFAULTACL", null, false);
        this.miniDfs.shutdown();
    }
}

