/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class HttpFSUtils {
    public static final String SERVICE_NAME = "/webhdfs";
    public static final String SERVICE_VERSION = "/v1";
    private static final String SERVICE_PATH = "/webhdfs/v1";

    static URL createURL(Path path, Map<String, String> params) throws IOException {
        return HttpFSUtils.createURL((Path)path, params, null);
    }

    static URL createURL(Path path, Map<String, String> params, Map<String, List<String>> multiValuedParams) throws IOException {
        String realScheme;
        URI uri = path.toUri();
        if (uri.getScheme().equalsIgnoreCase("webhdfs")) {
            realScheme = "http";
        } else if (uri.getScheme().equalsIgnoreCase("swebhdfs")) {
            realScheme = "https";
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Invalid scheme [{0}] it should be 'webhdfs' or 'swebhdfs'", uri));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(realScheme).append("://").append(uri.getAuthority()).append("/webhdfs/v1").append(uri.getPath());
        String separator = "?";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(separator).append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF8"));
            separator = "&";
        }
        if (multiValuedParams != null) {
            for (Map.Entry<String, Object> entry : multiValuedParams.entrySet()) {
                String name = URLEncoder.encode(entry.getKey(), "UTF8");
                List values = (List)entry.getValue();
                for (String value : values) {
                    sb.append(separator).append(name).append("=").append(URLEncoder.encode(value, "UTF8"));
                    separator = "&";
                }
            }
        }
        return new URL(sb.toString());
    }

    static Object jsonParse(HttpURLConnection conn) throws IOException {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse((Reader)new InputStreamReader(conn.getInputStream()));
        }
        catch (ParseException ex) {
            throw new IOException("JSON parser error, " + ex.getMessage(), ex);
        }
    }
}

