/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.security.SslSocketConnector;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestJettyHelper
implements MethodRule {
    private boolean ssl;
    private String keyStoreType;
    private String keyStore;
    private String keyStorePassword;
    private Server server;
    private static ThreadLocal<TestJettyHelper> TEST_JETTY_TL = new InheritableThreadLocal();

    public TestJettyHelper() {
        this.ssl = false;
    }

    public TestJettyHelper(String keyStoreType, String keyStore, String keyStorePassword) {
        this.ssl = true;
        this.keyStoreType = keyStoreType;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
    }

    public Statement apply(Statement statement, FrameworkMethod frameworkMethod, Object o) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Server createJettyServer() {
        try {
            InetAddress localhost = InetAddress.getByName("localhost");
            String host = "localhost";
            ServerSocket ss = new ServerSocket(0, 50, localhost);
            int port = ss.getLocalPort();
            ss.close();
            Server server = new Server(0);
            if (!this.ssl) {
                server.getConnectors()[0].setHost(host);
                server.getConnectors()[0].setPort(port);
            } else {
                SslSocketConnector c = new SslSocketConnector();
                c.setHost(host);
                c.setPort(port);
                c.setNeedClientAuth(false);
                c.setKeystore(this.keyStore);
                c.setKeystoreType(this.keyStoreType);
                c.setKeyPassword(this.keyStorePassword);
                server.setConnectors(new Connector[]{c});
            }
            return server;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not stop embedded servlet container, " + ex.getMessage(), ex);
        }
    }

    public static InetSocketAddress getAuthority() {
        Server server = TestJettyHelper.getJettyServer();
        try {
            InetAddress add = InetAddress.getByName(server.getConnectors()[0].getHost());
            int port = server.getConnectors()[0].getPort();
            return new InetSocketAddress(add, port);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Server getJettyServer() {
        TestJettyHelper helper = (TestJettyHelper)TEST_JETTY_TL.get();
        if (helper == null || helper.server == null) {
            throw new IllegalStateException("This test does not use @TestJetty");
        }
        return helper.server;
    }

    public static URL getJettyURL() {
        TestJettyHelper helper = (TestJettyHelper)TEST_JETTY_TL.get();
        if (helper == null || helper.server == null) {
            throw new IllegalStateException("This test does not use @TestJetty");
        }
        try {
            String scheme = helper.ssl ? "https" : "http";
            return new URL(scheme + "://" + helper.server.getConnectors()[0].getHost() + ":" + helper.server.getConnectors()[0].getPort());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("It should never happen, " + ex.getMessage(), ex);
        }
    }

    static /* synthetic */ Server access$002(TestJettyHelper x0, Server x1) {
        x0.server = x1;
        return x0.server;
    }

    static /* synthetic */ Server access$100(TestJettyHelper x0) {
        return x0.createJettyServer();
    }

    static /* synthetic */ ThreadLocal access$200() {
        return TEST_JETTY_TL;
    }

    static /* synthetic */ Server access$000(TestJettyHelper x0) {
        return x0.server;
    }
}

