/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.classification.InterfaceAudience;
import org.slf4j.MDC;

@Provider
@InterfaceAudience.Private
public class UserProvider
extends AbstractHttpContextInjectable<Principal>
implements InjectableProvider<Context, Type> {
    public static final String USER_NAME_PARAM = "user.name";
    public static final String USER_PATTERN_KEY = "httpfs.user.provider.user.pattern";
    public static final String USER_PATTERN_DEFAULT = "^[A-Za-z_][A-Za-z0-9._-]*[$]?$";
    private static Pattern userPattern = Pattern.compile("^[A-Za-z_][A-Za-z0-9._-]*[$]?$");

    public static void setUserPattern(String pattern) {
        userPattern = Pattern.compile(pattern);
    }

    public static Pattern getUserPattern() {
        return userPattern;
    }

    public Principal getValue(HttpContext httpContext) {
        String user;
        Principal principal = httpContext.getRequest().getUserPrincipal();
        if (principal == null && (user = (String)httpContext.getRequest().getQueryParameters().getFirst((Object)USER_NAME_PARAM)) != null) {
            principal = new /* Unavailable Anonymous Inner Class!! */;
        }
        if (principal != null) {
            MDC.put((String)"user", (String)principal.getName());
        }
        return principal;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Injectable getInjectable(ComponentContext componentContext, Context context, Type type) {
        return type.equals(Principal.class) ? this : null;
    }
}

