/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.util.ConfigurationUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationUtils {
    @Test
    public void constructors() throws Exception {
        Configuration conf = new Configuration(false);
        Assert.assertEquals((long)conf.size(), (long)0L);
        byte[] bytes = "<configuration><property><name>a</name><value>A</value></property></configuration>".getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        conf = new Configuration(false);
        ConfigurationUtils.load((Configuration)conf, (InputStream)is);
        Assert.assertEquals((long)conf.size(), (long)1L);
        Assert.assertEquals((Object)conf.get("a"), (Object)"A");
    }

    @Test(expected=IOException.class)
    public void constructorsFail3() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("<xonfiguration></xonfiguration>".getBytes());
        Configuration conf = new Configuration(false);
        ConfigurationUtils.load((Configuration)conf, (InputStream)is);
    }

    @Test
    public void copy() throws Exception {
        Configuration srcConf = new Configuration(false);
        Configuration targetConf = new Configuration(false);
        srcConf.set("testParameter1", "valueFromSource");
        srcConf.set("testParameter2", "valueFromSource");
        targetConf.set("testParameter2", "valueFromTarget");
        targetConf.set("testParameter3", "valueFromTarget");
        ConfigurationUtils.copy((Configuration)srcConf, (Configuration)targetConf);
        Assert.assertEquals((Object)"valueFromSource", (Object)targetConf.get("testParameter1"));
        Assert.assertEquals((Object)"valueFromSource", (Object)targetConf.get("testParameter2"));
        Assert.assertEquals((Object)"valueFromTarget", (Object)targetConf.get("testParameter3"));
    }

    @Test
    public void injectDefaults() throws Exception {
        Configuration srcConf = new Configuration(false);
        Configuration targetConf = new Configuration(false);
        srcConf.set("testParameter1", "valueFromSource");
        srcConf.set("testParameter2", "valueFromSource");
        targetConf.set("testParameter2", "originalValueFromTarget");
        targetConf.set("testParameter3", "originalValueFromTarget");
        ConfigurationUtils.injectDefaults((Configuration)srcConf, (Configuration)targetConf);
        Assert.assertEquals((Object)"valueFromSource", (Object)targetConf.get("testParameter1"));
        Assert.assertEquals((Object)"originalValueFromTarget", (Object)targetConf.get("testParameter2"));
        Assert.assertEquals((Object)"originalValueFromTarget", (Object)targetConf.get("testParameter3"));
        Assert.assertEquals((Object)"valueFromSource", (Object)srcConf.get("testParameter1"));
        Assert.assertEquals((Object)"valueFromSource", (Object)srcConf.get("testParameter2"));
        Assert.assertNull((Object)srcConf.get("testParameter3"));
    }

    @Test
    public void resolve() {
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "${a}");
        Assert.assertEquals((Object)conf.getRaw("a"), (Object)"A");
        Assert.assertEquals((Object)conf.getRaw("b"), (Object)"${a}");
        conf = ConfigurationUtils.resolve((Configuration)conf);
        Assert.assertEquals((Object)conf.getRaw("a"), (Object)"A");
        Assert.assertEquals((Object)conf.getRaw("b"), (Object)"A");
    }

    @Test
    public void testVarResolutionAndSysProps() {
        String userName = System.getProperty("user.name");
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "${a}");
        conf.set("c", "${user.name}");
        conf.set("d", "${aaa}");
        Assert.assertEquals((Object)conf.getRaw("a"), (Object)"A");
        Assert.assertEquals((Object)conf.getRaw("b"), (Object)"${a}");
        Assert.assertEquals((Object)conf.getRaw("c"), (Object)"${user.name}");
        Assert.assertEquals((Object)conf.get("a"), (Object)"A");
        Assert.assertEquals((Object)conf.get("b"), (Object)"A");
        Assert.assertEquals((Object)conf.get("c"), (Object)userName);
        Assert.assertEquals((Object)conf.get("d"), (Object)"${aaa}");
        conf.set("user.name", "foo");
        Assert.assertEquals((Object)conf.get("user.name"), (Object)"foo");
    }
}

