/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.hdfs.web.SWebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.lib.lang.XException;
import org.apache.hadoop.lib.server.BaseService;
import org.apache.hadoop.lib.server.ServerException;
import org.apache.hadoop.lib.server.ServiceException;
import org.apache.hadoop.lib.service.DelegationTokenIdentifier;
import org.apache.hadoop.lib.service.DelegationTokenManager;
import org.apache.hadoop.lib.service.DelegationTokenManagerException;
import org.apache.hadoop.lib.service.security.DelegationTokenManagerService;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

@InterfaceAudience.Private
public class DelegationTokenManagerService
extends BaseService
implements DelegationTokenManager {
    private static final String PREFIX = "delegation.token.manager";
    private static final String UPDATE_INTERVAL = "update.interval";
    private static final String MAX_LIFETIME = "max.lifetime";
    private static final String RENEW_INTERVAL = "renew.interval";
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    DelegationTokenSecretManager secretManager = null;
    private Text tokenKind;

    public DelegationTokenManagerService() {
        super(PREFIX);
    }

    protected void init() throws ServiceException {
        long updateInterval = this.getServiceConfig().getLong(UPDATE_INTERVAL, 86400000L);
        long maxLifetime = this.getServiceConfig().getLong(MAX_LIFETIME, 604800000L);
        long renewInterval = this.getServiceConfig().getLong(RENEW_INTERVAL, 86400000L);
        this.tokenKind = HttpFSServerWebApp.get().isSslEnabled() ? SWebHdfsFileSystem.TOKEN_KIND : WebHdfsFileSystem.TOKEN_KIND;
        this.secretManager = new DelegationTokenSecretManager(this.tokenKind, updateInterval, maxLifetime, renewInterval, 3600000L);
        try {
            this.secretManager.startThreads();
        }
        catch (IOException ex) {
            throw new ServiceException((XException.ERROR)ServerException.ERROR.S12, new Object[]{DelegationTokenManager.class.getSimpleName(), ex.toString(), ex});
        }
    }

    public void destroy() {
        this.secretManager.stopThreads();
        super.destroy();
    }

    public Class getInterface() {
        return DelegationTokenManager.class;
    }

    public Token<DelegationTokenIdentifier> createToken(UserGroupInformation ugi, String renewer) throws DelegationTokenManagerException {
        renewer = renewer == null ? ugi.getShortUserName() : renewer;
        String user = ugi.getUserName();
        Text owner = new Text(user);
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        DelegationTokenIdentifier tokenIdentifier = new DelegationTokenIdentifier(this.tokenKind, owner, new Text(renewer), realUser);
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)this.secretManager);
        try {
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)HttpFSServerWebApp.get().getAuthority());
        }
        catch (ServerException ex) {
            throw new DelegationTokenManagerException(DelegationTokenManagerException.ERROR.DT04, new Object[]{ex.toString(), ex});
        }
        return token;
    }

    public long renewToken(Token<DelegationTokenIdentifier> token, String renewer) throws DelegationTokenManagerException {
        try {
            return this.secretManager.renewToken(token, renewer);
        }
        catch (IOException ex) {
            throw new DelegationTokenManagerException(DelegationTokenManagerException.ERROR.DT02, new Object[]{ex.toString(), ex});
        }
    }

    public void cancelToken(Token<DelegationTokenIdentifier> token, String canceler) throws DelegationTokenManagerException {
        try {
            this.secretManager.cancelToken(token, canceler);
        }
        catch (IOException ex) {
            throw new DelegationTokenManagerException(DelegationTokenManagerException.ERROR.DT03, new Object[]{ex.toString(), ex});
        }
    }

    public UserGroupInformation verifyToken(Token<DelegationTokenIdentifier> token) throws DelegationTokenManagerException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream dis = new DataInputStream(buf);
        DelegationTokenIdentifier id = new DelegationTokenIdentifier(this.tokenKind);
        try {
            id.readFields((DataInput)dis);
            dis.close();
            this.secretManager.verifyToken((AbstractDelegationTokenIdentifier)id, token.getPassword());
        }
        catch (Exception ex) {
            throw new DelegationTokenManagerException(DelegationTokenManagerException.ERROR.DT01, new Object[]{ex.toString(), ex});
        }
        return id.getUser();
    }
}

